/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.registration.ICreativeTabProvider;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.IAbstractToolMethods;
import org.gtreimagined.gtlib.tool.armor.GTArmorType;
import org.jetbrains.annotations.Nullable;

public interface IGTArmor
extends IGTObject,
IColorHandler,
ITextureProvider,
IModelProvider,
IAbstractToolMethods,
ICreativeTabProvider {
    public GTArmorType getGTArmorType();

    public Material getMat();

    public ItemStack asItemStack();

    default public Item getItem() {
        return (Item)this;
    }

    @Override
    default public boolean allowedIn(ResourceKey<CreativeModeTab> tab) {
        return tab == this.getGTArmorType().getItemGroup();
    }

    default public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (this.getGTArmorType().getTooltip().size() != 0) {
            tooltip.addAll(this.getGTArmorType().getTooltip());
        }
    }

    default public void appendEnchantmentNames(List<Component> tooltipComponents, Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> enchantment : enchantments.entrySet()) {
            tooltipComponents.add(enchantment.getKey().m_44700_(enchantment.getValue().intValue()));
        }
    }

    @Override
    default public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 && this.getMat() != null ? this.getMat().getRGB() : -1;
    }

    @Override
    default public Texture[] getTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        int layers = this.getGTArmorType().getOverlayLayers();
        textures.add(new Texture("gtlib", "item/tool/".concat(this.getGTArmorType().getId())));
        if (layers == 1) {
            textures.add(new Texture("gtlib", "item/tool/overlay/".concat(this.getGTArmorType().getId())));
        }
        if (layers > 1) {
            for (int i = 1; i <= layers; ++i) {
                textures.add(new Texture("gtlib", String.join((CharSequence)"", "item/tool/overlay/", this.getGTArmorType().getId(), "_", Integer.toString(i))));
            }
        }
        return textures.toArray(new Texture[textures.size()]);
    }

    @Override
    default public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        if (this.getGTArmorType().getArmorType() == ArmorItem.Type.HELMET) {
            String id = this.getId();
            GTItemModelBuilder builder = (GTItemModelBuilder)prov.getBuilder(id + "_probe");
            builder.parent(new ResourceLocation("minecraft", "item/handheld"));
            Texture[] textures = this.getTextures();
            for (int i = 0; i < textures.length + 1; ++i) {
                if (i == textures.length) {
                    builder.texture("layer" + i, new Texture("gtlib", "item/tool/overlay/".concat(this.getGTArmorType().getId()).concat("_probe")));
                    continue;
                }
                builder.texture("layer" + i, textures[i]);
            }
            prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures()).override().predicate(new ResourceLocation("gtlib", "probe"), 1.0f).model(new ResourceLocation("gt", "item/" + id + "_probe")).end();
            return;
        }
        prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures());
    }
}

