/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.map;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.Holder;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.integration.xei.renderer.IRecipeInfoRenderer;
import org.gtreimagined.gtlib.integration.xei.renderer.InfoRenderers;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.map.Proxy;
import org.gtreimagined.gtlib.recipe.map.SubCategory;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRecipeMap
extends ISharedGTObject {
    public static final ItemStack[] EMPTY_ITEM = new ItemStack[0];
    public static final FluidStack[] EMPTY_FLUID = new FluidStack[0];

    public IRecipe find(@NotNull ItemStack[] var1, @NotNull FluidStack[] var2, Tier var3, @NotNull Predicate<IRecipe> var4);

    default public IRecipe findByID(ResourceLocation id) {
        return this.getRecipes(false).stream().filter(r -> r.m_6423_().equals((Object)id)).findFirst().orElse(null);
    }

    public void add(IRecipe var1);

    public void compileRecipe(IRecipe var1);

    public void compile(RecipeManager var1);

    public void resetCompiled();

    public Collection<IRecipe> getRecipes(boolean var1);

    public boolean acceptsItem(ItemStack var1);

    public boolean acceptsFluid(FluidStack var1);

    public RecipeType<? extends IRecipe> getRecipeType();

    public Map<String, SubCategory> getSubCategories();

    @Nullable
    default public Tier getGuiTier() {
        return null;
    }

    default public Object getIcon() {
        return null;
    }

    default public <T extends BlockEntityMachine<T>> IRecipe find(Holder<IItemHandler, MachineItemHandler<T>> itemHandler, Holder<IFluidHandler, MachineFluidHandler<T>> fluidHandler, Tier tier, Predicate<IRecipe> validateRecipe) {
        return this.find(itemHandler.map(MachineItemHandler::getInputs).orElse(EMPTY_ITEM), fluidHandler.map(FluidHandler::getInputs).orElse(EMPTY_FLUID), tier, validateRecipe);
    }

    default public IRecipe find(@NotNull Optional<MachineItemHandler<?>> itemHandler, @NotNull Optional<MachineFluidHandler<?>> fluidHandler, Tier tier, Predicate<IRecipe> validator) {
        return this.find(itemHandler.map(MachineItemHandler::getInputs).orElse(EMPTY_ITEM), fluidHandler.map(FluidHandler::getInputs).orElse(EMPTY_FLUID), tier, validator);
    }

    @Nullable
    default public GuiData getGui() {
        return null;
    }

    default public Proxy getProxy() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    default public IRecipeInfoRenderer getInfoRenderer() {
        return InfoRenderers.DEFAULT_RENDERER;
    }

    default public Component getDisplayName() {
        return Utils.translatable("jei.category." + this.getLoc().m_135815_(), new Object[0]);
    }
}

