/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityCable;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockCable<T extends Cable<T>>
extends BlockPipe<T> {
    public static final int INSULATION_COLOR = 0x404040;
    public final boolean insulated;

    public BlockCable(T type, PipeSize size, boolean insulated) {
        super(type, size, 2);
        this.insulated = insulated;
        String prefix = insulated ? "cable" : "wire";
        this.side = new Texture("gtlib", "block/pipe/" + prefix + "_side");
        this.faces = new Texture[]{new Texture("gtlib", "block/pipe/wire_vtiny"), new Texture("gtlib", "block/pipe/wire_tiny"), new Texture("gtlib", "block/pipe/wire_small"), new Texture("gtlib", "block/pipe/wire_normal"), new Texture("gtlib", "block/pipe/wire_large"), new Texture("gtlib", "block/pipe/wire_huge")};
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 300;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    @Override
    public GTToolType getToolType() {
        return GTTools.WIRE_CUTTER;
    }

    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        if (!(state.m_60734_() instanceof BlockCable) && world == null || pos == null) {
            return -1;
        }
        BlockEntityPipe<?> pipe = BlockCable.getTilePipe(world, pos);
        if (this.insulated && pipe != null && pipe.getPipeColor() != -1 && i == 0) {
            return pipe.getPipeColor();
        }
        if (this.insulated) {
            return i == 1 ? this.getRGB() : (i == 0 ? 0x404040 : -1);
        }
        return i == 0 || i == 1 ? this.getRGB() : -1;
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (this.insulated && stack.m_41783_() != null && stack.m_41783_().m_128441_("co") && i == 0) {
            return stack.m_41783_().m_128451_("co");
        }
        return this.insulated ? (i == 1 ? this.getRGB() : (i == 0 ? 0x404040 : -1)) : this.getRGB();
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (worldIn.f_46443_) {
            return;
        }
        if (this.insulated) {
            return;
        }
        if (entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof BlockEntityCable) {
                BlockEntityCable cable = (BlockEntityCable)blockEntity;
                if (cable.getNetwork().cableIsActive.containsKey((Object)worldIn.m_46472_().m_135782_()) && ((LongSet)cable.getNetwork().cableIsActive.get((Object)worldIn.m_46472_().m_135782_())).contains(pos.m_121878_())) {
                    entity.m_6469_(worldIn.m_269111_().m_269264_(), (float)((Cable)this.getType()).getTier().getIntegerId());
                }
            }
        }
    }

    @Override
    public List<String> getInfo(List<String> info, Level world, BlockState state, BlockPos pos, boolean simple) {
        return info;
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Utils.translatable("generic.amp", new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal(String.valueOf(((Cable)this.type).getAmps(this.size))).m_130940_(ChatFormatting.GREEN)));
        tooltip.add((Component)Utils.translatable("generic.voltage", new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal(String.valueOf(((Cable)this.type).getTier().getVoltage())).m_130940_(ChatFormatting.BLUE)));
        tooltip.add((Component)Utils.translatable("generic.loss", new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal(String.valueOf(((Cable)this.type).getLoss())).m_130940_(ChatFormatting.BLUE)));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.more", new Object[0]).m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            tooltip.add((Component)Utils.literal("----------"));
            tooltip.add((Component)Utils.translatable("gtlib.pipe.cable.info", new Object[0]).m_130940_(ChatFormatting.DARK_AQUA));
            tooltip.add((Component)Utils.literal("----------"));
        }
    }
}

