/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.machine.types;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTCreativeTabs;
import org.gtreimagined.gtlib.block.GTItemBlock;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.client.GTLibModelManager;
import org.gtreimagined.gtlib.client.dynamic.IDynamicModelProvider;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.BarDir;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.MenuHandler;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.slot.ISlotProvider;
import org.gtreimagined.gtlib.gui.widget.BackgroundWidget;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.IMachineColorHandlerBlock;
import org.gtreimagined.gtlib.machine.IMachineColorHandlerItem;
import org.gtreimagined.gtlib.machine.IShapeGetter;
import org.gtreimagined.gtlib.machine.ITooltipInfo;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.structure.Structure;
import org.gtreimagined.gtlib.structure.StructureBuilder;
import org.gtreimagined.gtlib.texture.IOverlayModeler;
import org.gtreimagined.gtlib.texture.IOverlayTexturer;
import org.gtreimagined.gtlib.texture.ITextureHandler;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Dir;
import org.gtreimagined.gtlib.util.Utils;

public class Machine<T extends Machine<T>>
implements IGTObject,
IRegistryEntryProvider,
ISlotProvider<Machine<T>>,
IGuiHandler.IHaveWidgets,
IDynamicModelProvider {
    protected BlockEntityType<? extends BlockEntityMachine<?>> tileType;
    protected BlockEntityBase.BlockEntitySupplier<BlockEntityMachine<?>, T> tileFunc = BlockEntityMachine::new;
    protected BiFunction<Machine<T>, Tier, BlockMachine> blockFunc = BlockMachine::new;
    protected Function<BlockMachine, GTItemBlock> itemBlockFunction = GTItemBlock::new;
    protected Supplier<Class<? extends BlockMachine>> itemClassSupplier = () -> BlockMachine.class;
    protected TagKey<Block> toolTag = GTTools.WRENCH.getToolType();
    protected List<ITooltipInfo> tooltipFunctions = new ArrayList<ITooltipInfo>();
    protected IShapeGetter shapeGetter;
    protected String domain;
    protected String id;
    protected List<Tier> tiers;
    protected Map<String, IRecipeMap> tierRecipeMaps = new Object2ObjectOpenHashMap();
    protected GuiData guiData;
    protected ResourceKey<CreativeModeTab> group = GTCreativeTabs.MACHINES.getKey();
    protected ITextureHandler baseTexture;
    protected IOverlayTexturer overlayTextures;
    protected IOverlayModeler overlayModels;
    protected ResourceLocation itemModelParent;
    protected IMachineColorHandlerBlock blockColorHandler = (state, world, pos, machine, i) -> -1;
    protected IMachineColorHandlerItem itemColorHandler = (stack, block, i) -> -1;
    protected ResourceLocation modelLoader = GTLibModelManager.LOADER_MACHINE;
    protected boolean tierSpecificLang = false;
    public SoundEvent machineNoise;
    public float soundVolume;
    protected Object2ObjectMap<Tier, Structure> structures = new Object2ObjectOpenHashMap();
    protected ToIntFunction<Tier> efficiency = t -> 100 - 5 * (4 - t.getIntegerId());
    protected int amps = 1;
    protected boolean allowsFrontCovers = false;
    protected boolean allowsOutputCoversOnFacing = false;
    protected boolean verticalFacingAllowed = false;
    protected boolean noFacing = false;
    protected boolean noTextureRotation = false;
    protected boolean allowsFrontIO = false;
    protected boolean noOverclockCost = false;
    protected boolean clientTicking = false;
    protected boolean ambientTicking = false;
    protected boolean renderAsTesr = false;
    protected boolean rendersContainedLiquids = false;
    protected boolean rendersContainedLiquidLevel = false;
    protected int overlayLayers = 1;
    protected CoverFactory outputCover = Data.COVEROUTPUT;
    protected Dir outputDir = Dir.BACK;
    protected CoverFactory secondaryOutputCover = ICover.emptyFactory;
    protected Dir secondaryOutputDir = Dir.FORWARD;
    private final Map<String, Object2IntOpenHashMap<SlotType<?>>> countLookup = new Object2ObjectOpenHashMap();
    private final Map<String, List<SlotData<?>>> slotLookup = new Object2ObjectOpenHashMap();
    private final List<Consumer<GuiInstance>> callbacks = new ObjectArrayList(1);
    private static final Map<String, Set<Machine<?>>> FLAG_MAP = new Object2ObjectOpenHashMap();
    public static final IOverlayTexturer TROLL_OVERLAY_HANDLER = (type, state, tier, i) -> new Texture[]{new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll")};
    public static final ITextureHandler TROLL_BASE_HANDLER = (type, tier, state) -> new Texture[]{new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll"), new Texture("gtlib", "block/machine/troll")};

    public Machine(String domain, String id) {
        this.domain = domain;
        this.id = id;
        this.overlayTextures = (type, state, tier, i) -> {
            String stateDir = (state = state.getTextureState()) == MachineState.IDLE ? "" : state.getId() + "/";
            return new Texture[]{new Texture(domain, "block/machine/overlay/" + id + "/" + stateDir + "bottom"), new Texture(domain, "block/machine/overlay/" + id + "/" + stateDir + "top"), new Texture(domain, "block/machine/overlay/" + id + "/" + stateDir + "back"), new Texture(domain, "block/machine/overlay/" + id + "/" + stateDir + "front"), new Texture(domain, "block/machine/overlay/" + id + "/" + stateDir + "side"), new Texture(domain, "block/machine/overlay/" + id + "/" + stateDir + "side")};
        };
        this.baseTexture = (m, tier, state) -> new Texture[]{tier.getBaseTexture(m.getDomain())};
        this.overlayModels = (a, s, d) -> new ResourceLocation("gtlib", "block/machine/overlay/invalid/" + d.m_122433_());
        this.itemModelParent = new ResourceLocation("gtlib", "block/preset/layered");
        this.tiers = Arrays.asList(Tier.getStandard());
        GTAPI.register(Machine.class, this);
        this.setupGui();
    }

    protected void setupGui() {
        this.addGuiCallback(t -> t.addWidget(BackgroundWidget.build(t.handler.getGuiTexture(), t.handler.guiSize(), t.handler.guiHeight(), t.handler.guiTextureSize(), t.handler.guiTextureHeight())));
    }

    public Direction handlePlacementFacing(BlockPlaceContext ctxt, Property<?> which, Direction dir) {
        return dir;
    }

    @Override
    public void onRegistryBuild(ResourceKey<? extends Registry<?>> registry) {
        if (registry != ForgeRegistries.Keys.BLOCKS) {
            return;
        }
        this.tileType = new BlockEntityType(new BlockEntityBase.BlockEntityGetter(this.tileFunc, this), this.tiers.stream().map(t -> this.getBlock(this, (Tier)t)).collect(Collectors.toSet()), null);
        GTAPI.register(BlockEntityType.class, this.getId(), this.getDomain(), this.getTileType());
    }

    public void registerJei() {
        if (this.guiData != null) {
            this.tierRecipeMaps.forEach((s, r) -> {
                if (s.isEmpty()) {
                    for (int i = 0; i < this.tiers.size(); ++i) {
                        Tier tier = this.tiers.get(i);
                        if (i == 0 && r.getGui() == null && !GTLibXEIPlugin.containsCategory(r)) {
                            GTAPI.registerJEICategory(r, this.guiData, this, tier, false);
                            continue;
                        }
                        GTAPI.registerJEICategoryWorkstation(r, this, tier);
                    }
                    return;
                }
                Tier t = GTAPI.get(Tier.class, s);
                if (r.getGui() == null && !GTLibXEIPlugin.containsCategory(r)) {
                    GTAPI.registerJEICategory(r, this.guiData, this, t, false);
                } else {
                    GTAPI.registerJEICategoryWorkstation(r, this, t);
                }
            });
        }
    }

    public T setAmps(int amps) {
        this.amps = amps;
        return (T)this;
    }

    public T setEfficiency(ToIntFunction<Tier> function) {
        this.efficiency = function;
        return (T)this;
    }

    public T setAllowsFrontCovers() {
        this.allowsFrontCovers = true;
        return (T)this;
    }

    public T setAllowsOutputCoversOnFacing(boolean allow) {
        this.allowsOutputCoversOnFacing = allow;
        return (T)this;
    }

    public T setSound(SoundEvent loc, float volume) {
        this.soundVolume = volume;
        this.machineNoise = loc;
        return (T)this;
    }

    public T setTierSpecificLang() {
        this.tierSpecificLang = true;
        return (T)this;
    }

    public T setOutputCover(CoverFactory cover) {
        this.outputCover = cover;
        return (T)this;
    }

    public T setOutputDir(Dir dir) {
        this.outputDir = dir;
        return (T)this;
    }

    public T setSecondaryOutputCover(CoverFactory cover) {
        this.secondaryOutputCover = cover;
        return (T)this;
    }

    public T setSecondaryOutputDir(Dir dir) {
        this.secondaryOutputDir = dir;
        return (T)this;
    }

    public T setNoOutputCover() {
        this.setOutputCover(ICover.emptyFactory);
        return (T)this;
    }

    public T setAllowsFrontIO() {
        this.allowsFrontIO = true;
        return (T)this;
    }

    public T addTier(Tier tier) {
        List<Tier> tiers = this.getTiers();
        tiers.add(tier);
        this.setTiers(!tiers.isEmpty() ? tiers.toArray(new Tier[0]) : Tier.getStandard());
        return (T)this;
    }

    public T setMap(IRecipeMap map, Tier ... tiers) {
        if (tiers.length == 0) {
            this.tierRecipeMaps.put("", map);
        } else {
            for (Tier tier : tiers) {
                this.tierRecipeMaps.put(tier.getId(), map);
            }
        }
        this.addFlags("recipe");
        this.registerJei();
        return (T)this;
    }

    public T setBaseTexture(Texture tex) {
        this.baseTexture = (m, tier, state) -> new Texture[]{tex};
        return (T)this;
    }

    public T setOverlayTextures(IOverlayTexturer texturer) {
        this.overlayTextures = texturer;
        return (T)this;
    }

    public T setBaseTexture(ITextureHandler handler) {
        this.baseTexture = handler;
        return (T)this;
    }

    public T setItemModelParent(ResourceLocation parent) {
        this.itemModelParent = parent;
        return (T)this;
    }

    public T setBlockColorHandler(IMachineColorHandlerBlock handlerBlock) {
        this.blockColorHandler = handlerBlock;
        return (T)this;
    }

    public T setItemColorHandler(IMachineColorHandlerItem handlerItem) {
        this.itemColorHandler = handlerItem;
        return (T)this;
    }

    public T setModelLoader(ResourceLocation modelLoader) {
        this.modelLoader = modelLoader;
        return (T)this;
    }

    public T setItemGroup(ResourceKey<CreativeModeTab> group) {
        this.group = group;
        return (T)this;
    }

    public T setTile(BlockEntityBase.BlockEntitySupplier<BlockEntityMachine<?>, T> func) {
        this.tileFunc = func;
        return (T)this;
    }

    public T setBlock(BiFunction<Machine<T>, Tier, BlockMachine> function) {
        this.blockFunc = function;
        return (T)this;
    }

    public T setItemBlockClass(Supplier<Class<? extends BlockMachine>> function) {
        this.itemClassSupplier = function;
        return (T)this;
    }

    public T setItemBlock(Function<BlockMachine, GTItemBlock> function) {
        this.itemBlockFunction = function;
        return (T)this;
    }

    public T setToolTag(TagKey<Block> toolTag) {
        this.toolTag = toolTag;
        return (T)this;
    }

    public T addTooltipInfo(String translationKey) {
        return this.addTooltipInfo((BlockMachine m, ItemStack s, BlockGetter w, List<Component> t, TooltipFlag f) -> t.add(Utils.translatable(translationKey, new Object[0])));
    }

    public T addTooltipInfo(Component tooltip) {
        return this.addTooltipInfo((BlockMachine m, ItemStack s, BlockGetter w, List<Component> t, TooltipFlag f) -> t.add(tooltip));
    }

    public T addTooltipInfo(ITooltipInfo info) {
        this.tooltipFunctions.add(info);
        return (T)this;
    }

    public T setCustomShape(VoxelShape shape) {
        this.shapeGetter = (state, world, pos, context) -> shape;
        return (T)this;
    }

    public T setCustomShape(IShapeGetter shapeGetter) {
        this.shapeGetter = shapeGetter;
        return (T)this;
    }

    public T setVerticalFacingAllowed(boolean verticalFacingAllowed) {
        this.verticalFacingAllowed = verticalFacingAllowed;
        return (T)this;
    }

    public T setNoFacing(boolean noFacing) {
        this.noFacing = noFacing;
        if (noFacing) {
            this.setAllowsFrontIO();
            this.setAllowsFrontCovers();
        }
        return (T)this;
    }

    public T setNoTextureRotation(boolean noTextureRotation) {
        this.noTextureRotation = noTextureRotation;
        return (T)this;
    }

    public T setNoOverclockCost(boolean noOverclockCost) {
        this.noOverclockCost = true;
        return (T)this;
    }

    public T setClientTicking() {
        this.clientTicking = true;
        return (T)this;
    }

    public T setAmbientTicking() {
        this.ambientTicking = true;
        return (T)this;
    }

    public T setCustomModel() {
        return this.setCustomModel(IOverlayModeler.defaultOverride);
    }

    public T setCustomModel(IOverlayModeler modeler) {
        this.overlayModels = modeler;
        return (T)this;
    }

    public T addFlags(String ... flags) {
        for (String flag : flags) {
            FLAG_MAP.computeIfAbsent(flag, s -> new ObjectOpenHashSet()).add(this);
        }
        return (T)this;
    }

    public T removeFlags(String ... flags) {
        for (String flag : flags) {
            FLAG_MAP.computeIfAbsent(flag, s -> new ObjectOpenHashSet()).remove(this);
        }
        return (T)this;
    }

    public void setFlags(String ... flags) {
        FLAG_MAP.forEach((s, m) -> m.remove(this));
        this.addFlags(flags);
    }

    public T setTiers(Tier ... tiers) {
        boolean none = false;
        for (Tier t : tiers) {
            if (t != Tier.NONE) continue;
            none = true;
        }
        if (none) {
            this.setTierSpecificLang();
        }
        this.tiers = new ObjectArrayList(Arrays.asList(tiers));
        return (T)this;
    }

    public void setGUI(MenuHandler<?> menuHandler) {
        this.guiData = new GuiData(this, menuHandler);
        this.guiData.setSlots(this);
        this.registerJei();
    }

    public T setGuiProgressBarForJEI(BarDir dir, boolean barFill) {
        this.guiData.getMachineData().setDir(dir);
        this.guiData.getMachineData().setBarFill(barFill);
        return (T)this;
    }

    public T setGuiTiers(ImmutableMap.Builder<Tier, Tier> tiers) {
        this.guiData.setTieredGui(tiers);
        return (T)this;
    }

    public <U extends BlockEntityBasicMultiMachine<U>> void setStructure(Class<U> clazz, Function<StructureBuilder<U>, Structure> func) {
        this.getTiers().forEach(t -> this.setStructure(clazz, (Tier)t, func));
    }

    public <U extends BlockEntityBasicMultiMachine<U>> void setStructure(Class<U> clazz, Tier tier, Function<StructureBuilder<U>, Structure> func) {
        this.structures.put((Object)tier, (Object)func.apply(new StructureBuilder()));
    }

    public T setRenderAsTesr() {
        this.renderAsTesr = true;
        return (T)this;
    }

    public T setRendersContainedLiquids(boolean renderContainedLiquidLevel) {
        this.rendersContainedLiquids = true;
        this.rendersContainedLiquidLevel = renderContainedLiquidLevel;
        return this.setRenderAsTesr();
    }

    public boolean has(String flag) {
        return FLAG_MAP.containsKey(flag) && FLAG_MAP.get(flag).contains(this);
    }

    protected Block getBlock(Machine<T> type, Tier tier) {
        return this.blockFunc.apply(type, tier);
    }

    public BlockMachine getBlockState(Tier tier) {
        if (this.tileType == null) {
            return null;
        }
        return GTAPI.get(this.itemClassSupplier.get(), this.getIdFromTier(tier), this.getDomain());
    }

    public Item getItem(Tier tier) {
        return (Item)BlockItem.f_41373_.get(GTAPI.get(this.itemClassSupplier.get(), this.getIdFromTier(tier), this.getDomain()));
    }

    public String getIdFromTier(Tier tier) {
        return this.id + (String)(tier == Tier.NONE ? "" : "_" + tier.getId());
    }

    public Component getDisplayName(Tier tier) {
        String keyAddition = this.tierSpecificLang ? "." + tier.getId() : "";
        return Utils.translatable("machine." + this.id + keyAddition, Utils.literal(tier.getId().toUpperCase(Locale.ROOT)).m_130940_(tier.getRarityFormatting()));
    }

    public int getMachineEfficiency(Tier tier) {
        return this.efficiency.applyAsInt(tier);
    }

    public List<Texture> getTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        for (Tier tier : this.getTiers()) {
            textures.addAll(Arrays.asList(this.getBaseTexture(tier, MachineState.IDLE)));
            textures.addAll(Arrays.asList(this.getBaseTexture(tier, MachineState.ACTIVE)));
            for (int i = 0; i < this.overlayLayers; ++i) {
                textures.addAll(Arrays.asList(this.getOverlayTextures(MachineState.IDLE, tier, i)));
                textures.addAll(Arrays.asList(this.getOverlayTextures(MachineState.ACTIVE, tier, i)));
            }
        }
        return textures;
    }

    public Texture[] getBaseTexture(Tier tier, MachineState state) {
        return this.getDatedBaseHandler().getBase(this, tier, state);
    }

    public Texture getBaseTexture(Tier tier, Direction dir, MachineState state) {
        Texture[] texes = this.getDatedBaseHandler().getBase(this, tier, state);
        if (texes.length == 1) {
            return texes[0];
        }
        return texes[dir.m_122411_()];
    }

    public Texture[] getOverlayTextures(MachineState state, Tier tier, int index) {
        return this.getDatedOverlayHandler().getOverlays(this, state, tier, index);
    }

    public Texture[] getOverlayTextures(MachineState state, int index) {
        return this.getDatedOverlayHandler().getOverlays(this, state, this.getFirstTier(), index);
    }

    public ResourceLocation getOverlayModel(MachineState state, Direction side) {
        return this.overlayModels.getOverlayModel(this, state, side);
    }

    public IRecipeMap getRecipeMap(Tier tier) {
        if (this.tierRecipeMaps.containsKey(tier.getId())) {
            return this.tierRecipeMaps.get(tier.getId());
        }
        return this.tierRecipeMaps.get("");
    }

    public boolean hasTierSpecificLang() {
        return this.tierSpecificLang;
    }

    public Tier getFirstTier() {
        return this.tiers.get(0);
    }

    public <U extends BlockEntityBasicMultiMachine<U>> Structure<U> getStructure(Tier tier) {
        return (Structure)this.structures.get((Object)tier);
    }

    public static Optional<Machine<?>> get(String name, String domain) {
        Machine machine = GTAPI.get(Machine.class, name, domain);
        return Optional.ofNullable(machine);
    }

    public static Collection<Machine<?>> getTypes(String ... flags) {
        ObjectArrayList types = new ObjectArrayList();
        for (String flag : flags) {
            if (!FLAG_MAP.containsKey(flag)) continue;
            types.addAll((Collection)FLAG_MAP.get(flag));
        }
        return types;
    }

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        return this.getOverlayModel(MachineState.IDLE, dir);
    }

    public static boolean isAprilFools() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        return calendar.get(2) == 3 && calendar.get(5) == 1 || calendar.get(2) == 2 && calendar.get(5) == 31;
    }

    private IOverlayTexturer getDatedOverlayHandler() {
        return Machine.isAprilFools() ? TROLL_OVERLAY_HANDLER : this.overlayTextures;
    }

    private ITextureHandler getDatedBaseHandler() {
        return Machine.isAprilFools() ? TROLL_BASE_HANDLER : this.baseTexture;
    }

    @Override
    public String getLang(String lang) {
        return Utils.lowerUnderscoreToUpperSpaced(this.getId());
    }

    @Generated
    public BlockEntityType<? extends BlockEntityMachine<?>> getTileType() {
        return this.tileType;
    }

    @Generated
    public Function<BlockMachine, GTItemBlock> getItemBlockFunction() {
        return this.itemBlockFunction;
    }

    @Generated
    public TagKey<Block> getToolTag() {
        return this.toolTag;
    }

    @Generated
    public List<ITooltipInfo> getTooltipFunctions() {
        return this.tooltipFunctions;
    }

    @Generated
    public IShapeGetter getShapeGetter() {
        return this.shapeGetter;
    }

    @Override
    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public List<Tier> getTiers() {
        return this.tiers;
    }

    @Generated
    public GuiData getGuiData() {
        return this.guiData;
    }

    @Generated
    public ResourceKey<CreativeModeTab> getGroup() {
        return this.group;
    }

    @Generated
    public IOverlayTexturer getOverlayTextures() {
        return this.overlayTextures;
    }

    @Generated
    public ResourceLocation getItemModelParent() {
        return this.itemModelParent;
    }

    @Generated
    public IMachineColorHandlerBlock getBlockColorHandler() {
        return this.blockColorHandler;
    }

    @Generated
    public IMachineColorHandlerItem getItemColorHandler() {
        return this.itemColorHandler;
    }

    @Generated
    public ResourceLocation getModelLoader() {
        return this.modelLoader;
    }

    @Generated
    public int getAmps() {
        return this.amps;
    }

    @Generated
    public boolean allowsFrontCovers() {
        return this.allowsFrontCovers;
    }

    @Generated
    public boolean allowsOutputCoversOnFacing() {
        return this.allowsOutputCoversOnFacing;
    }

    @Generated
    public boolean isVerticalFacingAllowed() {
        return this.verticalFacingAllowed;
    }

    @Generated
    public boolean isNoFacing() {
        return this.noFacing;
    }

    @Generated
    public boolean isNoTextureRotation() {
        return this.noTextureRotation;
    }

    @Generated
    public boolean allowsFrontIO() {
        return this.allowsFrontIO;
    }

    @Generated
    public boolean isNoOverclockCost() {
        return this.noOverclockCost;
    }

    @Generated
    public boolean isClientTicking() {
        return this.clientTicking;
    }

    @Generated
    public boolean isAmbientTicking() {
        return this.ambientTicking;
    }

    @Generated
    public boolean renderAsTesr() {
        return this.renderAsTesr;
    }

    @Generated
    public boolean rendersContainedLiquids() {
        return this.rendersContainedLiquids;
    }

    @Generated
    public boolean rendersContainedLiquidLevel() {
        return this.rendersContainedLiquidLevel;
    }

    @Generated
    public int getOverlayLayers() {
        return this.overlayLayers;
    }

    @Generated
    public Machine<T> setOverlayLayers(int overlayLayers) {
        this.overlayLayers = overlayLayers;
        return this;
    }

    @Generated
    public CoverFactory getOutputCover() {
        return this.outputCover;
    }

    @Generated
    public Dir getOutputDir() {
        return this.outputDir;
    }

    @Generated
    public CoverFactory getSecondaryOutputCover() {
        return this.secondaryOutputCover;
    }

    @Generated
    public Dir getSecondaryOutputDir() {
        return this.secondaryOutputDir;
    }

    @Override
    @Generated
    public Map<String, Object2IntOpenHashMap<SlotType<?>>> getCountLookup() {
        return this.countLookup;
    }

    @Override
    @Generated
    public Map<String, List<SlotData<?>>> getSlotLookup() {
        return this.slotLookup;
    }

    @Override
    @Generated
    public List<Consumer<GuiInstance>> getCallbacks() {
        return this.callbacks;
    }
}

