/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.emi;

import dev.emi.emi.api.forge.ForgeEmiStack;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class GTEMIFluidIngredient
implements EmiIngredient {
    final List<EmiStack> fluids;
    final long amount;

    public GTEMIFluidIngredient(FluidIngredient ingredient) {
        this.fluids = new ArrayList<EmiStack>();
        for (FluidStack stack : ingredient.getStacks()) {
            this.fluids.add(ForgeEmiStack.of((FluidStack)stack));
        }
        this.amount = ingredient.getAmount();
    }

    private GTEMIFluidIngredient(List<EmiStack> fluids, long amount) {
        this.fluids = fluids;
        this.amount = amount;
    }

    public List<EmiStack> getEmiStacks() {
        return this.fluids;
    }

    public EmiIngredient copy() {
        ArrayList<EmiStack> stacks = new ArrayList<EmiStack>(this.fluids);
        return new GTEMIFluidIngredient(stacks, this.amount);
    }

    public long getAmount() {
        return this.amount;
    }

    public EmiIngredient setAmount(long l) {
        return new GTEMIFluidIngredient(new ArrayList<EmiStack>(this.fluids), l);
    }

    public float getChance() {
        return 1.0f;
    }

    public EmiIngredient setChance(float v) {
        return this;
    }

    public void render(GuiGraphics graphics, int i, int i1, float v, int i2) {
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
        FluidStack stack = this.getCurrentStack();
        if (stack.isEmpty()) {
            list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Utils.literal("Invalid FLuid Ingredient").m_130940_(ChatFormatting.RED).m_7532_()));
            return list;
        }
        int mb = stack.getAmount();
        list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)stack.getFluid().getFluidType().getDescription(stack).m_7532_()));
        list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Utils.translatable("gtlib.tooltip.fluid.amount", mb + " L").m_130940_(ChatFormatting.BLUE).m_7532_()));
        list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Utils.translatable("gtlib.tooltip.fluid.temp", FluidUtils.getFluidTemperature(stack.getFluid())).m_130940_(ChatFormatting.RED).m_7532_()));
        String liquid = !FluidUtils.isFluidGaseous(stack.getFluid()) ? "liquid" : "gas";
        list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Utils.translatable("gtlib.tooltip.fluid." + liquid, new Object[0]).m_130940_(ChatFormatting.GREEN).m_7532_()));
        return list;
    }

    FluidStack getCurrentStack() {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Object object = this.fluids.get(0).getKey();
        if (object instanceof Fluid) {
            Fluid fluid = (Fluid)object;
            return new FluidStack(fluid, (int)this.amount);
        }
        return FluidStack.EMPTY;
    }
}

