/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.BarDir;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.util.int4;

public class ProgressWidget
extends Widget {
    public final BarDir direction;
    public final boolean barFill;
    ResourceLocation texture;
    private final int4 uv;
    private int progress = 0;
    private int maxProgress = 0;
    private float percent = 0.0f;

    public ProgressWidget(GuiInstance instance, IGuiElement parent) {
        super(instance, parent);
        GuiData gui = instance.handler.getGui();
        this.direction = gui.getMachineData().getDir();
        this.uv = new int4(0, gui.getMachineData().getProgressSize().y, gui.getMachineData().getProgressSize().x, gui.getMachineData().getProgressSize().y);
        this.barFill = gui.getMachineData().doesBarFill();
        this.setX(gui.getMachineData().getProgressPos().x + 6);
        this.setY(gui.getMachineData().getProgressPos().y + 6);
        this.setW(gui.getMachineData().getProgressSize().x);
        this.setH(gui.getMachineData().getProgressSize().y);
        this.texture = gui.getMachineData().getProgressTexture(((BlockEntityMachine)instance.handler).getMachineTier());
    }

    @Override
    public void init() {
        super.init();
        this.gui.syncFloat(() -> ((BlockEntityMachine)((ContainerMachine)this.gui.container).getTile()).recipeHandler.map(MachineRecipeHandler::getClientProgress).orElse(Float.valueOf(0.0f)), i -> {
            this.percent = i.floatValue();
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((BlockEntityMachine)((ContainerMachine)this.gui.container).getTile()).recipeHandler.map(MachineRecipeHandler::getCurrentProgress).orElse(0), i -> {
            this.progress = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((BlockEntityMachine)((ContainerMachine)this.gui.container).getTile()).recipeHandler.map(rec -> rec.getActiveRecipe() == null ? 0 : rec.getActiveRecipe().getDuration()).orElse(0), i -> {
            this.maxProgress = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    public static WidgetSupplier build() {
        return ProgressWidget.builder(ProgressWidget::new);
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        int x = this.realX();
        int y = this.realY();
        int xLocation = this.uv.x;
        int yLocation = this.uv.y;
        int length = this.uv.z;
        int width = this.uv.w;
        switch (this.direction) {
            case TOP: {
                int progressTime = (int)((float)this.uv.w * this.percent);
                if (!this.barFill) {
                    progressTime = width - progressTime;
                }
                y = y + width - progressTime;
                yLocation = yLocation + width - progressTime;
                width = progressTime;
                break;
            }
            case LEFT: {
                int progressTime = (int)((float)this.uv.z * this.percent);
                if (this.barFill) {
                    length = progressTime;
                    break;
                }
                length -= progressTime;
                break;
            }
            case BOTTOM: {
                int progressTime = (int)((float)this.uv.w * this.percent);
                if (this.barFill) {
                    width = progressTime;
                    break;
                }
                width -= progressTime;
                break;
            }
            default: {
                int progressTime = (int)((float)this.uv.z * this.percent);
                if (!this.barFill) {
                    progressTime = length - progressTime;
                }
                x = x + length - progressTime;
                xLocation = xLocation + length - progressTime;
                length = progressTime;
            }
        }
        this.drawTexture(graphics, this.texture, this.realX(), this.realY(), 0, 0, this.uv.z, this.uv.w, this.uv.z, this.uv.w * 2);
        if (this.progress > 0) {
            this.drawTexture(graphics, this.texture, this.realX(), this.realY(), xLocation, yLocation, length, width, this.uv.z, this.uv.w * 2);
        }
    }

    @Override
    public void mouseOver(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(graphics, mouseX, mouseY, partialTicks);
        if (this.isInside(mouseX, mouseY)) {
            this.renderTooltip(graphics, (Component)Utils.translatable("gtlib.gui.show_recipes", new Object[0]), mouseX, mouseY);
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        IGuiHandler iGuiHandler = this.gui.handler;
        if (iGuiHandler instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)iGuiHandler;
            GTLibXEIPlugin.showCategory(machine.getMachineType(), machine.getMachineTier());
        }
    }
}

