/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import java.util.Map;
import java.util.function.BiPredicate;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.slot.AbstractSlot;
import org.gtreimagined.gtlib.gui.slot.SlotCell;
import org.gtreimagined.gtlib.gui.slot.SlotEnergy;
import org.gtreimagined.gtlib.gui.slot.SlotFake;
import org.gtreimagined.gtlib.gui.slot.SlotFakeFluid;
import org.gtreimagined.gtlib.gui.slot.SlotFluidDisplaySettable;
import org.gtreimagined.gtlib.gui.slot.SlotInput;
import org.gtreimagined.gtlib.gui.slot.SlotOutput;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;

public class SlotType<T extends Slot>
implements IGTObject,
IMachineEvent {
    public static SlotType<SlotInput> IT_IN = new SlotType<SlotInput>("item_in", (type, gui, inv, i, d) -> new SlotInput(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), new ItIn(), true, false);
    public static SlotType<SlotOutput> IT_OUT = new SlotType<SlotOutput>("item_out", (type, gui, inv, i, d) -> new SlotOutput(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> false, false, true);
    public static SlotType<SlotFake> DISPLAY = new SlotType<SlotFake>("display", (type, gui, item, i, d) -> new SlotFake(type, gui, (IItemHandler)item.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY(), false), (t, i) -> false, false, false);
    public static SlotType<SlotFake> DISPLAY_SETTABLE = new SlotType<SlotFake>("display_settable", (type, gui, item, i, d) -> new SlotFake(type, gui, (IItemHandler)item.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY(), true), (t, i) -> false, true, false);
    public static SlotType<SlotFake> FLUID_DISPLAY_SETTABLE = new SlotType<SlotFake>("fluid_display_settable", (type, gui, item, i, d) -> new SlotFluidDisplaySettable(type, gui, (IItemHandler)item.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> false, true, false, new ResourceLocation("gtlib", "fluid"));
    public static SlotType<AbstractSlot<?>> STORAGE = new SlotType<AbstractSlot>("storage", (type, gui, item, i, d) -> new AbstractSlot(type, gui, (IItemHandler)item.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> true);
    public static SlotType<SlotFakeFluid> FL_IN = new SlotType<SlotFakeFluid>("fluid_in", (type, gui, inv, i, d) -> new SlotFakeFluid(type, gui, FluidHandler.FluidDirection.INPUT, i, d.getX(), d.getY()), (t, i) -> false, false, false, new ResourceLocation("gtlib", "fluid_in"));
    public static SlotType<SlotFakeFluid> FL_OUT = new SlotType<SlotFakeFluid>("fluid_out", (type, gui, inv, i, d) -> new SlotFakeFluid(type, gui, FluidHandler.FluidDirection.OUTPUT, i, d.getX(), d.getY()), (t, i) -> false, false, false, new ResourceLocation("gtlib", "fluid_out"));
    public static SlotType<SlotCell> CELL_IN = new SlotType<SlotCell>("cell_in", (type, gui, inv, i, d) -> new SlotCell(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> i.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent(), true, false, new ResourceLocation("gtlib", "cell_in"));
    public static SlotType<SlotCell> CELL_OUT = new SlotType<SlotCell>("cell_out", (type, gui, inv, i, d) -> new SlotCell(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> i.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent(), false, true, new ResourceLocation("gtlib", "cell_out"));
    public static SlotType<SlotEnergy> ENERGY = new SlotType<SlotEnergy>("energy", (type, gui, inv, i, d) -> new SlotEnergy(type, gui, (IItemHandler)inv.getOrDefault(type, new EmptyHandler()), i, d.getX(), d.getY()), (t, i) -> {
        if (t instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)t;
            return machine.energyHandler.map(eh -> i.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(inner -> (inner.getInputVoltage() | inner.getOutputVoltage()) == (eh.getInputVoltage() | eh.getOutputVoltage())).orElse(i.getCapability(ForgeCapabilities.ENERGY).isPresent())).orElse(false);
        }
        return true;
    }, true, false, new ResourceLocation("gtlib", "energy"));
    protected final String id;
    protected final ISlotSupplier<T> slotSupplier;
    public final boolean output;
    public final boolean input;
    public final ResourceLocation textureName;
    public final BiPredicate<IGuiHandler, ItemStack> tester;

    public SlotType(String id, ISlotSupplier<T> slotSupplier, BiPredicate<IGuiHandler, ItemStack> validator) {
        this(id, slotSupplier, validator, true, true, new ResourceLocation("gtlib", "item"));
    }

    public SlotType(String id, ISlotSupplier<T> slotSupplier, BiPredicate<IGuiHandler, ItemStack> validator, boolean input, boolean output) {
        this(id, slotSupplier, validator, input, output, new ResourceLocation("gtlib", "item"));
    }

    public SlotType(String id, ISlotSupplier<T> slotSupplier, BiPredicate<IGuiHandler, ItemStack> validator, boolean input, boolean output, ResourceLocation textureName) {
        this.id = id;
        this.slotSupplier = slotSupplier;
        this.output = output;
        this.tester = validator;
        this.input = input;
        this.textureName = textureName;
        GTAPI.register(SlotType.class, this);
    }

    public static void init() {
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ISlotSupplier<T> getSlotSupplier() {
        return this.slotSupplier;
    }

    public static interface ISlotSupplier<T extends Slot> {
        public T get(SlotType<T> var1, IGuiHandler var2, Map<SlotType<?>, IItemHandler> var3, int var4, SlotData<T> var5);
    }

    public static class ItIn
    implements BiPredicate<IGuiHandler, ItemStack> {
        @Override
        public boolean test(IGuiHandler iGuiHandler, ItemStack stack) {
            if (iGuiHandler instanceof BlockEntityMachine) {
                return ((BlockEntityMachine)iGuiHandler).recipeHandler.map(rh -> rh.accepts(stack)).orElse(true);
            }
            return true;
        }
    }
}

