/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.gui.BarDir;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.int2;

public class MachineWidgetData {
    public BarDir dir = BarDir.LEFT;
    public boolean barFill = true;
    protected int2 progressSize = new int2(20, 18);
    protected int2 progressPos = new int2(72, 18);
    protected int2 ioPos = new int2(7, 62);
    protected int2 machineStatePos = new int2(83, 43);
    protected int2 machineStateSize = new int2(10, 11);
    protected Map<String, ResourceLocation> machineStateTextures = new Object2ObjectOpenHashMap();
    protected Map<String, ResourceLocation> progressTextures = new Object2ObjectOpenHashMap();
    private final GuiData parent;

    public MachineWidgetData(GuiData parent) {
        this.parent = parent;
        this.machineStateTextures.put("", new ResourceLocation("gtlib", "textures/gui/button/machine_state.png"));
        this.progressTextures.put("", new ResourceLocation("gtlib", "textures/gui/progress_bars/default.png"));
    }

    public MachineWidgetData setProgressLocation(String name) {
        this.progressTextures.put("", new ResourceLocation(this.parent.loc.m_135827_(), "textures/gui/progress_bars/" + name + ".png"));
        return this;
    }

    public MachineWidgetData setProgressLocation(Tier tier, String name) {
        this.progressTextures.put(tier.getId(), new ResourceLocation(this.parent.loc.m_135827_(), "textures/gui/progress_bars/" + name + ".png"));
        return this;
    }

    public MachineWidgetData setProgressSize(int width, int height) {
        this.progressSize = new int2(width, height);
        return this;
    }

    public MachineWidgetData setProgressPos(int x, int y) {
        this.progressPos = new int2(x, y);
        return this;
    }

    public MachineWidgetData setIoPos(int x, int y) {
        this.ioPos = new int2(x, y);
        return this;
    }

    public MachineWidgetData setMachineStatePos(int x, int y) {
        this.machineStatePos = new int2(x, y);
        return this;
    }

    public MachineWidgetData setMachineStateSize(int width, int height) {
        this.machineStateSize = new int2(width, height);
        return this;
    }

    public MachineWidgetData setMachineStateLocation(String name) {
        this.progressTextures.put("", new ResourceLocation(this.parent.loc.m_135827_(), "textures/gui/button/" + name + ".png"));
        return this;
    }

    public MachineWidgetData setMachineStateLocation(Tier tier, String name) {
        this.progressTextures.put(tier.getId(), new ResourceLocation(this.parent.loc.m_135827_(), "textures/gui/button/" + name + ".png"));
        return this;
    }

    public MachineWidgetData setDir(BarDir dir) {
        this.dir = dir;
        return this;
    }

    public MachineWidgetData setBarFill(boolean barFill) {
        this.barFill = barFill;
        return this;
    }

    public ResourceLocation getProgressTexture(Tier tier) {
        if (tier != null && this.progressTextures.containsKey(tier.getId())) {
            return this.progressTextures.get(tier.getId());
        }
        return this.progressTextures.get("");
    }

    public boolean doesBarFill() {
        return this.barFill;
    }

    public ResourceLocation getMachineStateTexture(Tier tier) {
        if (tier != null && this.machineStateTextures.containsKey(tier.getId())) {
            return this.machineStateTextures.get(tier.getId());
        }
        return this.machineStateTextures.get("");
    }

    @Generated
    public BarDir getDir() {
        return this.dir;
    }

    @Generated
    public int2 getProgressSize() {
        return this.progressSize;
    }

    @Generated
    public int2 getProgressPos() {
        return this.progressPos;
    }

    @Generated
    public int2 getIoPos() {
        return this.ioPos;
    }

    @Generated
    public int2 getMachineStatePos() {
        return this.machineStatePos;
    }

    @Generated
    public int2 getMachineStateSize() {
        return this.machineStateSize;
    }

    @Generated
    public GuiData getParent() {
        return this.parent;
    }
}

