/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.datagen.providers.GTTagProvider;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.fluid.GTMaterialFluid;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.util.TagUtils;

public class GTFluidTagProvider
extends GTTagProvider<Fluid>
implements IGTLibProvider {
    private final boolean replace;

    public GTFluidTagProvider(String providerDomain, String providerName, boolean replace) {
        super(Registries.f_256808_, providerDomain, providerName, "fluids", f -> (ResourceKey)BuiltInRegistries.f_257020_.m_7854_(f).get());
        this.replace = replace;
    }

    @Override
    protected void processTags(String domain) {
        GTAPI.all(GTFluid.class, domain).forEach(f -> {
            this.tag(TagUtils.getForgelikeFluidTag(f.getId())).add((Fluid)f.getFluid()).replace(this.replace);
            if (f instanceof GTMaterialFluid) {
                GTMaterialFluid mf = (GTMaterialFluid)f;
                Material m = mf.getMaterial();
                if (mf.getType() == GTMaterialTypes.GAS) {
                    this.tag(Tags.Fluids.GASEOUS).add(f.getFluid());
                }
                this.tag(TagUtils.getForgelikeFluidTag(m.getId())).add((Fluid)f.getFluid()).replace(this.replace);
                if (m.has(MaterialTags.ACID)) {
                    this.tag(GTLibTags.ACID).add((Fluid)f.getFluid());
                }
            }
        });
        if (domain.equals("gt")) {
            this.tag(TagUtils.getForgelikeFluidTag("water")).add((Fluid)Fluids.f_76193_);
        }
    }
}

