/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.baked;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.pipe.PipeCoverHandler;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.dynamic.DynamicBakedModel;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.texture.Texture;

public class PipeFullBakedModel
extends DynamicBakedModel {
    public static final Int2ObjectOpenHashMap<BakedModel[]> CONFIGS = new Int2ObjectOpenHashMap();

    public PipeFullBakedModel(TextureAtlasSprite particle, Int2ObjectOpenHashMap<BakedModel[]> map) {
        super(particle, map);
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, BlockAndTintGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BlockEntityPipe)) {
            return super.getBlockQuads(state, side, rand, level, pos);
        }
        BlockEntityPipe pipe = (BlockEntityPipe)blockEntity;
        if (side != null && pipe.getPipeSize().ordinal() < 6) {
            return Collections.emptyList();
        }
        List<BakedQuad> quads = super.getBlockQuads(state, side, rand, level, pos);
        PipeCoverHandler covers = pipe.coverHandler.orElse(null);
        List<BakedQuad> coverQuads = new LinkedList<BakedQuad>();
        if (covers == null) {
            return quads;
        }
        if (side == null && pipe.getPipeSize().ordinal() < 6) {
            for (Direction dir : Ref.DIRS) {
                int index;
                Texture tex = ((BlockPipe)state.m_60734_()).getFace();
                ICover c = covers.get(dir);
                if (c.isEmpty()) continue;
                if (pipe.canConnect(dir.m_122411_()) && (index = RenderHelper.findPipeFront(pipe.getPipeSize(), quads, dir)) != -1) {
                    quads.remove(index);
                }
                coverQuads = covers.getTexturer(dir).getQuads("pipe", coverQuads, state, c, new ICover.DynamicKey(dir, tex, c.getId()), dir.m_122411_(), level, pos);
            }
        } else if (side != null) {
            Texture tex = pipe.connects(side) ? ((BlockPipe)state.m_60734_()).getFace() : ((BlockPipe)state.m_60734_()).getSide();
            ICover c = covers.get(side);
            if (!c.isEmpty()) {
                coverQuads = covers.getTexturer(side).getQuads("pipe_full", coverQuads, state, c, new ICover.DynamicKey(side, tex, c.getId()), side.m_122411_(), level, pos);
                return coverQuads;
            }
        }
        quads.addAll(coverQuads);
        return quads;
    }
}

