/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.baked;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.pipe.PipeCoverHandler;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.baked.GTBakedModel;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeBakedModel
extends GTBakedModel<PipeBakedModel> {
    final BakedModel base;
    final BakedModel baseEnd;
    final BakedModel[] connections;
    final BakedModel[] connectionsEnd;

    public PipeBakedModel(TextureAtlasSprite p, BakedModel base, BakedModel baseEnd, BakedModel[] connections, BakedModel[] connectionsEnd) {
        super(p);
        this.base = base;
        this.baseEnd = baseEnd;
        this.connections = connections;
        this.connectionsEnd = connectionsEnd;
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BlockEntityPipe)) {
            return Collections.emptyList();
        }
        BlockEntityPipe pipe = (BlockEntityPipe)blockEntity;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        PipeCoverHandler covers = pipe.coverHandler.orElse(null);
        if (side == null) {
            quads.addAll(this.getQuadsFromModel(this.base, state, rand, level, pos));
            List<BakedQuad> coverQuads = new LinkedList<BakedQuad>();
            boolean connected = false;
            for (Direction d : Direction.values()) {
                if (pipe.connects(d)) {
                    connected = true;
                    quads.addAll(this.getQuadsFromModel(this.connections[d.m_122411_()], state, rand, level, pos));
                }
                if (covers == null || covers.get(d).isEmpty()) continue;
                Texture tex = ((BlockPipe)state.m_60734_()).getFace();
                ICover c = covers.get(d);
                coverQuads = covers.getTexturer(d).getQuads("pipe", coverQuads, state, c, new ICover.DynamicKey(d, tex, c.getId()), d.m_122411_(), level, pos);
            }
            quads.addAll(coverQuads);
            if (!connected) {
                quads.addAll(this.getQuadsFromModel(this.baseEnd, state, rand, level, pos));
            }
        } else if (pipe.connects(side) && covers != null && covers.get(side).isEmpty()) {
            quads.addAll(this.getQuadsFromModel(this.connectionsEnd[side.m_122411_()], state, rand, level, pos));
        }
        return quads;
    }

    private List<BakedQuad> getQuadsFromModel(BakedModel model, BlockState state, RandomSource rand, BlockAndTintGetter level, BlockPos pos) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction side : Direction.values()) {
            quads.addAll(ModelUtils.getQuadsFromBaked(model, state, side, rand, level, pos));
        }
        quads.addAll(ModelUtils.getQuadsFromBaked(model, state, null, rand, level, pos));
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

