/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.pipe;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityTickable;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.GTLibCaps;
import org.gtreimagined.gtlib.capability.Holder;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.ICoverHandlerProvider;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.capability.pipe.PipeCoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.BackgroundWidget;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.Connectivity;
import org.gtreimagined.tesseract.api.IConnectable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityPipe<T extends PipeType<T>>
extends BlockEntityTickable<BlockEntityPipe<T>>
implements IMachineHandler,
MenuProvider,
IGuiHandler,
IConnectable,
ICoverHandlerProvider<BlockEntityPipe<?>> {
    protected T type;
    protected PipeSize size;
    protected int pipeColor = -1;
    public final Optional<PipeCoverHandler<?>> coverHandler;
    protected byte connection;
    protected byte virtualConnection;
    private boolean refreshConnection = false;
    protected Holder pipeCapHolder;
    boolean blockUpdating = false;

    public BlockEntityPipe(T type, BlockPos pos, BlockState state) {
        super(((PipeType)type).getTileType(), pos, state);
        this.size = this.getPipeSize(state);
        this.type = this.getPipeType(state);
        this.coverHandler = Optional.of(new PipeCoverHandler<BlockEntityPipe>(this));
        this.pipeCapHolder = new Holder(this.getCapClass(), this.dispatch);
    }

    @Override
    public String handlerDomain() {
        return ((PipeType)this.getPipeType()).domain;
    }

    @Override
    public GuiData getGui() {
        return null;
    }

    @Override
    public void onLoad() {
        if (this.isServerSide()) {
            for (Direction facing : Ref.DIRS) {
                if (!this.connects(facing)) continue;
                BlockEntityPipe<?> pipe = this.getPipe(facing);
                if (Connectivity.has((byte)this.virtualConnection, (int)facing.m_122411_())) {
                    if (this.validate(facing) || pipe != null) continue;
                    this.virtualConnection = Connectivity.clear((byte)this.virtualConnection, (int)facing.m_122411_());
                    this.refreshConnection();
                    continue;
                }
                if (!this.validate(facing) && pipe == null) continue;
                this.virtualConnection = Connectivity.set((byte)this.virtualConnection, (int)facing.m_122411_());
                this.refreshConnection();
            }
            this.register();
        }
    }

    public boolean isConnector() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockPipe.TICKING) == false || this.coverHandler.map(p -> {
            for (ICover cover : p.getAll()) {
                if (!cover.isNode()) continue;
                return false;
            }
            return true;
        }).orElse(true) != false;
    }

    @Override
    public void onBlockUpdate(BlockPos neighbor) {
        super.onBlockUpdate(neighbor);
        Direction facing = Utils.getOffsetFacing(this.m_58899_(), neighbor);
        if (!this.blockUpdating && this.f_58857_ != null && this.f_58857_.m_46749_(this.m_58899_()) && facing != null && this.canConnect(facing.m_122411_())) {
            this.blockUpdating = true;
            BlockEntityPipe<?> pipe = this.getPipe(neighbor);
            if (Connectivity.has((byte)this.virtualConnection, (int)facing.m_122411_())) {
                if (!this.validate(facing) && pipe == null) {
                    this.virtualConnection = Connectivity.clear((byte)this.virtualConnection, (int)facing.m_122411_());
                    this.refreshConnection();
                }
            } else if (this.validate(facing) || pipe != null) {
                this.virtualConnection = Connectivity.set((byte)this.virtualConnection, (int)facing.m_122411_());
                this.refreshConnection();
            }
            this.blockUpdating = false;
        }
        this.coverHandler.ifPresent(h -> h.get(facing).onBlockUpdate());
        this.coverHandler.ifPresent(h -> h.getCovers().forEach((d, c) -> c.onBlockUpdateAllSides()));
    }

    public int getWeakRedstonePower(Direction facing) {
        if (facing != null && this.getCover(facing).getWeakPower() >= 0) {
            return this.getCover(facing).getWeakPower();
        }
        return 0;
    }

    public int getStrongRedstonePower(Direction facing) {
        if (facing != null && this.getCover(facing).getStrongPower() >= 0) {
            return this.getCover(facing).getStrongPower();
        }
        return 0;
    }

    @Override
    public void onRemove() {
        this.coverHandler.ifPresent(CoverHandler::onRemove);
        if (this.isServerSide()) {
            this.dispatch.invalidate();
            this.deregisterTesseract();
        }
    }

    public T getPipeType() {
        if (this.type == null) {
            this.type = this.getPipeType(this.m_58900_());
        }
        return this.type;
    }

    private T getPipeType(BlockState state) {
        return ((BlockPipe)state.m_60734_()).getType();
    }

    public PipeSize getPipeSize() {
        if (this.size == null) {
            this.size = this.getPipeSize(this.m_58900_());
        }
        return this.size;
    }

    private PipeSize getPipeSize(BlockState state) {
        return ((BlockPipe)state.m_60734_()).getSize();
    }

    public BlockEntityPipe<?> getPipe(Direction side) {
        return this.getPipe(this.m_58899_().m_121945_(side));
    }

    public BlockEntityPipe<?> getPipe(BlockPos side) {
        Direction dir = Utils.getOffsetFacing(this.m_58899_(), side);
        if (dir == null) {
            return null;
        }
        BlockEntity tile = this.getCachedBlockEntity(dir);
        if (!(tile instanceof BlockEntityPipe)) {
            return null;
        }
        BlockEntityPipe<T> pipe = (BlockEntityPipe<T>)tile;
        return pipe.getCapClass() == this.getCapClass() ? pipe : null;
    }

    public void toggleConnection(Direction side) {
        if (this.connects(side)) {
            this.clearConnection(side);
        } else {
            this.setConnection(side);
        }
    }

    public void setConnection(Direction side) {
        boolean ok;
        if (this.connects(side)) {
            return;
        }
        if (this.blocksSide(side)) {
            return;
        }
        BlockEntityPipe<?> pipe = this.getPipe(side);
        this.connection = Connectivity.set((byte)this.connection, (int)side.m_122411_());
        boolean bl = ok = this.validate(side) || pipe != null;
        if (ok) {
            this.virtualConnection = Connectivity.set((byte)this.virtualConnection, (int)side.m_122411_());
        }
        if (pipe != null) {
            pipe.setConnection(side.m_122424_());
        }
        this.refreshConnection();
    }

    public void clearConnection(Direction side) {
        if (!this.connects(side)) {
            return;
        }
        this.connection = Connectivity.clear((byte)this.connection, (int)side.m_122411_());
        this.virtualConnection = Connectivity.clear((byte)this.virtualConnection, (int)side.m_122411_());
        this.dispatch.invalidate(side);
        BlockEntityPipe<?> pipe = this.getPipe(side);
        if (pipe != null) {
            pipe.clearConnection(side.m_122424_());
        }
        this.refreshConnection();
    }

    public void checkConnections() {
        for (Direction side : Direction.values()) {
            BlockEntityPipe<?> pipe = this.getPipe(side);
            if (pipe == null || pipe.pipeColor == -1 || this.pipeColor == -1 || pipe.pipeColor == this.pipeColor) continue;
            this.clearConnection(side);
            pipe.clearConnection(side.m_122424_());
        }
    }

    public boolean canConnect(int side) {
        return Connectivity.has((byte)this.connection, (int)side);
    }

    public boolean canConnectVirtual(int side) {
        return Connectivity.has((byte)this.virtualConnection, (int)side);
    }

    public abstract Class<?> getCapClass();

    public void refreshConnection() {
        this.sidedSync(true);
        if (this.isServerSide() && this.isConnector()) {
            this.deregisterTesseract();
            this.register();
        }
    }

    protected abstract void register();

    protected abstract boolean deregister();

    private boolean deregisterTesseract() {
        byte old = this.connection;
        this.connection = 0;
        boolean ok = this.deregister();
        this.connection = old;
        return ok;
    }

    public boolean connects(Direction direction) {
        return Connectivity.has((byte)this.connection, (int)direction.m_122411_());
    }

    public boolean validate(Direction dir) {
        if (!this.connects(dir)) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_121945_(dir));
        if (state.m_60734_() instanceof BlockPipe && !((Boolean)state.m_61143_((Property)BlockPipe.TICKING)).booleanValue()) {
            return false;
        }
        return !this.blocksSide(dir);
    }

    public void addInventoryDrops(List<ItemStack> drops) {
        if (this.pipeColor != -1) {
            drops.get(0).m_41784_().m_128405_("co", this.pipeColor);
        }
    }

    public boolean onCoverUpdate(boolean remove, boolean hasNonEmpty, Direction side, ICover old, ICover stack) {
        if (stack.blocksCapability(this.getCapClass(), side)) {
            this.clearConnection(side);
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)BlockPipe.TICKING)).booleanValue()) {
            if (remove && !hasNonEmpty) {
                this.toggleTickingState();
                return true;
            }
        } else if (!remove && hasNonEmpty) {
            this.toggleTickingState();
            return true;
        }
        return false;
    }

    private void toggleTickingState() {
        CompoundTag nbt = this.m_187480_();
        BlockState old = this.m_58900_();
        BlockState new_s = (BlockState)this.m_58900_().m_61124_((Property)BlockPipe.TICKING, (Comparable)Boolean.valueOf((Boolean)this.m_58900_().m_61143_((Property)BlockPipe.TICKING) == false));
        this.f_58857_.m_7731_(this.m_58899_(), new_s, 10);
        BlockEntityPipe pipe = (BlockEntityPipe)this.f_58857_.m_7702_(this.m_58899_());
        if (pipe != this && pipe != null) {
            pipe.m_142466_(nbt);
            if (pipe.isConnector()) {
                pipe.register();
            }
            this.f_58857_.m_7260_(this.m_58899_(), old, new_s, 3);
        }
    }

    @Override
    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        this.coverHandler.ifPresent(CoverHandler::onFirstTick);
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.coverHandler.ifPresent(CoverHandler::onUpdate);
    }

    public CoverFactory[] getValidCovers() {
        return (CoverFactory[])GTAPI.all(CoverFactory.class).stream().filter(t -> t.getIsValid().test(this)).toArray(CoverFactory[]::new);
    }

    public ICover[] getAllCovers() {
        return this.coverHandler.map(CoverHandler::getAll).orElse(new ICover[0]);
    }

    public ICover getCover(Direction side) {
        return this.coverHandler.map(h -> h.get(side)).orElse(null);
    }

    public boolean blocksSide(Direction side) {
        BlockEntityPipe<?> neighbor = this.getPipe(side);
        if (neighbor != null && this.pipeColor != -1 && neighbor.pipeColor != -1 && neighbor.getPipeColor() != this.getPipeColor()) {
            return true;
        }
        return this.coverHandler.map(t -> t.blocksCapability(this.getCapClass(), side) || t.get(side).blockConnection(side)).orElse(false);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("v")) {
            this.coverHandler.ifPresent(t -> t.deserialize(tag.m_128469_("v")));
        }
        byte newConnection = tag.m_128445_("c");
        this.virtualConnection = tag.m_128445_("vc");
        if (newConnection != this.connection && this.f_58857_ != null && this.f_58857_.f_46443_) {
            Utils.markTileForRenderUpdate(this);
        }
        if (tag.m_128441_("co")) {
            this.pipeColor = tag.m_128451_("co");
        }
        if (this.connection != newConnection && this.f_58857_ != null) {
            for (int i = 0; i < Ref.DIRS.length; ++i) {
                boolean secondHas;
                boolean different;
                boolean firstHas = Connectivity.has((byte)this.connection, (int)i);
                boolean bl = different = firstHas != (secondHas = Connectivity.has((byte)newConnection, (int)i));
                if (!different) continue;
                if (secondHas) {
                    this.setConnection(Ref.DIRS[i]);
                    continue;
                }
                this.clearConnection(Ref.DIRS[i]);
            }
        } else if (this.f_58857_ == null) {
            this.connection = tag.m_128445_("c");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.coverHandler.ifPresent(h -> tag.m_128365_("v", (Tag)h.serialize(new CompoundTag())));
        tag.m_128344_("c", this.connection);
        tag.m_128344_("vc", this.virtualConnection);
        tag.m_128405_("co", this.pipeColor);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> info = super.getInfo(simple);
        if (simple) {
            return info;
        }
        info.add("Pipe Type: " + ((PipeType)this.getPipeType()).getId());
        info.add("Pipe Size: " + this.getPipeSize().getId());
        info.add("Connection: " + this.connection);
        info.add("Virtual Connection: " + this.virtualConnection);
        return info;
    }

    @Override
    public boolean isRemote() {
        return this.m_58904_().f_46443_;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return new ResourceLocation("gtlib", "textures/gui/empty_multi.png");
    }

    @Override
    public AbstractGuiEventPacket createGuiPacket(IGuiEvent event) {
        return null;
    }

    public Component m_5446_() {
        return Utils.literal(((PipeType)this.type).getType());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        return Data.PIPE_MENU_HANDLER.menu(this, p_createMenu_2_, p_createMenu_1_);
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        instance.addWidget(BackgroundWidget.build(instance.handler.getGuiTexture(), instance.handler.guiSize(), instance.handler.guiHeight()));
    }

    @Override
    public Optional<ICoverHandler<BlockEntityPipe<?>>> getCoverHandler() {
        return this.coverHandler.map(p -> p);
    }

    @NotNull
    public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
        if (side != null && !this.connects(side)) {
            return LazyOptional.empty();
        }
        if (!this.pipeCapHolder.isPresent()) {
            return LazyOptional.empty();
        }
        if (side == null && cap != ForgeCapabilities.ITEM_HANDLER && cap != ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.empty();
        }
        try {
            if (cap == GTLibCaps.CAP_MAP.get(this.getCapClass())) {
                return this.pipeCapHolder.side(side).cast();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return LazyOptional.empty();
        }
        return LazyOptional.empty();
    }

    @Generated
    public int getPipeColor() {
        return this.pipeColor;
    }

    @Generated
    public void setPipeColor(int pipeColor) {
        this.pipeColor = pipeColor;
    }

    @Generated
    public Holder getPipeCapHolder() {
        return this.pipeCapHolder;
    }
}

