/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib;

import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.registration.ICreativeTabProvider;
import org.gtreimagined.gtlib.util.Utils;

public class GTCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"gtlib");
    public static final RegistryObject<CreativeModeTab> ITEMS = TABS.register("items", () -> CreativeModeTab.builder().m_257941_((Component)Utils.translatable("itemGroup.gtlib.items", new Object[0])).m_257737_(() -> new ItemStack((ItemLike)Data.DEBUG_SCANNER)).m_257652_());
    public static final RegistryObject<CreativeModeTab> TOOLS = TABS.register("tools", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{ITEMS.getKey()}).m_257941_((Component)Utils.translatable("itemGroup.gtlib.tools", new Object[0])).m_257737_(() -> new ItemStack((ItemLike)Data.DEBUG_SCANNER)).m_257652_());
    public static final RegistryObject<CreativeModeTab> BLOCKS = TABS.register("blocks", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{TOOLS.getKey()}).m_257941_((Component)Utils.translatable("itemGroup.gtlib.blocks", new Object[0])).m_257737_(() -> new ItemStack((ItemLike)Data.DEBUG_SCANNER)).m_257652_());
    public static final RegistryObject<CreativeModeTab> MATERIALS = TABS.register("materials", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{BLOCKS.getKey()}).m_257941_((Component)Utils.translatable("itemGroup.gtlib.materials", new Object[0])).m_257737_(() -> new ItemStack((ItemLike)Data.DEBUG_SCANNER)).m_257652_());
    public static final RegistryObject<CreativeModeTab> MACHINES = TABS.register("machines", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{MATERIALS.getKey()}).m_257941_((Component)Utils.translatable("itemGroup.gtlib.machines", new Object[0])).m_257737_(() -> new ItemStack((ItemLike)Data.DEBUG_SCANNER)).m_257652_());

    public static void init() {
        TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(GTCreativeTabs::buildContentsEvent);
    }

    public static void buildContentsEvent(BuildCreativeModeTabContentsEvent event) {
        NonNullList items = NonNullList.m_122779_();
        GTCreativeTabs.addItems((ResourceKey<CreativeModeTab>)event.getTabKey(), (NonNullList<ItemStack>)items);
        if (!items.isEmpty()) {
            event.m_246601_((Collection)items);
        }
    }

    private static void addItems(ResourceKey<CreativeModeTab> tab, NonNullList<ItemStack> items) {
        for (Item item : GTAPI.all(Item.class)) {
            if (!(item instanceof ICreativeTabProvider)) continue;
            ICreativeTabProvider provider = (ICreativeTabProvider)item;
            provider.fillItemCategory(tab, items);
        }
    }
}

