package org.gtreimagined.gtlib.recipe.ingredient.test;

import org.gtreimagined.gtlib.util.RegistryUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.stream.Stream;

public class NameIngredient extends Ingredient {

    private final String test;

    protected NameIngredient(Stream<? extends Value> itemLists) {
        super(itemLists);
        this.test = null;
    }

    public NameIngredient(String nameTest) {
        super(Stream.empty());
        this.test = nameTest;
    }

    @Override
    public boolean test(@Nullable ItemStack p_test_1_) {
        return p_test_1_ != null && Objects.requireNonNull(RegistryUtils.getIdFromItem(p_test_1_.getItem())).getPath().contains(test);
    }
}
