package org.gtreimagined.gtlib.integration.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.item.ingredient.MatchAnyIngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.integration.rei.REIUtils;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.recipe.serializer.GTRecipeSerializer;
import org.gtreimagined.gtlib.util.RegistryUtils;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class KubeJSRecipe extends RecipeJS {

    public final List<FluidIngredient> fluidInput = new ObjectArrayList<>();
    public final List<FluidStack> fluidOutput = new ObjectArrayList<>();

    private int duration;
    private int special;
    private long power;
    private int amps;
    private boolean hidden, fake;
    private final List<Integer> outputChances = new ObjectArrayList<>(), inputChances = new ObjectArrayList<>();
    private String map;

    @Override
    public void create(ListJS listJS) {
        this.map = (String) listJS.get(0);
        RecipeMap<?> rMap = GTAPI.get(RecipeMap.class, this.map);
        if (rMap == null){
            throw new IllegalArgumentException("Unknown recipe map");
        }
        if (listJS.get(1) != null) for (Object inputItem : ListJS.orSelf(listJS.get(1))) {
            if (inputItem instanceof MapJS map){
                this.inputItems.add(RecipeIngredientJS.fromJson(map.toJson()));
            } else {
                this.inputItems.add(IngredientJS.of(inputItem));
            }
        }
        if (listJS.get(2) != null) for (Object outputItem : ListJS.orSelf(listJS.get(2))) {
            this.outputItems.add(ItemStackJS.of(outputItem));
        }
        if (listJS.get(3) != null) for (Object inputFluid : ListJS.orSelf(listJS.get(3))) {
            if (inputFluid instanceof FluidStackJS fluidStack){
                this.fluidInput.add(FluidIngredient.of(REIUtils.fromREIFluidStack(fluidStack.getFluidStack())));
            } else if (inputFluid instanceof MapJS map){
                this.fluidInput.add(GTRecipeSerializer.getFluidIngredient(map.toJson()));
            } else {
                throw new IllegalArgumentException("Invalid entry type in fluid output");
            }

        }
        if (listJS.get(4) != null) for (Object outputFluid : ListJS.orSelf(listJS.get(4))) {
            if (outputFluid instanceof FluidStackJS fluidStack){
                this.fluidOutput.add(REIUtils.fromREIFluidStack(fluidStack.getFluidStack()));
            } else if (outputFluid instanceof MapJS map){
                this.fluidOutput.add(GTRecipeSerializer.getStack(map.toJson()));
            } else {
                throw new IllegalArgumentException("Invalid entry type in fluid output");
            }
        }
        duration = ((Number) listJS.get(5)).intValue();
        power = ((Number) listJS.get(6)).longValue();
        hidden = false;
        fake = false;
        if (listJS.size() > 7) {
            amps = ((Number) listJS.get(7)).intValue();
            special = ((Number) listJS.get(8)).intValue();
            if (listJS.size() > 9) {
                for (Object chance : ListJS.orSelf(listJS.get(9))) {
                    this.outputChances.add(((Number) chance).intValue());
                }
            }
            if (listJS.size() > 10){
                for (Object chance : ListJS.orSelf(listJS.get(9))) {
                    this.inputChances.add(((Number) chance).intValue());
                }
            }
        } else {
            amps = 1;
            special = 0;
        }
        if (inputItems.isEmpty() && fluidInput.isEmpty()) {
            throw new IllegalStateException("No input in recipe");
        }
    }

    @Override
    public void deserialize() {
        this.map = GsonHelper.getAsString(json, "map");
        for (JsonElement e : GsonHelper.getAsJsonArray(json, "inputItems", new JsonArray())) {
            this.inputItems.add(RecipeIngredientJS.fromJson(e));
        }
        for (JsonElement e : GsonHelper.getAsJsonArray(json, "outputItems", new JsonArray())) {
            this.outputItems.add(ItemStackJS.of(e));
        }
        for (JsonElement e : GsonHelper.getAsJsonArray(json, "inputFluids", new JsonArray())) {
            this.fluidInput.add(GTRecipeSerializer.getFluidIngredient(e));
        }
        for (JsonElement e : GsonHelper.getAsJsonArray(json, "outputFluids", new JsonArray())) {
            this.fluidOutput.add(GTRecipeSerializer.getStack(e));
        }
        this.duration = GsonHelper.getAsInt(json, "duration");
        this.special = GsonHelper.getAsInt(json, "special", 0);
        this.power = GsonHelper.getAsInt(json, "eu");
        this.amps = GsonHelper.getAsInt(json, "amps", 1);
        this.hidden = GsonHelper.getAsBoolean(json, "hidden");
        this.fake = GsonHelper.getAsBoolean(json, "fake");

        for (JsonElement e : GsonHelper.getAsJsonArray(json, "outputChances", new JsonArray())) {
            this.outputChances.add(e.getAsInt());
        }
        for (JsonElement e : GsonHelper.getAsJsonArray(json, "inputChances", new JsonArray())) {
            this.inputChances.add(e.getAsInt());
        }
    }

    public static JsonElement serializeStack(FluidStack stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("fluid", RegistryUtils.getIdFromFluid(stack.getFluid()).toString());
        obj.addProperty("amount", stack.getAmount());
        if (stack.getTag() != null) {
            obj.add("tag", NbtOps.INSTANCE.convertTo(JsonOps.INSTANCE, stack.getTag()));
        }
        return obj;
    }

    @Override
    public @Nullable JsonElement serializeIngredientStack(IngredientStackJS in) {
        JsonElement element;
        if (in.ingredient instanceof MatchAnyIngredientJS js){
            var object = new JsonObject();
            JsonArray array = new JsonArray();
            js.ingredients.forEach(i -> array.add(i.toJson()));
            object.add("values", array);
            element = object;
        } else {
            element = in.ingredient.toJson();
        }
        if (element instanceof JsonObject object && in.getCount() > 1){
            object.addProperty(in.countKey, in.getCount());
        }
        return element;
    }

    public static JsonElement serializeFluid(FluidIngredient stack) {
        return stack.toJson();
    }

    @Override
    public void serialize() {
        if (!inputItems.isEmpty()) {
            JsonArray arr = new JsonArray();
            inputItems.forEach(t -> arr.add(t.toJson()));
            this.json.add("inputItems", arr);
        }
        if (!outputItems.isEmpty()) {
            JsonArray arr = new JsonArray();
            outputItems.forEach(t -> arr.add(t.toResultJson()));
            this.json.add("outputItems", arr);
        }
        if (!fluidInput.isEmpty()) {
            JsonArray arr = new JsonArray();
            fluidInput.forEach(t -> arr.add(serializeFluid(t)));
            this.json.add("inputFluids", arr);
        }
        if (!fluidOutput.isEmpty()) {
            JsonArray arr = new JsonArray();
            fluidOutput.forEach(t -> arr.add(serializeStack(t)));
            this.json.add("outputFluids", arr);
        }
        if (!outputChances.isEmpty()) {
            JsonArray arr = new JsonArray();
            outputChances.forEach(arr::add);
            this.json.add("outputChances", arr);
        }
        if (!inputChances.isEmpty()) {
            JsonArray arr = new JsonArray();
            inputChances.forEach(arr::add);
            this.json.add("inputChances", arr);
        }
        this.json.addProperty("eu", this.power);
        this.json.addProperty("duration", this.duration);
        this.json.addProperty("amps", this.amps);
        this.json.addProperty("special", this.special);
        this.json.addProperty("hidden", this.hidden);
        this.json.addProperty("map", this.map);
        this.json.addProperty("fake", this.fake);
    }
}
