/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.util;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.gtreimagined.gtlib.capability.fluid.CauldronWrapper;
import org.jetbrains.annotations.Nullable;

public class FluidUtils {
    public static ResourceLocation getStillTexture(Fluid fluid) {
        return fluid.getAttributes().getStillTexture();
    }

    public static ResourceLocation getFlowingTexture(Fluid fluid) {
        return fluid.getAttributes().getFlowingTexture();
    }

    public static int getFluidTemperature(Fluid fluid) {
        return fluid.getAttributes().getTemperature();
    }

    public static int getFluidDensity(Fluid fluid) {
        return fluid.getAttributes().getDensity();
    }

    public static boolean isFluidGaseous(Fluid fluid) {
        return fluid.getAttributes().isGaseous();
    }

    public static int getFluidColor(Fluid fluid) {
        return fluid.getAttributes().getColor();
    }

    public static SoundEvent getFillSound(Fluid fluid) {
        return fluid.getAttributes().getFillSound();
    }

    public static SoundEvent getEmptySound(Fluid fluid) {
        return fluid.getAttributes().getEmptySound();
    }

    public static Component getFluidDisplayName(FluidStack fluid) {
        return fluid.getDisplayName();
    }

    public static LazyOptional<IFluidHandler> getFluidHandler(Level level, BlockPos pos, @Nullable BlockEntity be, Direction side) {
        if (be == null) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof AbstractCauldronBlock) {
                return LazyOptional.of(() -> new CauldronWrapper(state, level, pos));
            }
            return LazyOptional.empty();
        }
        return be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    public static LazyOptional<IFluidHandler> getFluidHandler(Level level, BlockPos pos, Direction side) {
        return FluidUtils.getFluidHandler(level, pos, level.m_7702_(pos), side);
    }

    public static boolean fillItemFromContainer(int maxFill, ItemStack stack, IFluidHandler handler, Consumer<ItemStack> consumer) {
        return FluidUtils.fillItemFromContainer(maxFill, stack, handler, s -> true, consumer);
    }

    public static boolean emptyItemIntoContainer(int maxFill, ItemStack stack, IFluidHandler handler, Consumer<ItemStack> consumer) {
        return FluidUtils.emptyItemIntoContainer(maxFill, stack, handler, s -> true, consumer);
    }

    public static boolean fillItemFromContainer(int maxFill, ItemStack stack, IFluidHandler handler, Predicate<ItemStack> tester, Consumer<ItemStack> consumer) {
        IFluidHandlerItem itemHandler = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve().orElse(null);
        if (itemHandler == null) {
            return false;
        }
        int actualMax = maxFill == -1 ? itemHandler.getTankCapacity(0) : maxFill;
        ItemStack checkContainer = stack.m_41777_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(t -> {
            t.fill(FluidUtil.tryFluidTransfer((IFluidHandler)t, (IFluidHandler)handler, (int)actualMax, (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            return t.getContainer();
        }).orElse(ItemStack.f_41583_);
        if (!tester.test(checkContainer)) {
            return false;
        }
        FluidStack fluidStack = FluidUtil.tryFluidTransfer((IFluidHandler)itemHandler, (IFluidHandler)handler, (int)actualMax, (boolean)true);
        if (!fluidStack.isEmpty()) {
            consumer.accept(checkContainer);
            return true;
        }
        return false;
    }

    public static boolean emptyItemIntoContainer(int maxDrain, ItemStack stack, IFluidHandler handler, Predicate<ItemStack> tester, Consumer<ItemStack> consumer) {
        IFluidHandlerItem itemHandler = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve().orElse(null);
        if (itemHandler == null) {
            return false;
        }
        int actualMax = maxDrain == -1 ? itemHandler.getTankCapacity(0) : maxDrain;
        ItemStack checkContainer = stack.m_41777_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(t -> {
            t.drain(actualMax, IFluidHandler.FluidAction.EXECUTE);
            return t.getContainer();
        }).orElse(ItemStack.f_41583_);
        if (!tester.test(checkContainer)) {
            return false;
        }
        FluidStack fluidStack = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)itemHandler, (int)actualMax, (boolean)true);
        if (!fluidStack.isEmpty()) {
            consumer.accept(checkContainer);
            return true;
        }
        return false;
    }

    public static FluidStack fromTag(CompoundTag tag) {
        if (tag == null) {
            return FluidStack.EMPTY;
        }
        if (tag.m_128425_("Fluid", 8)) {
            tag.m_128359_("FluidName", tag.m_128461_("Fluid"));
            tag.m_128473_("Fluid");
        }
        if (tag.m_128425_("Nbt", 10)) {
            tag.m_128365_("Tag", (Tag)tag.m_128469_("Nbt"));
            tag.m_128473_("Nbt");
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
    }
}

