/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class CodeUtils {
    public static long divup(long number, long divider) {
        return number / divider + (long)(number % divider == 0L ? 0 : 1);
    }

    public static float bindF(float aBoundValue) {
        return Math.max(0.0f, Math.min(1.0f, aBoundValue));
    }

    public static double bindD(double aBoundValue) {
        return Math.max(0.0, Math.min(1.0, aBoundValue));
    }

    public static byte bind1(long aBoundValue) {
        return (byte)Math.max(0L, Math.min(1L, aBoundValue));
    }

    public static byte bind2(long aBoundValue) {
        return (byte)Math.max(0L, Math.min(3L, aBoundValue));
    }

    public static byte bind3(long aBoundValue) {
        return (byte)Math.max(0L, Math.min(7L, aBoundValue));
    }

    public static byte bind4(long aBoundValue) {
        return (byte)Math.max(0L, Math.min(15L, aBoundValue));
    }

    public static byte bind5(long aBoundValue) {
        return (byte)Math.max(0L, Math.min(31L, aBoundValue));
    }

    public static byte bind6(long aBoundValue) {
        return (byte)Math.max(0L, Math.min(63L, aBoundValue));
    }

    public static byte bind7(long aBoundValue) {
        return (byte)Math.max(0L, Math.min(127L, aBoundValue));
    }

    public static short bind8(long aBoundValue) {
        return (short)Math.max(0L, Math.min(255L, aBoundValue));
    }

    public static short bind15(long aBoundValue) {
        return (short)Math.max(0L, Math.min(32767L, aBoundValue));
    }

    public static int bind16(long aBoundValue) {
        return (int)Math.max(0L, Math.min(65535L, aBoundValue));
    }

    public static int bind24(long aBoundValue) {
        return (int)Math.max(0L, Math.min(0xFFFFFFL, aBoundValue));
    }

    public static int bind31(long aBoundValue) {
        return (int)Math.max(0L, Math.min(Integer.MAX_VALUE, aBoundValue));
    }

    public static int bindInt(long aBoundValue) {
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, aBoundValue));
    }

    public static short bindShort(long aBoundValue) {
        return (short)Math.max(-32768L, Math.min(32767L, aBoundValue));
    }

    public static byte bindByte(long aBoundValue) {
        return (byte)Math.max(-128L, Math.min(127L, aBoundValue));
    }

    public static byte bindStack(long aBoundValue) {
        return (byte)Math.max(1L, Math.min(64L, aBoundValue));
    }

    public static long units(long aAmount, long aOriginalUnit, long aTargetUnit, boolean aRoundUp) {
        if (aTargetUnit == 0L) {
            return 0L;
        }
        if (aOriginalUnit == aTargetUnit || aOriginalUnit == 0L) {
            return aAmount;
        }
        if (aOriginalUnit % aTargetUnit == 0L) {
            aOriginalUnit /= aTargetUnit;
            aTargetUnit = 1L;
        } else if (aTargetUnit % aOriginalUnit == 0L) {
            aTargetUnit /= aOriginalUnit;
            aOriginalUnit = 1L;
        }
        return Math.max(0L, aAmount * aTargetUnit / aOriginalUnit + (long)(aRoundUp && aAmount * aTargetUnit % aOriginalUnit > 0L ? 1 : 0));
    }

    public static int getRGB(int r, int g, int b) {
        return CodeUtils.bind8(r) << 16 | CodeUtils.bind8(g) << 8 | CodeUtils.bind8(b);
    }

    public static short getR(int rgb) {
        return (short)(rgb >>> 16 & 0xFF);
    }

    public static short getG(int rgb) {
        return (short)(rgb >>> 8 & 0xFF);
    }

    public static short getB(int rgb) {
        return (short)(rgb & 0xFF);
    }

    public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortByValuesAcending(Map<X, Y> aMap) {
        LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
        Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

            @Override
            public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                return ((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
            }
        });
        LinkedHashMap rMap = new LinkedHashMap();
        for (Map.Entry entry : tEntrySet) {
            rMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return rMap;
    }

    public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortByValuesDescending(Map<X, Y> aMap) {
        LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
        Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

            @Override
            public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                return -((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
            }
        });
        LinkedHashMap rMap = new LinkedHashMap();
        for (Map.Entry entry : tEntrySet) {
            rMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return rMap;
    }
}

