/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.structure;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.BlockEntityFakeBlock;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.structure.IBlockStatePredicate;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.gtreimagined.gtlib.util.Utils;

public class FakeTileElement<T extends BlockEntityBasicMultiMachine<T>>
implements IStructureElement<T> {
    private IBlockStatePredicate pred;
    private BlockState state;
    private final EnumMap<Direction, CoverFactory> covers = new EnumMap(Direction.class);

    public FakeTileElement(IBlockStatePredicate pred) {
        this.pred = pred;
    }

    public FakeTileElement(Block pred) {
        this(pred.m_49966_());
    }

    public FakeTileElement(BlockState pred) {
        this.state = pred;
        this.pred = (reader, pos, state) -> state == this.state;
    }

    public FakeTileElement cover(Direction side, CoverFactory cover) {
        this.covers.put(side, cover);
        return this;
    }

    public void onStructureSuccess(T machine, Level world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof BlockEntityFakeBlock) {
            BlockEntityFakeBlock fakeBlock = (BlockEntityFakeBlock)be;
            if (StructureCache.refCount(world, pos) == 0) {
                fakeBlock.setFacing(((BlockEntityBasicMultiMachine)machine).getFacing()).setCovers(this.covers);
                fakeBlock.setController((BlockEntityBasicMultiMachine<?>)machine);
            }
        }
    }

    public void onStructureFail(T basicMultiMachine, Level world, int x, int y, int z) {
        BlockEntity be;
        BlockPos pos = new BlockPos(x, y, z);
        if (world.m_46749_(pos) && (be = world.m_7702_(pos)) instanceof BlockEntityFakeBlock) {
            BlockEntityFakeBlock fakeBlock = (BlockEntityFakeBlock)be;
            fakeBlock.setController(null);
        }
    }

    public void onInfoTooltip(List<Component> text, long count, BlockEntityBasicMultiMachine<?> machine) {
        text.add((Component)Utils.literal("Element replaced with a TileEntity to allow input/output."));
    }

    public boolean check(T machine, Level world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.m_8055_(pos);
        if (this.pred.evaluate((LevelReader)machine.m_58904_(), pos, state)) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BlockEntityFakeBlock) {
                BlockEntityFakeBlock fakeBlock = (BlockEntityFakeBlock)tile;
                return fakeBlock.getController() == machine || StructureCache.refCount(world, pos) == 0;
            }
            return false;
        }
        return false;
    }

    public boolean spawnHint(T basicMultiMachine, Level world, int x, int y, int z, ItemStack trigger) {
        return false;
    }

    public boolean placeBlock(T basicMultiMachine, Level world, int x, int y, int z, ItemStack trigger) {
        if (this.state != null) {
            world.m_7731_(new BlockPos(x, y, z), this.state, 3);
            return true;
        }
        return false;
    }
}

