/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.serializer;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.recipe.BaseRecipeSerializer;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.RecipeUtil;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.recipe.serializer.IGTRecipeSerializer;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GTRecipeSerializer<T extends IRecipe>
extends BaseRecipeSerializer<T>
implements IGTRecipeSerializer<T> {
    protected GTRecipeSerializer(String domain, String id) {
        super(domain, id);
    }

    @Override
    public abstract RecipeType<T> getRecipeType();

    public abstract T createRecipe(@NotNull List<Ingredient> var1, ItemStack[] var2, @NotNull List<FluidIngredient> var3, FluidStack[] var4, int var5, long var6, int var8, int var9);

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        try {
            ObjectArrayList chances;
            String mapId = json.get("map").getAsString();
            RecipeMap map = GTAPI.get(RecipeMap.class, mapId);
            if (map == null) {
                throw new IllegalStateException("Recipe map: " + mapId + " is unknown");
            }
            if (map.getRecipeSerializer().getRecipeType() != this.getRecipeType()) {
                throw new IllegalStateException("Recipe map: " + mapId + " doesn't use recipe type: " + this.getRecipeType());
            }
            ObjectArrayList list = new ObjectArrayList();
            if (json.has("inputItems")) {
                JsonArray array = json.getAsJsonArray("inputItems");
                for (JsonElement element : array) {
                    list.add(RecipeIngredient.fromJson(element));
                }
            }
            ItemStack[] outputs = null;
            if (json.has("outputItems")) {
                outputs = (ItemStack[])Streams.stream((Iterable)json.getAsJsonArray("outputItems")).map(t -> CraftingHelper.getItemStack((JsonObject)t.getAsJsonObject(), (boolean)true)).toArray(ItemStack[]::new);
            }
            ObjectArrayList fluidInputs = new ObjectArrayList();
            if (json.has("inputFluids")) {
                JsonArray array = json.getAsJsonArray("inputFluids");
                for (JsonElement element : array) {
                    fluidInputs.add(GTRecipeSerializer.getFluidIngredient(element));
                }
            }
            FluidStack[] fluidOutputs = null;
            if (json.has("outputFluids")) {
                fluidOutputs = (FluidStack[])Streams.stream((Iterable)json.getAsJsonArray("outputFluids")).map(GTRecipeSerializer::getStack).toArray(FluidStack[]::new);
            }
            long eut = json.get("eu").getAsLong();
            int duration = json.get("duration").getAsInt();
            int amps = json.has("amps") ? json.get("amps").getAsInt() : 1;
            int special = json.has("special") ? json.get("special").getAsInt() : 0;
            T r = this.createRecipe((List<Ingredient>)list, outputs, (List<FluidIngredient>)fluidInputs, fluidOutputs, duration, eut, special, amps);
            if (json.has("outputChances")) {
                chances = new ObjectArrayList();
                for (JsonElement el : json.getAsJsonArray("outputChances")) {
                    chances.add(el.getAsInt());
                }
                r.addOutputChances(chances.stream().mapToInt(i -> i).toArray());
            }
            if (json.has("inputChances")) {
                chances = new ObjectArrayList();
                for (JsonElement el : json.getAsJsonArray("inputChances")) {
                    chances.add(el.getAsInt());
                }
                r.addInputChances(chances.stream().mapToInt(i -> i).toArray());
            }
            r.setHidden(json.get("hidden").getAsBoolean());
            r.setFake(json.get("fake").getAsBoolean());
            if (json.has("tags")) {
                JsonArray array = json.getAsJsonArray("tags");
                Set<String> tags = Streams.stream((Iterable)array).map(JsonElement::getAsString).collect(Collectors.toSet());
                r.addTags(tags);
            }
            r.setIds(recipeId, mapId);
            return r;
        }
        catch (Exception ex) {
            GTLib.LOGGER.error((Object)ex);
            GTLib.LOGGER.error(json.toString());
            return null;
        }
    }

    public static FluidStack getStack(JsonElement element) {
        try {
            if (!element.isJsonObject()) {
                return FluidStack.EMPTY;
            }
            JsonObject obj = (JsonObject)element;
            ResourceLocation fluidName = new ResourceLocation(obj.get("fluid").getAsString());
            Fluid fluid = RegistryUtils.getFluidFromID(fluidName);
            if (fluid == null) {
                return FluidStack.EMPTY;
            }
            FluidStack stack = new FluidStack(fluid, obj.has("amount") ? obj.get("amount").getAsInt() : 1000);
            if (obj.has("tag")) {
                stack.setTag(TagParser.m_129359_((String)obj.get("tag").getAsString()));
            }
            return stack;
        }
        catch (Exception ex) {
            GTLib.LOGGER.error((Object)ex);
            return FluidStack.EMPTY;
        }
    }

    public static FluidIngredient getFluidIngredient(JsonElement element) {
        try {
            if (!element.isJsonObject()) {
                return FluidIngredient.EMPTY;
            }
            JsonObject obj = (JsonObject)element;
            if (obj.has("fluidTag")) {
                ResourceLocation tagType = new ResourceLocation(obj.get("tag").getAsString());
                int amount = obj.has("amount") ? obj.get("amount").getAsInt() : 1000;
                return FluidIngredient.of(tagType, amount);
            }
            return FluidIngredient.of(GTRecipeSerializer.getStack(element));
        }
        catch (Exception ex) {
            GTLib.LOGGER.error((Object)ex);
            return FluidIngredient.EMPTY;
        }
    }

    @Nullable
    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String mapId = buffer.m_130277_();
        int size = buffer.readInt();
        ObjectArrayList ings = new ObjectArrayList(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                ings.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
        }
        size = buffer.readInt();
        ItemStack[] out = new ItemStack[size];
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                out[i] = buffer.m_130267_();
            }
        }
        size = buffer.readInt();
        ObjectArrayList in = new ObjectArrayList(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                in.add(FluidIngredient.of(buffer));
            }
        }
        size = buffer.readInt();
        FluidStack[] outf = new FluidStack[size];
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                outf[i] = buffer.readFluidStack();
            }
        }
        size = buffer.readInt();
        int[] outputChances = new int[size];
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                outputChances[i] = buffer.readInt();
            }
        }
        size = buffer.readInt();
        int[] inputChances = new int[size];
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                inputChances[i] = buffer.readInt();
            }
        }
        size = buffer.readInt();
        HashSet<String> tags = new HashSet<String>(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                tags.add(buffer.m_130277_());
            }
        }
        long power = buffer.readLong();
        int dur = buffer.readInt();
        int special = buffer.readInt();
        int amps = buffer.readInt();
        boolean hidden = buffer.readBoolean();
        boolean fake = buffer.readBoolean();
        T r = this.createRecipe((List<Ingredient>)ings, out.length == 0 ? null : out, (List<FluidIngredient>)in, outf.length == 0 ? null : outf, dur, power, special, amps);
        if (outputChances.length > 0) {
            r.addOutputChances(outputChances);
        }
        if (inputChances.length > 0) {
            r.addInputChances(inputChances);
        }
        if (!tags.isEmpty()) {
            r.addTags(tags);
        }
        r.setIds(recipeId, mapId);
        r.setHidden(hidden);
        r.setFake(fake);
        return r;
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130070_(recipe.getMapId());
        buffer.writeInt(!recipe.hasInputItems() ? 0 : recipe.getInputItems().size());
        if (recipe.hasInputItems()) {
            recipe.getInputItems().forEach(t -> CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)t));
        }
        buffer.writeInt(!recipe.hasOutputItems() ? 0 : recipe.getOutputItems(false).length);
        if (recipe.hasOutputItems()) {
            Arrays.stream(recipe.getOutputItems(false)).forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        }
        buffer.writeInt(!recipe.hasInputFluids() ? 0 : recipe.getInputFluids().size());
        if (recipe.hasInputFluids()) {
            recipe.getInputFluids().stream().forEach(t -> t.write(buffer));
        }
        buffer.writeInt(!recipe.hasOutputFluids() ? 0 : recipe.getOutputFluids().length);
        if (recipe.hasOutputFluids()) {
            Arrays.stream(recipe.getOutputFluids()).forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeFluidStack(arg_0));
        }
        buffer.writeInt(recipe.hasOutputChances() ? recipe.getOutputChances().length : 0);
        if (recipe.hasOutputChances()) {
            Arrays.stream(recipe.getOutputChances()).forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeInt(arg_0));
        }
        buffer.writeInt(recipe.hasInputChances() ? recipe.getInputChances().length : 0);
        if (recipe.hasInputChances()) {
            Arrays.stream(recipe.getInputChances()).forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeInt(arg_0));
        }
        buffer.writeInt(recipe.getTags().size());
        if (!recipe.getTags().isEmpty()) {
            recipe.getTags().forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
        }
        buffer.writeLong(recipe.getPower());
        buffer.writeInt(recipe.getDuration());
        buffer.writeInt(recipe.getSpecialValue());
        buffer.writeInt(recipe.getAmps());
        buffer.writeBoolean(recipe.isHidden());
        buffer.writeBoolean(recipe.isFake());
    }

    @Override
    public void toJson(JsonObject json, IRecipe recipe) {
        json.addProperty("recipeID", recipe.m_6423_().toString());
        json.addProperty("map", recipe.getMapId());
        JsonArray array = new JsonArray();
        for (Ingredient ingredient : recipe.getInputItems()) {
            array.add(ingredient.m_43942_());
        }
        if (!array.isEmpty()) {
            json.add("inputItems", (JsonElement)array);
        }
        array = new JsonArray();
        if (recipe.getOutputItems(false) != null) {
            for (ItemStack itemStack : recipe.getOutputItems(false)) {
                array.add((JsonElement)RecipeUtil.itemstackToJson(itemStack));
            }
        }
        if (!array.isEmpty()) {
            json.add("outputItems", (JsonElement)array);
        }
        array = new JsonArray();
        for (FluidIngredient f : recipe.getInputFluids()) {
            array.add((JsonElement)f.toJson());
        }
        if (!array.isEmpty()) {
            json.add("inputFluids", (JsonElement)array);
        }
        array = new JsonArray();
        if (recipe.getOutputFluids() != null) {
            for (FluidStack fluidStack : recipe.getOutputFluids()) {
                array.add((JsonElement)RecipeUtil.fluidstackToJson(fluidStack));
            }
        }
        if (!array.isEmpty()) {
            json.add("outputFluids", (JsonElement)array);
        }
        array = new JsonArray();
        json.addProperty("eu", (Number)recipe.getPower());
        json.addProperty("duration", (Number)recipe.getDuration());
        json.addProperty("amps", (Number)recipe.getAmps());
        json.addProperty("special", (Number)recipe.getSpecialValue());
        if (recipe.hasOutputChances()) {
            for (ItemStack itemStack : (Object)recipe.getOutputChances()) {
                array.add((Number)((int)itemStack));
            }
        }
        if (!array.isEmpty()) {
            json.add("outputChances", (JsonElement)array);
        }
        if (recipe.hasInputChances()) {
            for (ItemStack itemStack : (Object)recipe.getInputChances()) {
                array.add((Number)((int)itemStack));
            }
        }
        if (!array.isEmpty()) {
            json.add("inputChances", (JsonElement)array);
        }
        json.addProperty("hidden", Boolean.valueOf(recipe.isHidden()));
        json.addProperty("fake", Boolean.valueOf(recipe.isFake()));
        array = new JsonArray();
        for (String tag : recipe.getTags()) {
            array.add(tag);
        }
        if (!array.isEmpty()) {
            json.add("tags", (JsonElement)array);
        }
    }
}

