/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.Registry;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.recipe.ingredient.IngredientSerializer;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeIngredient
extends Ingredient {
    protected boolean nonConsume = false;
    protected boolean ignoreNbt = false;

    public RecipeIngredient(Ingredient.Value ... value) {
        this(Stream.of(value));
    }

    public RecipeIngredient(Stream<Ingredient.Value> value) {
        super(value);
    }

    public int count() {
        if (this.m_43908_().length > 0) {
            return this.m_43908_()[0].m_41613_();
        }
        return 0;
    }

    public static Stream<Ingredient.Value> valuesFromJson(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return Stream.of(RecipeIngredient.m_43919_(json.getAsJsonObject()));
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                ArrayList<Ingredient.Value> elements = new ArrayList<Ingredient.Value>();
                for (JsonElement e : jsonArray) {
                    elements.addAll(RecipeIngredient.valuesFromJson(e).toList());
                }
                return elements.stream();
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static RecipeIngredient fromJson(@Nullable JsonElement json) {
        RecipeIngredient ingredient = new RecipeIngredient(RecipeIngredient.valuesFromJson(json));
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            if (object.has("ignoreNBT") && object.get("ignoreNBT").getAsBoolean()) {
                ingredient.setIgnoreNbt();
            }
            if (object.has("noconsume") && object.get("noconsume").getAsBoolean()) {
                ingredient.setNoConsume();
            }
        }
        return ingredient;
    }

    public static Ingredient.Value m_43919_(JsonObject json) {
        int count;
        JsonElement jsonElement;
        if (json.has("values") && (jsonElement = json.get("values")) instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            if (!array.isEmpty()) {
                ArrayList<Ingredient.Value> list = new ArrayList<Ingredient.Value>();
                for (JsonElement e : array) {
                    list.addAll(RecipeIngredient.valuesFromJson(e).toList());
                }
                return new MultiValue(list.stream());
            }
            throw new JsonParseException("A Ingredient entry array must not be empty");
        }
        int n = count = json.has("count") ? json.get("count").getAsInt() : 1;
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            Item item = ShapedRecipe.m_151278_((JsonObject)json);
            ItemStack stack = new ItemStack((ItemLike)item, count);
            if (json.has("nbt")) {
                try {
                    stack.m_41751_(TagParser.m_129359_((String)json.get("nbt").getAsString()));
                }
                catch (CommandSyntaxException e) {
                    GTLib.LOGGER.error("Nbt of a ingredient errored, defaulting to stack with no nbt", (Throwable)e);
                }
            }
            return new RecipeValue(stack);
        }
        if (json.has("tag")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)resourceLocation);
            return new RecipeValue((TagKey<Item>)tagKey, count);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static Ingredient m_43940_(FriendlyByteBuf buffer) {
        return Ingredient.m_43940_((FriendlyByteBuf)buffer);
    }

    public RecipeIngredient setNoConsume() {
        this.nonConsume = true;
        return this;
    }

    public boolean ignoreConsume() {
        return this.nonConsume;
    }

    public RecipeIngredient setIgnoreNbt() {
        this.ignoreNbt = true;
        return this;
    }

    public boolean ignoreNbt() {
        return this.ignoreNbt;
    }

    public boolean test(@Nullable ItemStack compare) {
        if (compare == null) {
            return false;
        }
        if (this.m_43908_().length == 0) {
            return compare.m_41619_();
        }
        for (ItemStack itemstack : this.m_43908_()) {
            if (!itemstack.m_150930_(compare.m_41720_()) || !this.ignoreNbt && !ItemStack.m_41658_((ItemStack)itemstack, (ItemStack)compare)) continue;
            return true;
        }
        return false;
    }

    public static int count(Ingredient ing) {
        if (ing instanceof RecipeIngredient) {
            RecipeIngredient i = (RecipeIngredient)ing;
            return i.count();
        }
        if (ing.m_43908_().length > 0) {
            return ing.m_43908_()[0].m_41613_();
        }
        return 1;
    }

    public static boolean ignoreNbt(Ingredient ing) {
        if (ing instanceof RecipeIngredient) {
            RecipeIngredient i = (RecipeIngredient)ing;
            return i.ignoreNbt;
        }
        return false;
    }

    public static boolean ignoreConsume(Ingredient ing) {
        if (ing instanceof RecipeIngredient) {
            RecipeIngredient i = (RecipeIngredient)ing;
            return i.nonConsume;
        }
        return false;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializer.INSTANCE;
    }

    public static RecipeIngredient of(Ingredient ingredient, int count) {
        return new RecipeIngredient(new MultiValue(Arrays.stream(ingredient.m_43908_()).map(t -> new RecipeValue(t.m_41777_(), count))));
    }

    public static RecipeIngredient of(int count, ItemStack ... provider) {
        if (provider.length == 1) {
            return new RecipeIngredient(new RecipeValue(provider[0], count));
        }
        return new RecipeIngredient(new MultiValue(Arrays.stream(provider).map(t -> new RecipeValue((ItemStack)t, count))));
    }

    public static RecipeIngredient of(ItemStack ... provider) {
        if (provider.length == 1) {
            return new RecipeIngredient(new RecipeValue(provider[0]));
        }
        return new RecipeIngredient(new MultiValue(Arrays.stream(provider).map(RecipeValue::new)));
    }

    public static RecipeIngredient of(ItemStack stack) {
        return new RecipeIngredient(new RecipeValue(stack));
    }

    public static RecipeIngredient of(ItemLike provider, int count) {
        return RecipeIngredient.of(count, new ItemStack(provider));
    }

    public static RecipeIngredient of(ResourceLocation tagIn, int count) {
        RecipeIngredient.ensureRegisteredTag(tagIn);
        return new RecipeIngredient(new RecipeValue((TagKey<Item>)new TagKey(Registry.f_122904_, tagIn), count));
    }

    public static RecipeIngredient of(TagKey<Item> tagIn, int count) {
        RecipeIngredient.ensureRegisteredTag(tagIn.f_203868_());
        return new RecipeIngredient(new RecipeValue(tagIn, count));
    }

    @SafeVarargs
    public static RecipeIngredient of(int count, TagKey<Item> ... tagIn) {
        for (TagKey<Item> itemTagKey : tagIn) {
            RecipeIngredient.ensureRegisteredTag(itemTagKey.f_203868_());
        }
        return new RecipeIngredient(new MultiValue(Arrays.stream(tagIn).map(t -> new RecipeValue((TagKey<Item>)t, count))));
    }

    @SafeVarargs
    public static Ingredient ofIngredient(int count, TagKey<Item> ... tagIn) {
        for (TagKey<Item> itemTagKey : tagIn) {
            RecipeIngredient.ensureRegisteredTag(itemTagKey.f_203868_());
        }
        return new Ingredient(Arrays.stream(tagIn).map(t -> new RecipeValue((TagKey<Item>)t, count)));
    }

    public static RecipeIngredient ofObject(Object object, int amount) {
        if (object instanceof TagKey) {
            TagKey tag = (TagKey)object;
            return RecipeIngredient.of((TagKey<Item>)tag, amount);
        }
        if (object instanceof ItemLike) {
            ItemLike item = (ItemLike)object;
            return RecipeIngredient.of(item, amount);
        }
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return RecipeIngredient.of(stack);
        }
        if (object instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)object;
            return RecipeIngredient.of(location, amount);
        }
        return RecipeIngredient.of(f_43901_, 1);
    }

    public JsonElement m_43942_() {
        JsonObject object = new JsonObject();
        JsonElement element = super.m_43942_();
        if (element instanceof JsonObject) {
            JsonObject o;
            object = o = (JsonObject)element;
        } else if (element instanceof JsonArray) {
            object.add("values", element);
        }
        object.addProperty("ignoreNBT", Boolean.valueOf(this.ignoreNbt));
        object.addProperty("noconsume", Boolean.valueOf(this.nonConsume));
        return object;
    }

    private static void ensureRegisteredTag(ResourceLocation loc) {
        TagUtils.getItemTag(loc);
    }

    private static JsonObject toJson(ItemStack stack) {
        JsonObject ret = new JsonObject();
        ret.addProperty("item", RegistryUtils.getIdFromItem(stack.m_41720_()).toString());
        if (stack.m_41613_() != 1) {
            ret.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41783_() != null) {
            ret.addProperty("nbt", stack.m_41783_().toString());
        }
        return ret;
    }

    public static class MultiValue
    implements Ingredient.Value {
        private final Ingredient.Value[] values;

        MultiValue(Ingredient.Value ... vals) {
            this.values = vals;
        }

        MultiValue(Stream<? extends Ingredient.Value> vals) {
            this.values = (Ingredient.Value[])vals.toArray(Ingredient.Value[]::new);
        }

        public Collection<ItemStack> m_6223_() {
            return Arrays.stream(this.values).flatMap(t -> t.m_6223_().stream()).collect(Collectors.toList());
        }

        public Ingredient.Value[] getValues() {
            return this.values;
        }

        public JsonObject m_6544_() {
            JsonArray arr = new JsonArray(this.values.length);
            for (Ingredient.Value value : this.values) {
                arr.add((JsonElement)value.m_6544_());
            }
            JsonObject obj = new JsonObject();
            obj.add("values", (JsonElement)arr);
            return obj;
        }
    }

    public static class RecipeValue
    implements Ingredient.Value {
        private TagKey<Item> tag;
        private ItemStack stack;
        private final int count;

        public RecipeValue(TagKey<Item> tag, int count) {
            this.tag = tag;
            this.count = count;
        }

        public RecipeValue(ItemLike tag, int count) {
            this.stack = new ItemStack(tag);
            this.count = count;
        }

        public RecipeValue(ItemStack stack) {
            this.stack = stack;
            this.count = stack.m_41613_();
        }

        public RecipeValue(ItemStack stack, int count) {
            this.stack = stack;
            stack.m_41764_(count);
            this.count = count;
        }

        public Collection<ItemStack> m_6223_() {
            if (this.tag != null) {
                return TagUtils.nc(this.tag).stream().map(t -> new ItemStack((ItemLike)t, this.count)).toList();
            }
            return Collections.singletonList(this.stack);
        }

        public JsonObject m_6544_() {
            if (this.tag != null) {
                JsonObject obj = new JsonObject();
                obj.addProperty("tag", this.tag.f_203868_().toString());
                obj.addProperty("count", (Number)this.count);
                return obj;
            }
            if (this.stack != null) {
                return RecipeIngredient.toJson(this.stack);
            }
            return new JsonObject();
        }

        @Generated
        public TagKey<Item> getTag() {
            return this.tag;
        }

        @Generated
        public int getCount() {
            return this.count;
        }
    }
}

