/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.util.Utils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HopperBlock.class})
public class HopperBlockMixin {
    @Inject(method={"getShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        Player player;
        EntityCollisionContext collisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (collisionContext = (EntityCollisionContext)context).m_193113_()) instanceof Player && Utils.isPlayerHolding(player = (Player)entity, InteractionHand.MAIN_HAND, GTTools.WRENCH)) {
            cir.setReturnValue((Object)Shapes.m_83144_());
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        Direction side;
        if (!level.f_46443_ && Utils.isPlayerHolding(player, hand, GTTools.WRENCH) && (side = Utils.getInteractSide(hit)) != Direction.UP) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)side));
            Utils.damageStack(player.m_21120_(hand), hand, (LivingEntity)player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

