/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.material.tags;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.function.Function;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTag;

public class TypeMaterialTag<T>
extends MaterialTag {
    protected final Map<Material, T> mapping = new Object2ObjectArrayMap();
    private Function<Material, T> defaultValue = null;

    public TypeMaterialTag(String id) {
        super(id);
    }

    public TypeMaterialTag(String id, boolean shared) {
        super(id, shared);
    }

    public TypeMaterialTag<T> setDefaultValue(Function<Material, T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public TypeMaterialTag<T> add(Material mat, T map) {
        if (!mat.enabled) {
            return this;
        }
        if (!this.mapping.containsKey(mat)) {
            super.add(mat);
        }
        this.mapping.put(mat, map);
        return this;
    }

    public Map<Material, T> getAll() {
        return this.mapping;
    }

    public T get(Material mat) {
        if (!this.mapping.containsKey(mat) && this.defaultValue != null) {
            return this.defaultValue.apply(mat);
        }
        return this.mapping.get(mat);
    }
}

