/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.item;

import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IFluidItem {
    public int getCapacity();

    default public Item getItem() {
        return (Item)this;
    }

    default public FluidStack getTank(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(f -> f.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }

    default public int getFluidAmount(ItemStack stack) {
        return this.getTank(stack).getAmount();
    }

    default public Fluid getFluid(ItemStack stack) {
        return this.getTank(stack).getFluid();
    }

    default public FluidStack getFluidStack(ItemStack stack) {
        return this.getTank(stack).copy();
    }

    default public ItemStack fill(Fluid fluid, int amount) {
        ItemStack stack = new ItemStack((ItemLike)this.getItem());
        stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(f -> f.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    default public ItemStack fill(Fluid fluid) {
        return this.fill(fluid, this.getCapacity());
    }

    default public ItemStack drain(ItemStack old, FluidStack fluid) {
        old.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(f -> f.drain(fluid, IFluidHandler.FluidAction.EXECUTE));
        return old;
    }

    public Predicate<FluidStack> getFilter();
}

