/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.rei;

import dev.architectury.fluid.FluidStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.extension.CategoryExtensionProvider;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapterRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.integration.rei.REIUtils;
import org.gtreimagined.gtlib.integration.rei.category.RecipeMapCategory;
import org.gtreimagined.gtlib.integration.rei.category.RecipeMapDisplay;
import org.gtreimagined.gtlib.integration.rei.extension.REIMaterialRecipeExtension;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;

@REIPluginClient
public class GTLibREIClientPlugin
implements REIClientPlugin {
    public String getPluginProviderName() {
        return "gtlib:rei";
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        if (!GTLibConfig.ADD_REI_GROUPS.get()) {
            return;
        }
        GTAPI.all(MaterialType.class).stream().filter(t -> t instanceof MaterialTypeItem || t instanceof MaterialTypeBlock).forEach(t -> {
            MaterialTypeBlock typeBlock;
            Object func2;
            Object patt2761$temp = t.get();
            if (patt2761$temp instanceof MaterialTypeBlock.IOreGetter) {
                MaterialTypeBlock.IOreGetter getter = (MaterialTypeBlock.IOreGetter)patt2761$temp;
                GTAPI.all(StoneType.class, s -> {
                    if (s != VanillaStoneTypes.STONE && !GTLibConfig.SHOW_ALL_ORES.get() && t != GTMaterialTypes.BEARING_ROCK) {
                        return;
                    }
                    if (t == GTMaterialTypes.BEARING_ROCK && !GTLibConfig.SHOW_ROCKS.get()) {
                        return;
                    }
                    List<Object> entries = t.all().stream().map(m -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)getter.get((Material)m, (StoneType)s).asStack())).toList();
                    registry.group(new ResourceLocation("antimatter_shared", t.getId() + "_" + s.getId()), (Component)Utils.translatable("gtlib.rei.group." + t.getId() + "." + s.getId(), new Object[0]), entries);
                });
                if (t != GTMaterialTypes.BEARING_ROCK) {
                    return;
                }
            }
            if (GTLibConfig.GROUP_ORES_ONLY.get()) {
                return;
            }
            Function<Material, ItemStack> func = null;
            if (t instanceof MaterialTypeItem) {
                MaterialTypeItem typeItem = (MaterialTypeItem)t;
                func = m -> typeItem.get((Material)m, 1);
            }
            if (t instanceof MaterialTypeBlock && (func2 = (typeBlock = (MaterialTypeBlock)t).get()) instanceof MaterialTypeBlock.IBlockGetter) {
                MaterialTypeBlock.IBlockGetter getter = (MaterialTypeBlock.IBlockGetter)func2;
                func = m -> getter.get((Material)m).asStack();
            }
            if (func == null) {
                return;
            }
            Function<Material, ItemStack> finalFunc = func;
            List<Object> entries = t.all().stream().map(m -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)((ItemStack)finalFunc.apply((Material)m)))).toList();
            registry.group(new ResourceLocation("antimatter_shared", t.getId()), (Component)Utils.translatable("gtlib.rei.group." + t.getId(), new Object[0]), entries);
        });
        if (GTLibConfig.GROUP_ORES_ONLY.get()) {
            return;
        }
        GTAPI.all(StoneType.class, s -> {
            if (s instanceof CobbleStoneType) {
                CobbleStoneType cobble = (CobbleStoneType)s;
                List<EntryStack> entries = cobble.getBlocks().values().stream().map(b -> EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)b.m_5456_()))).toList();
                registry.group(new ResourceLocation("antimatter_shared", s.getId()), (Component)Utils.translatable("gtlib.rei.group." + s.getId(), new Object[0]), entries);
            }
        });
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        ArrayList list = new ArrayList();
        GTLibXEIPlugin.getItemsToHide().forEach(c -> c.accept(list));
        list.forEach(i -> rule.hide(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)i.m_5456_().m_7968_())));
        ArrayList fluidList = new ArrayList();
        GTLibXEIPlugin.getFluidsToHide().forEach(c -> c.accept(fluidList));
        fluidList.forEach(f -> {
            rule.hide(EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)FluidStack.create((Fluid)f, (long)1L)));
            rule.hide(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)f.m_6859_().m_7968_()));
        });
    }

    public void registerCategories(CategoryRegistry registry) {
        ObjectOpenHashSet registeredMachineCats = new ObjectOpenHashSet();
        GTLibXEIPlugin.getREGISTRY().forEach((arg_0, arg_1) -> GTLibREIClientPlugin.lambda$registerCategories$14((Set)registeredMachineCats, registry, arg_0, arg_1));
        REIUtils.EXTRA_CATEGORIES.forEach(c -> c.accept(registry));
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(IRecipe.class, type -> RecipeMap.getRecipeTypes().contains(type), r -> !r.isHidden(), RecipeMapDisplay::new);
        GTLibXEIPlugin.getREGISTRY().values().forEach(t -> {
            IRecipeMap m = t.map;
            if (m instanceof RecipeMap) {
                RecipeMap rm = (RecipeMap)m;
                if (m.getProxy() != null) {
                    registry.registerRecipeFiller(Recipe.class, m.getProxy().loc(), r -> {
                        IRecipe recipe = m.getProxy().handler().apply((Recipe<?>)r, (RecipeBuilder)rm.RB());
                        if (recipe == null) {
                            return null;
                        }
                        if (recipe.isHidden()) {
                            return null;
                        }
                        return new RecipeMapDisplay(recipe);
                    });
                }
            }
        });
        REIUtils.EXTRA_DISPLAYS.forEach(c -> c.accept(registry));
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage != ReloadStage.END || !manager.equals((Object)PluginManager.getClientInstance())) {
            return;
        }
        CategoryRegistry.getInstance().get(BuiltinPlugin.CRAFTING).registerExtension((CategoryExtensionProvider)new REIMaterialRecipeExtension());
    }

    public void registerEntrySettingsAdapters(EntrySettingsAdapterRegistry registry) {
        super.registerEntrySettingsAdapters(registry);
    }

    private static /* synthetic */ void lambda$registerCategories$14(Set registeredMachineCats, CategoryRegistry registry, ResourceLocation id, GTLibXEIPlugin.RegistryValue tuple) {
        if (!registeredMachineCats.contains(tuple.map.getLoc())) {
            RecipeMapCategory category = new RecipeMapCategory(tuple.map, tuple.gui, tuple.tier, tuple.workstations.isEmpty() ? null : tuple.workstations.get(0));
            registry.add((DisplayCategory)category);
            if (!tuple.workstations.isEmpty()) {
                tuple.workstations.forEach(s -> {
                    Item item = RegistryUtils.getItemFromID(s);
                    if (item == Items.f_41852_) {
                        return;
                    }
                    registry.addWorkstations(category.getCategoryIdentifier(), new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)item))});
                });
            }
            registeredMachineCats.add(tuple.map.getLoc());
        }
    }
}

