/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.ButtonWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandingWidget
extends Widget {
    final Predicate<IGuiHandler> syncFunction;
    Consumer<ExpandingWidget> onExpand;
    final ButtonOverlay icon;
    boolean open = false;
    boolean pressed = false;
    int expansion = 50;
    int rgbEdgeTop;
    int rgbEdgeBottom;
    int rgbCorner;
    int rgbCenter;

    protected ExpandingWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent, ButtonOverlay icon, Consumer<ExpandingWidget> onExpand, Predicate<IGuiHandler> syncFunction) {
        this(gui, parent, icon, onExpand, syncFunction, ButtonWidget.backgroundWhiteEdge, ButtonWidget.backgroundBlackEdge, ButtonWidget.backgroundCenter, ButtonWidget.backgroundCenter);
    }

    protected ExpandingWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent, ButtonOverlay icon, Consumer<ExpandingWidget> onExpand, Predicate<IGuiHandler> syncFunction, int rgbEdgeTop, int rgbEdgeBottom, int rgbCorner, int rgbCenter) {
        super(gui, parent);
        this.syncFunction = syncFunction;
        this.icon = icon;
        this.onExpand = onExpand;
        this.rgbEdgeTop = rgbEdgeTop;
        this.rgbEdgeBottom = rgbEdgeBottom;
        this.rgbCorner = rgbCorner;
        this.rgbCenter = rgbCenter;
    }

    @Override
    public void init() {
        super.init();
        this.gui.syncBoolean(() -> this.syncFunction.test(this.gui.handler), b -> {
            if (b != this.open) {
                if (b.booleanValue()) {
                    this.setX(this.getX() - this.expansion);
                    this.setW(this.getW() + this.expansion);
                    this.setH(this.getH() + this.expansion);
                } else {
                    this.setX(this.getX() + this.expansion);
                    this.setW(this.getW() - this.expansion);
                    this.setH(this.getH() - this.expansion);
                }
                this.updateSize();
            }
            this.open = b;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        int x = this.realX();
        int y = this.realY();
        int width = this.getW();
        int height = this.getH();
        this.fillGradient(matrixStack, x, y, width, height, this.rgbCenter, this.rgbCenter);
        this.fillGradient(matrixStack, x + width, y - 1, 1, 1, this.rgbCorner, this.rgbCorner);
        this.fillGradient(matrixStack, x - 1, y + height, 1, 1, this.rgbCorner, this.rgbCorner);
        this.fillGradient(matrixStack, x - 1, y - 1, width + 1, 1, this.rgbEdgeTop, this.rgbEdgeTop);
        this.fillGradient(matrixStack, x - 1, y, 1, height, this.rgbEdgeTop, this.rgbEdgeTop);
        this.fillGradient(matrixStack, x, y + height, width + 1, 1, this.rgbEdgeBottom, this.rgbEdgeBottom);
        this.fillGradient(matrixStack, x + width, y, 1, height, this.rgbEdgeBottom, this.rgbEdgeBottom);
        this.drawTexture(matrixStack, this.icon.getTexture(), this.realX() + 1, this.realY() + 1, 0, 0, this.icon.getH(), this.icon.getW(), this.icon.getH(), this.icon.getW());
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
        this.pressed = false;
        super.onRelease(mouseX, mouseY);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return;
        }
        this.pressed = true;
        super.onClick(mouseX, mouseY, button);
        if (this.onExpand != null) {
            if (this.gui.handler.isRemote()) {
                this.clientClick();
            }
            this.onExpand.accept(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientClick() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public static WidgetSupplier build(ButtonOverlay closed, int id, Predicate<IGuiHandler> syncFunction) {
        return ExpandingWidget.builder((a, b) -> new ExpandingWidget((GuiInstance)a, (IGuiElement)b, closed, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent((IGuiEvent.IGuiEventFactory)GuiEvents.EXPANDING_WIDGET, Screen.m_96638_() ? 1 : 0, id))), syncFunction));
    }

    public static WidgetSupplier build(ButtonOverlay closed, int id, Predicate<IGuiHandler> syncFunction, int rgbEdgeTop, int rgbEdgeBottom, int rgbCorner, int rgbCenter) {
        return ExpandingWidget.builder((a, b) -> new ExpandingWidget((GuiInstance)a, (IGuiElement)b, closed, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent((IGuiEvent.IGuiEventFactory)GuiEvents.EXPANDING_WIDGET, Screen.m_96638_() ? 1 : 0, id))), syncFunction, rgbEdgeTop, rgbEdgeBottom, rgbCorner, rgbCenter));
    }
}

