/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.gui.MachineWidgetData;
import org.gtreimagined.gtlib.gui.MenuHandler;
import org.gtreimagined.gtlib.gui.slot.ISlotProvider;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.util.int4;

public class GuiData {
    protected ResourceLocation loc;
    protected ResourceLocation override = null;
    protected MenuHandler<?> menuHandler;
    protected ImmutableMap<Tier, Tier> guiTiers;
    protected Map<String, ResourceLocation> backgroundTextures = new Object2ObjectOpenHashMap();
    protected boolean enablePlayerSlots = true;
    protected int4 area = new int4(3, 3, 170, 80);
    protected MachineWidgetData machineData = new MachineWidgetData(this);
    private final int buttons = 0;
    private ISlotProvider<?> slots;
    private int playerYOffset = 0;
    private int playerXOffset = 0;
    private int xSize = 176;
    private int textureXSize = 256;
    private int ySize = 166;
    private int textureYSize = 256;
    private boolean titleDrawingAllowed = true;

    public GuiData(String domain, String id) {
        this.loc = new ResourceLocation(domain, id);
        this.backgroundTextures.put("", new ResourceLocation("gtlib", "textures/gui/background/machine_basic.png"));
    }

    public GuiData(String domain, String id, MenuHandler menuHandler) {
        this(domain, id);
        this.menuHandler = menuHandler;
    }

    public GuiData(IGTObject type, MenuHandler menuHandler) {
        this(type.getDomain(), type.getId());
        this.menuHandler = menuHandler;
    }

    public GuiData setTieredGui(ImmutableMap.Builder<Tier, Tier> guiTiers) {
        this.guiTiers = guiTiers.build();
        return this;
    }

    public ISlotProvider<?> getSlots() {
        if (this.slots == null) {
            throw new IllegalStateException("Called GuiData::getSlots without setting it first");
        }
        return this.slots;
    }

    public ResourceLocation getTexture(Tier tier, String type) {
        if (this.override != null) {
            return this.override;
        }
        if (this.backgroundTextures.containsKey(tier.getId())) {
            return this.backgroundTextures.get(tier.getId());
        }
        return this.backgroundTextures.get("");
    }

    public boolean enablePlayerSlots() {
        return this.enablePlayerSlots;
    }

    public GuiData setEnablePlayerSlots(boolean enablePlayerSlots) {
        this.enablePlayerSlots = enablePlayerSlots;
        return this;
    }

    public GuiData setArea(int x, int y, int z, int w) {
        this.area.set(x, y, z, w);
        return this;
    }

    public GuiData setOverrideLocation(ResourceLocation override) {
        this.override = override;
        return this;
    }

    public GuiData setBackgroundTexture(String textureName) {
        this.backgroundTextures.put("", new ResourceLocation(this.loc.m_135827_(), "textures/gui/background/" + textureName + ".png"));
        return this;
    }

    public GuiData setBackgroundTexture(Tier tier, String textureName) {
        this.backgroundTextures.put(tier.getId(), new ResourceLocation(this.loc.m_135827_(), "textures/gui/background/" + textureName + ".png"));
        return this;
    }

    public GuiData setBackgroundTexture(ResourceLocation textureName) {
        this.backgroundTextures.put("", new ResourceLocation(textureName.m_135827_(), "textures/gui/background/" + textureName.m_135815_() + ".png"));
        return this;
    }

    public GuiData setBackgroundTexture(Tier tier, ResourceLocation textureName) {
        this.backgroundTextures.put(tier.getId(), new ResourceLocation(textureName.m_135827_(), "textures/gui/background/" + textureName.m_135815_() + ".png"));
        return this;
    }

    @Generated
    public ResourceLocation getLoc() {
        return this.loc;
    }

    @Generated
    public MenuHandler<?> getMenuHandler() {
        return this.menuHandler;
    }

    @Generated
    public int4 getArea() {
        return this.area;
    }

    @Generated
    public MachineWidgetData getMachineData() {
        return this.machineData;
    }

    @Generated
    public GuiData setSlots(ISlotProvider<?> slots) {
        this.slots = slots;
        return this;
    }

    @Generated
    public int getPlayerYOffset() {
        return this.playerYOffset;
    }

    @Generated
    public int getPlayerXOffset() {
        return this.playerXOffset;
    }

    @Generated
    public GuiData setPlayerYOffset(int playerYOffset) {
        this.playerYOffset = playerYOffset;
        return this;
    }

    @Generated
    public GuiData setPlayerXOffset(int playerXOffset) {
        this.playerXOffset = playerXOffset;
        return this;
    }

    @Generated
    public int getXSize() {
        return this.xSize;
    }

    @Generated
    public int getTextureXSize() {
        return this.textureXSize;
    }

    @Generated
    public int getYSize() {
        return this.ySize;
    }

    @Generated
    public int getTextureYSize() {
        return this.textureYSize;
    }

    @Generated
    public GuiData setXSize(int xSize) {
        this.xSize = xSize;
        return this;
    }

    @Generated
    public GuiData setTextureXSize(int textureXSize) {
        this.textureXSize = textureXSize;
        return this;
    }

    @Generated
    public GuiData setYSize(int ySize) {
        this.ySize = ySize;
        return this;
    }

    @Generated
    public GuiData setTextureYSize(int textureYSize) {
        this.textureYSize = textureYSize;
        return this;
    }

    @Generated
    public boolean isTitleDrawingAllowed() {
        return this.titleDrawingAllowed;
    }

    @Generated
    public GuiData setTitleDrawingAllowed(boolean titleDrawingAllowed) {
        this.titleDrawingAllowed = titleDrawingAllowed;
        return this;
    }
}

