/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.block.BlockStoneSlab;
import org.gtreimagined.gtlib.block.BlockStoneStair;
import org.gtreimagined.gtlib.block.BlockStoneWall;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.block.BlockSurfaceRock;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.BlockMultiMachine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class GTBlockLootProvider
extends BlockLoot
implements DataProvider,
IGTLibProvider {
    protected final String providerDomain;
    protected final String providerName;
    protected final Map<Block, Function<Block, LootTable.Builder>> tables = new Object2ObjectOpenHashMap();
    protected static final Map<Block, Function<Block, LootTable.Builder>> GLOBAL_TABLES = new Object2ObjectOpenHashMap();
    public static final LootItemCondition.Builder BRANCH_CUTTER = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(GTTools.BRANCH_CUTTER.getTag()));
    public static final LootItemCondition.Builder HAMMER = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(GTTools.HAMMER.getTag()));
    public static final LootItemCondition.Builder SAW = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(GTTools.SAW.getTag()).m_45071_(new EnchantmentPredicate(){

        public boolean m_30476_(Map<Enchantment, Integer> enchantmentsIn) {
            return !enchantmentsIn.containsKey(Enchantments.f_44985_);
        }
    }));

    public GTBlockLootProvider(String providerDomain, String providerName) {
        this.providerDomain = providerDomain;
        this.providerName = providerName;
    }

    public static void init() {
    }

    @Override
    public void run() {
        this.loot();
    }

    protected void loot() {
        GTAPI.all(BlockMachine.class, this.providerDomain, this::add);
        GTAPI.all(BlockMultiMachine.class, this.providerDomain, this::add);
        if (this.providerDomain.equals("gtlib")) {
            GTAPI.all(BlockPipe.class, this::add);
            GTAPI.all(BlockStorage.class, block -> {
                if (block.getType() == GTMaterialTypes.RAW_ORE_BLOCK && block.getMaterial().has(GTMaterialTypes.CRUSHED_ORE)) {
                    this.tables.put((Block)block, b -> GTBlockLootProvider.createOreDropWithHammer(block, block.m_5456_(), GTMaterialTypes.CRUSHED_ORE.get(block.getMaterial()), 9 * (Integer)MaterialTags.ORE_MULTI.get(block.getMaterial())));
                } else {
                    this.add((Block)block);
                }
            });
            GTAPI.all(BlockFrame.class, this::add);
            GTAPI.all(BlockStone.class, b -> {
                if (b.getType() instanceof CobbleStoneType && b.getSuffix().isEmpty()) {
                    this.tables.put((Block)b, b2 -> GTBlockLootProvider.m_124257_((Block)b, (ItemLike)((CobbleStoneType)b.getType()).getBlock("cobble")));
                    return;
                }
                this.add((Block)b);
            });
            GTAPI.all(BlockStoneSlab.class, b -> this.tables.put((Block)b, x$0 -> BlockLoot.m_124290_((Block)x$0)));
            GTAPI.all(BlockStoneStair.class, this::add);
            GTAPI.all(BlockStoneWall.class, this::add);
            GTAPI.all(BlockOre.class, this::addToFortune);
            GTAPI.all(BlockOreStone.class, this::addToStone);
            GTAPI.all(BlockSurfaceRock.class, b -> {
                ItemStack drop;
                ItemStack itemStack = b.getMaterial() != Material.NULL && b.getMaterial().has(GTMaterialTypes.BEARING_ROCK) ? GTMaterialTypes.BEARING_ROCK.get(b.getMaterial(), 1) : (drop = b.getStoneType().getMaterial().has(GTMaterialTypes.ROCK) ? GTMaterialTypes.ROCK.get(b.getStoneType().getMaterial(), 1) : ItemStack.f_41583_);
                if (!drop.m_41619_()) {
                    this.tables.put((Block)b, b2 -> BlockLoot.m_124126_((ItemLike)drop.m_41720_()));
                }
            });
        }
    }

    @Override
    public void onCompletion() {
        for (Map.Entry<Block, Function<Block, LootTable.Builder>> e : this.tables.entrySet()) {
            if (GLOBAL_TABLES.containsKey(e.getKey())) continue;
            GLOBAL_TABLES.put(e.getKey(), e.getValue());
        }
    }

    public static void afterCompletion() {
        for (Map.Entry<Block, Function<Block, LootTable.Builder>> e : GLOBAL_TABLES.entrySet()) {
            LootTable table = e.getValue().apply(e.getKey()).m_79165_(LootContextParamSets.f_81421_).m_79167_();
            GTLibDynamics.RUNTIME_DATA_PACK.addData(GTLibDynamics.fix(RegistryUtils.getIdFromBlock(e.getKey()), "loot_tables/blocks", "json"), GTLibDynamics.serialize(table));
        }
    }

    protected void overrideBlock(Block block, Function<Block, LootTable.Builder> builderFunction) {
        GLOBAL_TABLES.put(block, builderFunction);
    }

    protected void overrideOre(Material ore, Function<BlockOre, LootTable.Builder> builderFunction) {
        if (ore.has(GTMaterialTypes.ORE)) {
            GTAPI.all(StoneType.class).stream().filter(s -> s.doesGenerateOre() && s != VanillaStoneTypes.BEDROCK).forEach(s -> {
                Block patt7289$temp = ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.ORE.get()).get(ore, (StoneType)s).asBlock();
                if (patt7289$temp instanceof BlockOre) {
                    BlockOre blockOre = (BlockOre)patt7289$temp;
                    GLOBAL_TABLES.put(blockOre, b -> (LootTable.Builder)builderFunction.apply((BlockOre)b));
                }
            });
        }
    }

    protected void overrideSmallOre(Material ore, Function<BlockOre, LootTable.Builder> builderFunction) {
        if (ore.has(GTMaterialTypes.SMALL_ORE)) {
            GTAPI.all(StoneType.class).stream().filter(s -> s.doesGenerateOre() && s != VanillaStoneTypes.BEDROCK).forEach(s -> {
                Block patt7790$temp = ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.SMALL_ORE.get()).get(ore, (StoneType)s).asBlock();
                if (patt7790$temp instanceof BlockOre) {
                    BlockOre blockOre = (BlockOre)patt7790$temp;
                    GLOBAL_TABLES.put(blockOre, b -> (LootTable.Builder)builderFunction.apply((BlockOre)b));
                }
            });
        }
    }

    protected void addToFortune(BlockOre block) {
        if (block.getMaterial().has(MaterialTags.CUSTOM_ORE_DROPS)) {
            this.tables.put(block, b -> MaterialTags.CUSTOM_ORE_DROPS.getBuilderFunction(block.getMaterial()).apply(block));
            return;
        }
        if (block.getOreType() == GTMaterialTypes.SMALL_ORE) {
            return;
        }
        this.tables.put(block, GTBlockLootProvider.addToFortuneWithoutCustomDrops(block));
    }

    public static Function<Block, LootTable.Builder> addToFortuneWithoutCustomDrops(BlockOre block) {
        if (block.getOreType() == GTMaterialTypes.ORE) {
            Item drop = block.getMaterial().has(GTMaterialTypes.CRUSHED_ORE) || block.getMaterial().has(GTMaterialTypes.DUST) ? (block.getMaterial().has(GTMaterialTypes.CRUSHED_ORE) ? GTMaterialTypes.CRUSHED_ORE.get(block.getMaterial()) : GTMaterialTypes.DUST.get(block.getMaterial())) : null;
            Item item = block.getStoneType().isSandLike() ? block.m_5456_() : GTMaterialTypes.RAW_ORE.get(block.getMaterial());
            return b -> GTBlockLootProvider.createOreDropWithHammer(b, item, drop, (Integer)MaterialTags.ORE_MULTI.get(block.getMaterial()));
        }
        return x$0 -> BlockLoot.m_124126_((ItemLike)x$0);
    }

    public static LootTable.Builder createOreDropWithHammer(Block block, Item primaryDrop, Item hammerDrop, int hammerAmount) {
        LootTable.Builder builder = LootTable.m_79147_();
        if (block.m_5456_() == primaryDrop) {
            LootPool.Builder loot = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)primaryDrop));
            if (hammerDrop != null) {
                loot.m_6509_(HAMMER.m_81807_());
            }
            builder.m_79161_((LootPool.Builder)GTBlockLootProvider.m_124134_((ItemLike)block, (ConditionUserBuilder)loot));
        } else {
            LootPoolSingletonContainer.Builder pool = LootItem.m_79579_((ItemLike)primaryDrop).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_));
            if (hammerDrop != null) {
                pool.m_6509_(HAMMER.m_81807_());
            }
            builder = GTBlockLootProvider.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)GTBlockLootProvider.m_124131_((ItemLike)block, (FunctionUserBuilder)pool)));
        }
        if (hammerDrop != null) {
            builder.m_79161_((LootPool.Builder)GTBlockLootProvider.m_124134_((ItemLike)hammerDrop, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAMMER).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)hammerDrop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)hammerAmount))))));
        }
        return builder;
    }

    protected void addToStone(BlockOreStone block) {
        if (block.getMaterial().has(MaterialTags.CUSTOM_ORE_STONE_DROPS)) {
            this.tables.put(block, b -> MaterialTags.CUSTOM_ORE_STONE_DROPS.getBuilderFunction(block.getMaterial()).apply(block));
            return;
        }
        if (block.getMaterial().has(GTMaterialTypes.RAW_ORE)) {
            Item item = GTMaterialTypes.RAW_ORE.get(block.getMaterial());
            this.tables.put(block, b -> GTBlockLootProvider.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)GTBlockLootProvider.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
            return;
        }
        this.add(block);
    }

    protected void add(Block block) {
        this.tables.put(block, this::build);
    }

    protected LootTable.Builder build(Block block) {
        return GTBlockLootProvider.m_124126_((ItemLike)block);
    }

    public String m_6055_() {
        return this.providerName;
    }

    protected static LootTable.Builder droppingWithBranchCutters(Block block, Block sapling, float ... chances) {
        return GTBlockLootProvider.m_124157_((Block)block, (Block)sapling, (float[])chances).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(BRANCH_CUTTER).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)sapling)));
    }
}

