/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.Nullable;

public class SequencedAssemblyBuilder {
    final Ingredient input;
    ItemLike transitionalItem;
    List<Sequence> sequences = new ArrayList<Sequence>();
    int loops = 1;
    List<Tuple<ItemStack, Float>> results = new ArrayList<Tuple<ItemStack, Float>>();

    public SequencedAssemblyBuilder(Ingredient input) {
        this.input = input;
    }

    public SequencedAssemblyBuilder transitionalItem(ItemLike transitionalItem) {
        this.transitionalItem = transitionalItem;
        return this;
    }

    public SequencedAssemblyBuilder loops(int loops) {
        this.loops = loops;
        return this;
    }

    public SequencedAssemblyBuilder addDummySequence() {
        return this.addSequence(new ResourceLocation("create", "pressing"), this.transitionalItem, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.transitionalItem}));
    }

    public SequencedAssemblyBuilder addSequence(ResourceLocation type, ItemLike result, Ingredient ... inputs) {
        this.sequences.add(new Sequence(type.toString(), (JsonElement[])Arrays.stream(inputs).map(Ingredient::m_43942_).toArray(JsonElement[]::new), result));
        return this;
    }

    public SequencedAssemblyBuilder addSequence(ResourceLocation type, ItemLike result, JsonElement ... inputs) {
        this.sequences.add(new Sequence(type.toString(), inputs, result));
        return this;
    }

    public SequencedAssemblyBuilder addDeployingSequence(Object in) {
        Ingredient ingredient;
        TagKey key;
        if (this.transitionalItem == null) {
            throw new IllegalStateException("Recipe must add a transitional item first!");
        }
        if (in instanceof TagKey && (key = (TagKey)in).f_203867_() == Registry.f_122904_) {
            ingredient = Ingredient.m_204132_((TagKey)key);
        } else if (in instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)in;
            ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike});
        } else if (in instanceof ItemStack) {
            ItemStack stack = (ItemStack)in;
            ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
        } else if (in instanceof Ingredient) {
            Ingredient ing;
            ingredient = ing = (Ingredient)in;
        } else {
            throw new IllegalArgumentException("Unknown object type added!");
        }
        return this.addSequence(new ResourceLocation("create", "deploying"), this.transitionalItem, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.transitionalItem}), ingredient);
    }

    public SequencedAssemblyBuilder addFillingSequence(Object in) {
        FluidIngredient ingredient;
        if (this.transitionalItem == null) {
            throw new IllegalStateException("Recipe must add a transitional item first!");
        }
        if (in instanceof FluidStack) {
            FluidStack stack = (FluidStack)in;
            ingredient = FluidIngredient.of(stack);
        } else if (in instanceof FluidIngredient) {
            FluidIngredient ing;
            ingredient = ing = (FluidIngredient)in;
        } else {
            throw new IllegalArgumentException("Unknown object type added!");
        }
        return this.addSequence(new ResourceLocation("create", "deploying"), this.transitionalItem, new JsonElement[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.transitionalItem}).m_43942_(), ingredient.toJson()});
    }

    public SequencedAssemblyBuilder addResult(ItemLike result, float weight) {
        return this.addResult(new ItemStack(result), weight);
    }

    public SequencedAssemblyBuilder addResult(ItemStack result, float weight) {
        this.results.add((Tuple<ItemStack, Float>)new Tuple((Object)result, (Object)Float.valueOf(weight)));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.sequences.size() != 3) {
            throw new IllegalStateException("Must have exactly 3 sequences, no more, no less");
        }
        consumer.accept(new Result(new ResourceLocation(id.m_135827_(), "sequenced_assembly/" + id.m_135815_())));
    }

    private record Sequence(String type, JsonElement[] ingredients, ItemLike result) {
    }

    private class Result
    implements FinishedRecipe {
        ResourceLocation id;
        ResourceLocation advancementID = null;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public Result(ResourceLocation id, ResourceLocation advancementID) {
            this.id = id;
            this.advancementID = advancementID;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", SequencedAssemblyBuilder.this.input.m_43942_());
            JsonArray nestedRecipes = new JsonArray();
            SequencedAssemblyBuilder.this.sequences.forEach(s -> {
                JsonObject nestedRecipe = new JsonObject();
                nestedRecipe.addProperty("type", s.type());
                JsonArray ingredients = new JsonArray();
                for (JsonElement ingredient : s.ingredients) {
                    ingredients.add(ingredient);
                }
                nestedRecipe.add("ingredients", (JsonElement)ingredients);
                JsonArray results = new JsonArray();
                JsonObject item = new JsonObject();
                item.addProperty("item", RegistryUtils.getIdFromItem(s.result.m_5456_()).toString());
                results.add((JsonElement)item);
                nestedRecipe.add("results", (JsonElement)results);
                nestedRecipes.add((JsonElement)nestedRecipe);
            });
            JsonArray resultArray = new JsonArray();
            for (Tuple<ItemStack, Float> result : SequencedAssemblyBuilder.this.results) {
                JsonObject resultObject = new JsonObject();
                ItemStack stack = (ItemStack)result.m_14418_();
                resultObject.addProperty("item", RegistryUtils.getIdFromItem(stack.m_41720_()).toString());
                if (stack.m_41613_() != 1) {
                    resultObject.addProperty("count", (Number)stack.m_41613_());
                }
                if (stack.m_41782_()) {
                    resultObject.add("nbt", JsonParser.parseString((String)stack.m_41783_().toString()));
                }
                if (((Float)result.m_14419_()).floatValue() != 1.0f) {
                    resultObject.addProperty("chance", (Number)result.m_14419_());
                }
                resultArray.add((JsonElement)resultObject);
            }
            json.add("sequence", (JsonElement)nestedRecipes);
            json.add("results", (JsonElement)resultArray);
            JsonObject transitionalItemObject = new JsonObject();
            transitionalItemObject.addProperty("item", RegistryUtils.getIdFromItem(SequencedAssemblyBuilder.this.transitionalItem.m_5456_()).toString());
            json.add("transitionalItem", (JsonElement)transitionalItemObject);
            json.addProperty("loops", (Number)SequencedAssemblyBuilder.this.loops);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)Registry.f_122865_.m_7745_(new ResourceLocation("create", "sequenced_assembly"));
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementID;
        }
    }
}

