/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.cover;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.CoverMaterial;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.jetbrains.annotations.Nullable;

public class CoverPlate
extends CoverMaterial {
    private final MaterialType<?> type;
    private final Material material;

    public CoverPlate(ICoverHandler<?> source, Tier tier, Direction side, CoverFactory factory, MaterialType<?> type, Material material) {
        super(source, tier, side, factory);
        this.type = type;
        this.material = material;
    }

    @Override
    public boolean ticks() {
        return false;
    }

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return new ResourceLocation("gtlib:block/cover/cover_pipe_notint");
        }
        return new ResourceLocation("gtlib:block/cover/basic_notint");
    }

    @Override
    public MaterialType<?> getType() {
        return this.type;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public ItemStack getDroppedStack() {
        return GTMaterialTypes.PLATE.get(this.material, 1);
    }

    @Override
    public void setTextures(BiConsumer<String, Texture> texer) {
        Texture[] tex = this.material.getSet().getTextures(GTMaterialTypes.BLOCK);
        texer.accept("overlay", tex[0]);
    }

    @Override
    public List<BakedQuad> transformQuads(BlockState state, List<BakedQuad> quads) {
        quads.forEach(t -> RenderHelper.colorQuad(t, this.material.getRGB()));
        return quads;
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{this.material.getSet().getTextures(GTMaterialTypes.BLOCK)[0]};
    }

    @Override
    public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        return InteractionResult.FAIL;
    }

    @Override
    public <T> boolean blocksCapability(Class<T> cap, Direction side) {
        return super.blocksCapability(cap, side) && !(this.source().getTile() instanceof BlockEntityPipe);
    }

    @Override
    public boolean isNode() {
        return false;
    }
}

