/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.dynamic;

import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.GTLibProperties;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.ICoverHandlerProvider;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.client.SimpleModelState;
import org.gtreimagined.gtlib.client.dynamic.DynamicTextureProvider;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.mixin.client.BlockModelAccessor;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class DynamicTexturers {
    public static final DynamicTextureProvider<ICover, ICover.DynamicKey> COVER_DYNAMIC_TEXTURER = new DynamicTextureProvider(t -> {
        if (t.currentDir == ((ICover)t.source).side()) {
            UnbakedModel m = null;
            try {
                m = ModelUtils.getModel(((ICover)t.source).getModel(t.type, Direction.SOUTH));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (m == null) {
                return Collections.emptyList();
            }
            BlockModel model = (BlockModel)m;
            ((BlockModelAccessor)model).getTextureMap().put("base", (Either<Material, String>)Either.left((Object)ModelUtils.getBlockMaterial(((ICover.DynamicKey)t.key).machineTexture)));
            ((ICover)t.source).setTextures((name, texture) -> ((BlockModelAccessor)model).getTextureMap().put((String)name, (Either<Material, String>)Either.left((Object)ModelUtils.getBlockMaterial(texture))));
            Transformation base = RenderHelper.faceRotation(((ICover)t.source).side());
            BakedModel b = model.m_111449_(ModelUtils.getModelBakery(), model, ModelUtils.getDefaultTextureGetter(), (ModelState)new SimpleModelState(base), ((ICover)t.source).getModel(t.type, Direction.SOUTH), true);
            Predicate<Map.Entry<String, BakedModel>> predicate = DynamicTexturers.getEntryPredicate(t);
            ObjectArrayList ret = new ObjectArrayList();
            for (Direction dir : Ref.DIRS) {
                ret.addAll(ModelUtils.getQuadsFromBakedCover(b, t.state, dir, t.rand, t.level, t.pos, predicate));
            }
            ret.addAll(ModelUtils.getQuadsFromBakedCover(b, t.state, null, t.rand, t.level, t.pos, predicate));
            return ((ICover)t.source).transformQuads(t.state, (List<BakedQuad>)ret);
        }
        return Collections.emptyList();
    });
    public static final DynamicTextureProvider<Machine<?>, BlockEntityMachine.DynamicKey> TILE_DYNAMIC_TEXTURER = new DynamicTextureProvider(t -> {
        BlockEntityMachine machine;
        UnbakedModel model;
        Direction side;
        block5: {
            block4: {
                Vec3i vector3i = t.currentDir.m_122436_();
                Vector4f vector4f = new Vector4f((float)vector3i.m_123341_(), (float)vector3i.m_123342_(), (float)vector3i.m_123343_(), 0.0f);
                vector4f.m_123607_(RenderHelper.faceRotation(t.state).m_121103_().m_121104_());
                side = Direction.m_122372_((float)vector4f.m_123601_(), (float)vector4f.m_123615_(), (float)vector4f.m_123616_());
                model = ModelUtils.getModel(((Machine)t.source).getModel(t.type, side));
                BlockEntity blockEntity = t.getBlockEntity();
                if (!(blockEntity instanceof BlockEntityMachine)) break block4;
                machine = (BlockEntityMachine)blockEntity;
                if (model instanceof BlockModel) break block5;
            }
            return Collections.emptyList();
        }
        BlockModel m = (BlockModel)model;
        ((BlockModelAccessor)m).getTextureMap().put("base", (Either<Material, String>)Either.left((Object)ModelUtils.getBlockMaterial(machine.getMultiTexture().apply(side))));
        GTLibProperties.MachineProperties prop = ((BlockEntityMachine.DynamicKey)t.key).properties;
        for (int i = 0; i < prop.type.getOverlayLayers(); ++i) {
            String suffix = i == 0 ? "" : String.valueOf(i);
            ((BlockModelAccessor)m).getTextureMap().put("overlay" + suffix, (Either<Material, String>)Either.left((Object)ModelUtils.getBlockMaterial(prop.type.getOverlayTextures(prop.state, prop.tier, i)[side.m_122411_()])));
        }
        BakedModel b = model.m_7611_(ModelUtils.getModelBakery(), ModelUtils.getDefaultTextureGetter(), (ModelState)new SimpleModelState(RenderHelper.faceRotation(t.state)), new ResourceLocation(((Machine)t.source).getId()));
        ObjectArrayList list = new ObjectArrayList(10);
        for (Direction dir : Ref.DIRS) {
            list.addAll(ModelUtils.getQuadsFromBaked(b, t.state, dir, t.rand, t.level, t.pos));
        }
        list.addAll(ModelUtils.getQuadsFromBaked(b, t.state, null, t.rand, t.level, t.pos));
        return list;
    });

    @Nullable
    private static Predicate<Map.Entry<String, BakedModel>> getEntryPredicate(DynamicTextureProvider.BuilderData t) {
        ICoverHandler iCoverHandler;
        BlockEntity blockEntity = t.getBlockEntity();
        if (blockEntity instanceof ICoverHandlerProvider) {
            ICoverHandlerProvider provider = (ICoverHandlerProvider)blockEntity;
            iCoverHandler = provider.getCoverHandler().orElse(null);
        } else {
            iCoverHandler = null;
        }
        ICoverHandler coverHandler = iCoverHandler;
        Predicate<Map.Entry> predicate = null;
        if (coverHandler != null) {
            predicate = e -> {
                String key = (String)e.getKey();
                if (key.isEmpty()) {
                    return true;
                }
                Direction dir = Utils.rotate(t.currentDir, Direction.m_122402_((String)key));
                if (dir == null) {
                    throw new NullPointerException("Dir null in getBlockQuads");
                }
                boolean ok = coverHandler.get(dir).isEmpty();
                return ok;
            };
        }
        return predicate;
    }
}

