/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.ForgeHooks;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.recipe.ingredient.impl.Ingredients;

public class CookingRecipeHandler<T extends BlockEntityMachine<T>>
extends MachineRecipeHandler<T> {
    protected int burnDuration = 0;
    protected int maxBurn;
    private final float burnMultiplier;

    public CookingRecipeHandler(T tile, float burnMultiplier) {
        super(tile);
        this.burnMultiplier = burnMultiplier;
    }

    private boolean consume(boolean simulate) {
        List stack = this.tile.itemHandler.map(t -> t.consumeInputs(Collections.singletonList(this.getBurnable()), simulate)).orElse(Collections.emptyList());
        if (!stack.isEmpty() && !simulate) {
            this.maxBurn = (int)((float)ForgeHooks.getBurnTime((ItemStack)((ItemStack)stack.get(0)), null) * this.burnMultiplier);
            this.burnDuration += this.maxBurn;
        }
        return !stack.isEmpty();
    }

    protected Ingredient getBurnable() {
        return Ingredients.BURNABLES;
    }

    @Override
    public void onServerUpdate() {
        if (this.activeRecipe == null && this.burnDuration > 0) {
            --this.burnDuration;
            if (this.burnDuration > 0) {
                this.tile.setMachineState(MachineState.ACTIVE);
                return;
            }
            this.maxBurn = 0;
            this.tile.setMachineState(MachineState.IDLE);
        }
        super.onServerUpdate();
    }

    @Override
    public boolean consumePower(boolean simulate) {
        if (this.burnDuration == 0) {
            if (!this.consume(simulate)) {
                return false;
            }
        } else {
            boolean hasFuel;
            boolean bl = hasFuel = this.burnDuration > 0;
            if (!simulate) {
                --this.burnDuration;
            }
            return hasFuel;
        }
        return this.burnDuration > 0 || simulate;
    }

    @Override
    protected void recipeFailure() {
        this.maxBurn = 0;
    }

    @Override
    protected void playInterruptSound() {
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("burn", this.burnDuration);
        nbt.m_128405_("maxBurn", this.maxBurn);
        return nbt;
    }

    @Override
    public void getInfo(List<String> builder) {
        super.getInfo(builder);
        if (this.burnDuration > 0) {
            builder.add("Current burn time left: " + this.burnDuration);
        }
    }

    @Override
    public boolean accepts(ItemStack stack) {
        return super.accepts(stack) || this.getBurnable().test(stack);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.burnDuration = nbt.m_128451_("burn");
        this.maxBurn = nbt.m_128451_("maxBurn");
    }

    @Generated
    public int getBurnDuration() {
        return this.burnDuration;
    }

    @Generated
    public int getMaxBurn() {
        return this.maxBurn;
    }
}

