/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.block.BlockFakeTile;
import org.gtreimagined.gtlib.blockentity.BlockEntityTickable;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturer;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturers;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.network.packets.FakeTilePacket;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityFakeBlock
extends BlockEntityTickable<BlockEntityFakeBlock> {
    private BlockEntityBasicMultiMachine<?> controller = null;
    public Map<Direction, ICover> covers = new EnumMap<Direction, ICover>(Direction.class);
    public Direction facing;
    private BlockPos controllerPos = null;
    public final Map<Direction, DynamicTexturer<ICover, ICover.DynamicKey>> coverTexturer = new Object2ObjectOpenHashMap();

    public BlockEntityFakeBlock(BlockPos pos, BlockState state) {
        super(BlockFakeTile.TYPE, pos, state);
    }

    public void setController(BlockEntityBasicMultiMachine<?> controller) {
        this.controller = controller;
        if (this.f_58857_ != null) {
            if (controller != null && !this.f_58857_.f_46443_) {
                GTLibNetwork.NETWORK.sendToAllLoaded((Packet)new FakeTilePacket(this.m_58899_(), controller.m_58899_()), this.f_58857_, this.m_58899_());
            }
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.sidedSync(true);
        }
    }

    @Override
    public void onFirstTickClient(Level level, BlockPos pos, BlockState state) {
        BlockEntityBasicMultiMachine basicMultiMachine;
        BlockEntity blockEntity;
        super.onFirstTickClient(level, pos, state);
        if (this.controllerPos != null && (blockEntity = level.m_7702_(this.controllerPos)) instanceof BlockEntityBasicMultiMachine && (basicMultiMachine = (BlockEntityBasicMultiMachine)blockEntity).allowsFakeTiles()) {
            this.setController(basicMultiMachine);
            this.controllerPos = null;
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        this.covers.forEach((s, c) -> {
            if (c.ticks()) {
                c.onUpdate();
            }
        });
    }

    public ICover[] covers() {
        ICover[] ret = new ICover[6];
        for (Direction dir : Ref.DIRS) {
            ICover c = this.covers.get(dir);
            ret[dir.m_122411_()] = c == null ? ICover.empty : c;
        }
        return ret;
    }

    public void removeController(BlockEntityBasicMultiMachine<?> controller) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        this.controller = null;
    }

    public BlockEntityFakeBlock setCovers(Map<Direction, CoverFactory> covers) {
        ICoverHandler<?> handler = ICoverHandler.empty(this);
        for (Map.Entry<Direction, CoverFactory> entry : covers.entrySet()) {
            Direction dir = entry.getKey();
            CoverFactory factory = entry.getValue();
            Direction rot = Utils.coverRotateFacing(dir, this.facing);
            if (rot.m_122434_() == Direction.Axis.X) {
                rot = rot.m_122424_();
            }
            ICover cover = factory.get().get(handler, null, rot, factory);
            this.covers.put(rot, cover);
        }
        this.m_6596_();
        return this;
    }

    public BlockEntityFakeBlock setFacing(Direction facing) {
        this.facing = facing;
        this.m_6596_();
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public DynamicTexturer<ICover, ICover.DynamicKey> getTexturer(Direction side) {
        return this.coverTexturer.computeIfAbsent(side, dir -> new DynamicTexturer<ICover, ICover.DynamicKey>(DynamicTexturers.COVER_DYNAMIC_TEXTURER));
    }

    @Nullable
    public ICover getCover(Direction side) {
        return this.covers.get(side);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.facing = nbt.m_128441_("F") ? Direction.m_122376_((int)nbt.m_128451_("F")) : Direction.NORTH;
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            Utils.markTileForRenderUpdate(this);
        }
        this.covers = new EnumMap<Direction, ICover>(Direction.class);
        CompoundTag c = nbt.m_128469_("C");
        for (Direction dir : Ref.DIRS) {
            ICover cover = CoverFactory.readCover(ICoverHandler.empty(this), dir, c, false);
            if (cover == null) continue;
            this.covers.put(dir, cover);
        }
        if (nbt.m_128441_("P")) {
            BlockEntityBasicMultiMachine basicMultiMachine;
            BlockEntity blockEntity;
            this.controllerPos = BlockPos.m_122022_((long)nbt.m_128454_("P"));
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && (blockEntity = this.f_58857_.m_7702_(this.controllerPos)) instanceof BlockEntityBasicMultiMachine && (basicMultiMachine = (BlockEntityBasicMultiMachine)blockEntity).allowsFakeTiles()) {
                this.setController(basicMultiMachine);
                this.controllerPos = null;
            }
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.writeTag(nbt, true);
        return nbt;
    }

    protected void m_183515_(CompoundTag nbt) {
        this.writeTag(nbt, false);
    }

    private void writeTag(CompoundTag compound, boolean send) {
        if (this.facing != null) {
            compound.m_128405_("F", this.facing.ordinal());
        }
        CompoundTag n = new CompoundTag();
        this.covers.forEach((k, v) -> CoverFactory.writeCover(n, v, v.side(), false));
        compound.m_128365_("C", (Tag)n);
        if (this.controller != null && send) {
            compound.m_128356_("P", this.controller.m_58899_().m_121878_());
        }
    }

    public BlockState getState() {
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> list = super.getInfo(simple);
        if (!simple) {
            if (this.getState() != null) {
                list.add("State: " + this.getState().toString());
            }
            if (this.facing != null) {
                list.add("Facing: " + this.facing.m_122433_());
            }
            this.covers.forEach((k, v) -> list.add("Cover on " + k.m_122433_() + ": " + v.getId()));
            if (this.controller != null) {
                list.add("Controller position: " + this.controller.m_58899_());
            }
        }
        if (this.controller != null) {
            this.controller.getInfo(simple);
        }
        return list;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.controller != null) {
            return this.controller.getCapabilityFromFake(cap, side, side == null ? ICover.empty : this.covers.get(side));
        }
        return super.getCapability(cap, side);
    }

    @Generated
    public BlockEntityBasicMultiMachine<?> getController() {
        return this.controller;
    }
}

