/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.api.IReloadMode;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.config.ConfigSettings;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.AutomationType;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class GTLibConfig {
    public static ConfigEntry.BoolValue BASIC_MACHINE_MODELS;
    public static ConfigEntry.BoolValue SHOW_ALL_MATERIAL_ITEMS;
    public static ConfigEntry.BoolValue SHOW_ALL_FLUID_CELLS;
    public static ConfigEntry.BoolValue ADD_REI_GROUPS;
    public static ConfigEntry.BoolValue GROUP_ORES_ONLY;
    public static ConfigEntry.BoolValue SHOW_ALL_ORES;
    public static ConfigEntry.BoolValue SHOW_ROCKS;
    public static ConfigEntry.DoubleValue PIPE_LEAK;
    public static ConfigEntry.DoubleValue EU_TO_FE_RATIO;
    public static ConfigEntry.IntValue AXE_TIMBER_MAX;
    public static ConfigEntry.BoolValue INPUT_RESET_MULTIBLOCK;
    public static ConfigEntry.BoolValue AXE_TIMBER;
    public static ConfigEntry.BoolValue SMARTER_TREE_DETECTION;
    public static ConfigEntry.BoolValue PLAY_CRAFTING_SOUNDS;
    public static ConfigEntry.BoolValue LOSSY_PART_CRAFTING;
    public static ConfigEntry.BoolValue MACHINES_EXPLODE;
    public static ConfigEntry.BoolValue EXPORT_DEFAULT_DATA_AND_ASSETS;
    public static ConfigEntry.BoolValue RAIN_EXPLODES_MACHINES;
    public static ConfigEntry.BoolValue VANILLA_ORE_GEN;
    public static ConfigEntry.BoolValue VANILLA_STONE_GEN;
    public static ConfigEntry.BoolValue SMALL_ORES;
    public static ConfigEntry.BoolValue SURFACE_ROCKS;
    public static ConfigEntry.BoolValue DETAILED_ROCKS;
    public static ConfigEntry.BoolValue ORE_VEINS;
    public static ConfigEntry.BoolValue STONE_LAYERS;
    public static ConfigEntry.BoolValue STONE_LAYER_ORES;
    public static ConfigEntry.BoolValue BEDROCK_VEINS;
    public static ConfigEntry.BoolValue ORE_VEIN_SMALL_ORE_MARKERS;
    public static ConfigEntry.BoolValue ORE_VEIN_SPECTATOR_DEBUG;
    public static ConfigEntry.BoolValue ORE_VEIN_ROCKS;
    public static ConfigEntry.BoolValue STONE_LAYER_ROCKS;
    public static ConfigEntry.BoolValue STONE_LAYER_ORE_ROCKS;
    public static ConfigEntry.BoolValue STONE_LAYER_DENSE_ORE_ROCKS;
    public static ConfigEntry.IntValue ORE_VEIN_ROCK_CHANCE;
    public static ConfigEntry.IntValue STONE_LAYER_ROCK_CHANCE;
    public static ConfigEntry.IntValue STONE_LAYER_ORE_ROCK_CHANCE;
    public static ConfigEntry.IntValue STONE_LAYER_DENSE_ORE_ROCK_CHANCE;
    public static ConfigEntry.IntValue ORE_VEIN_MAX_SIZE;
    public static ConfigEntry.IntValue ORE_VEIN_CHANCE;
    public static ConfigEntry.IntValue ORE_VEIN_FIND_ATTEMPTS;
    public static ConfigEntry.IntValue ORE_VEIN_PLACE_ATTEMPTS;
    public static ConfigEntry.IntValue ORE_VEIN_SMALL_ORE_MARKERS_MULTI;
    public static ConfigHandler CONFIG_COMMON;
    public static ConfigHandler CONFIG_CLIENT;

    public static void createConfig() {
        Config config = new Config("gtlib-common");
        ConfigSection world = config.add("world");
        VANILLA_ORE_GEN = (ConfigEntry.BoolValue)world.addBool("disable_vanilla_ore_gen", true, new String[]{"Disable Vanilla ore generation (Iron Ore, Diamond Ore etc) - Default: true"}).setRequiredReload((IReloadMode)ReloadMode.WORLD);
        VANILLA_STONE_GEN = (ConfigEntry.BoolValue)world.addBool("disable_vanilla_stone_gen", true, new String[]{"Disable vanilla stone generation (Granite, Diorite etc) - Default: true"}).setRequiredReload((IReloadMode)ReloadMode.WORLD);
        SMALL_ORES = world.addBool("small_ores", true, new String[]{"Enable small ores - Default: true"});
        SURFACE_ROCKS = world.addBool("surface_rocks", true, new String[]{"Enable surface rocks - Default: true"});
        DETAILED_ROCKS = world.addBool("detailed_rocks", true, new String[]{"Enables rocks showing their stone and ore in world - Default: true", "Note: If false, rocks only show their stone type in the texture."});
        ORE_VEIN_SPECTATOR_DEBUG = world.addBool("ore_vein_spectator_debug", false, new String[]{"Shows ore veins very clearly in spectator mode - Default: false"});
        BEDROCK_VEINS = world.addBool("bedrock_veins", true, new String[]{"Enable bedrock veins - Default: true"});
        ConfigSection oreVeins = world.addSubSection("ore_veins");
        ORE_VEINS = oreVeins.addBool("ore_veins", true, new String[]{"Enable ore veins - Default: true"});
        ORE_VEIN_MAX_SIZE = oreVeins.addInt("ore_vein_max_size", 32, new String[]{"Maximum size of an ore vein - Default: 32"}).setMin(1);
        ORE_VEIN_CHANCE = oreVeins.addInt("ore_vein_chance", 100, new String[]{"Control percentage of filled 3x3 chunks. Lower number means less ore veins would spawn - Default : 100"}).setMin(1);
        ORE_VEIN_ROCKS = oreVeins.addBool("ore_vein_rocks", true, new String[]{"Enable ore veins having surface rocks - Default: true"});
        ORE_VEIN_ROCK_CHANCE = oreVeins.addInt("ore_vein_rock_chance", 16, new String[]{"Chance of ore veins having surface rocks. chance is 1/(the number) - Default: 16"}).setMin(1);
        ORE_VEIN_FIND_ATTEMPTS = (ConfigEntry.IntValue)oreVeins.addInt("ore_vein_find_attempts", 64, new String[]{"Control number of attempts to find a valid ore vein,", "Generally this maximum limit isn't hit, as selecting a vein is performant - Default : 64"}).setMin(1).setRequiredReload((IReloadMode)ReloadMode.WORLD);
        ORE_VEIN_PLACE_ATTEMPTS = (ConfigEntry.IntValue)oreVeins.addInt("ore_vein_place_attempts", 8, new String[]{"Control number of attempts to place a valid ore vein,", "If a vein wasn't placed due to height restrictions, completely in the water, or other criterion, another attempt is tried - Default : 8"}).setMin(1).setRequiredReload((IReloadMode)ReloadMode.WORLD);
        ORE_VEIN_SMALL_ORE_MARKERS = (ConfigEntry.BoolValue)oreVeins.addBool("ore_vein_small_ore_markers", true, new String[]{"Enable ore vein's having small ores as markers/indicators - Default: true"}).setRequiredReload((IReloadMode)ReloadMode.WORLD);
        ORE_VEIN_SMALL_ORE_MARKERS_MULTI = (ConfigEntry.IntValue)oreVeins.addInt("ore_vein_small_ore_markers_multi", 2, new String[]{"Multiplier to control how many small ore markers get generated per vein - Default : 2"}).setMin(1).setRequiredReload((IReloadMode)ReloadMode.WORLD);
        ConfigSection stoneLayers = world.addSubSection("stone_layers");
        STONE_LAYERS = stoneLayers.addBool("stone_layers", true, new String[]{"Enable stone layers - Default: true"});
        STONE_LAYER_ORES = stoneLayers.addBool("stone_layer_ores", true, new String[]{"Enable stone layers having ores - Default: true"});
        STONE_LAYER_ROCKS = stoneLayers.addBool("stone_layer_rocks", true, new String[]{"Enable stone layers having surface rocks - Default: true"});
        STONE_LAYER_ROCK_CHANCE = stoneLayers.addInt("stone_layer_rock_chance", 40, new String[]{"Chance of stone layers having surface rocks. chance is 1/(the number) - Default: 20"});
        STONE_LAYER_ORE_ROCKS = stoneLayers.addBool("stone_layer_ore_rocks", true, new String[]{"Enable stone layers ore veins having surface rocks - Default: true"});
        STONE_LAYER_ORE_ROCK_CHANCE = stoneLayers.addInt("stone_layer_ore_rock_chance", 60, new String[]{"Chance of stone layers ore veins having surface rocks. chance is 1/(the number) - Default: 40"});
        STONE_LAYER_DENSE_ORE_ROCKS = stoneLayers.addBool("stone_layer_dense_ore_rocks", true, new String[]{"Enable dense ore stone layers having surface rocks - Default: true"});
        STONE_LAYER_DENSE_ORE_ROCK_CHANCE = stoneLayers.addInt("stone_layer_dense_ore_rock_chance", 2000, new String[]{"Chance of dense ore stone layers having surface rocks. chance is 1/(the number) - Default: 2000"});
        ConfigSection gameplay = config.add("gameplay");
        INPUT_RESET_MULTIBLOCK = gameplay.addBool("input_reset_mulitblock", false, new String[]{"Whether or not to reconsume recipe inputs on multiblock failure - Default : false"});
        PIPE_LEAK = gameplay.addDouble("pipe_leak", 0.9, new String[]{"Amount of gas retained passing through a leaky pipe - Default: 90%"}).setMin(Double.MIN_VALUE).setMax(1.0);
        EU_TO_FE_RATIO = gameplay.addDouble("eu_to_fe_ratio", 4.0, new String[]{"EU to FE ratio used by some addons - Default: (1.0 EU = 4.0 FE)"}).setMin(Double.MIN_VALUE);
        MACHINES_EXPLODE = gameplay.addBool("machines_explode", true, new String[]{"Enable machines exploding on overvoltage - Default: true"});
        EXPORT_DEFAULT_DATA_AND_ASSETS = gameplay.addBool("export_default_data_and_assets", false, new String[]{"Exports default data and asset jsons of gt lib and addons to the dumped folder. - Default: false"});
        RAIN_EXPLODES_MACHINES = gameplay.addBool("rain_explodes_machines", true, new String[]{"Enable machines exploding when it's raining - Default: true"});
        PLAY_CRAFTING_SOUNDS = gameplay.addBool("play_crafting_sounds", true, new String[]{"Hear various crafting sounds when you craft with any of GTLib's tools that has a custom SoundType. Default: true"});
        ConfigSection treefelling = gameplay.addSubSection("treefelling");
        SMARTER_TREE_DETECTION = treefelling.addBool("smarter_tree_detection", false, new String[]{"Smart tree detection, instead of just going up in a column, it searches surrounding connected blocks too. Default: false", "Note: may have issues discerning between trees and placed down wood, use at your own risk."});
        AXE_TIMBER = treefelling.addBool("axe_timber", true, new String[]{"Allow GTLib Axe types to fell trees - Default: true"});
        AXE_TIMBER_MAX = treefelling.addInt("axe_timber_max", 150, new String[]{"Max height of a column of logs an GTLib Axe type can fell - Default: 150"}).setMin(1).setMax(2304);
        CONFIG_COMMON = CarbonConfig.CONFIGS.createConfig(config);
        CONFIG_COMMON.register();
        if (FMLEnvironment.dist.isClient()) {
            Config client = new Config("gtlib-client");
            ConfigSection general = client.add("general");
            BASIC_MACHINE_MODELS = general.addBool("basic_machine_models", false, new String[]{"Enable flat machine related models (5U Style) - Default: false"});
            SHOW_ALL_MATERIAL_ITEMS = general.addBool("show_all_material_items", false, new String[]{"Show all items in JEI, even ones that are unobtainable - Default: false"});
            SHOW_ALL_FLUID_CELLS = general.addBool("show_all_fluid_cells", false, new String[]{"Show all fluid cells in JEI - Default: false"});
            ADD_REI_GROUPS = general.addBool("add_rei_groups", false, new String[]{"Add collapsable groups for various gt material items to rei - Default: false"});
            GROUP_ORES_ONLY = general.addBool("group_ores_only", true, new String[]{"Only adds collapsable groups for ores and rocks, requires ADD_REI_GROUPS to be true - Default: true"});
            SHOW_ALL_ORES = general.addBool("show_all_ores", false, new String[]{"Show all ore variants in jei/rei, not just stone variants - Default: false"});
            SHOW_ROCKS = general.addBool("show_rocks", false, new String[]{"Show all block versions of rocks in jei/rei - Default: false"});
            CONFIG_CLIENT = CarbonConfig.CONFIGS.createConfig(client, ConfigSettings.withConfigType((ConfigType)ConfigType.CLIENT).withAutomations(new AutomationType[]{AutomationType.AUTO_LOAD}));
            CONFIG_CLIENT.register();
        }
    }

    public static class ModCompatibility {
        public boolean ENABLE_ALL_REGISTRARS;
    }

    public static class Data {
        public boolean ALL_MATERIAL_ITEMS;
        public boolean ITEM_REPLACEMENTS;
    }
}

