package org.gtreimagined.gtlib.material;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.registration.ISharedGTObject;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public interface IMaterialTag extends ISharedGTObject {

    //TODO use a static id -> material set map, instead of each IMaterialTag class having it's own collection
    Set<Material> all();

    default void register(Class<?> c, String id) {
        GTAPI.register(c, this);
        GTAPI.register(IMaterialTag.class, this);
    }

    default void add(Material... m) {
        for (int i = 0; i < m.length; i++) {
            Material m2 = m[i];
            if (m2.enabled) all().add(m2);
        }
    }

    default void remove(Material... m) {
        for (int i = 0; i < m.length; i++) {
            all().remove(m[i]);
        }
    }

    static Set<Material> all(IMaterialTag... tags) {
        Set<Material> materials = new ObjectOpenHashSet<>();
        Arrays.stream(tags).forEach(t -> materials.addAll(t.all()));
        return materials;
    }

    default Set<IMaterialTag> dependents() {
        return Collections.emptySet();
    }
}
