package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import java.util.function.Function;

public class TextButtonWidget<T> extends ButtonWidget {
    T state;
    final Function<IGuiHandler, T> syncFunction;
    final Function<T, Component> textToRender;
    public TextButtonWidget(GuiInstance instance, IGuiElement parent, @NotNull Function<T, Component> textToRender, T defaultValue, Function<IGuiHandler, T> syncFunction, @Nullable Consumer<ButtonWidget> onPress) {
        super(instance, parent, ButtonOverlay.NO_OVERLAY, onPress);
        state = defaultValue;
        this.textToRender = textToRender;
        this.syncFunction = syncFunction;
    }

    @Override
    public void init() {
        super.init();
        if (state instanceof Integer){
            gui.syncInt(() -> (int)syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (state instanceof Long){
            gui.syncLong(() -> (long)syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (state instanceof Float){
            gui.syncFloat(() -> (float)syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (state instanceof Double){
            gui.syncDouble(() -> (double)syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (state instanceof Boolean){
            gui.syncBoolean(() -> (boolean)syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (state instanceof String){
            gui.syncString(() -> (String)syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (state instanceof ItemStack){
            gui.syncItemStack(() -> (ItemStack)syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (state instanceof FluidStack){
            gui.syncFluidStack(() -> (FluidStack) syncFunction.apply(gui.handler), i -> this.state = (T) i, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else {
            String object = gui.handler instanceof BlockEntityMachine<?> machine ? machine.getMachineType().getLoc().toString() : gui.handler instanceof ICover cover ? cover.getLoc().toString() : gui.handler.getClass().toString();
            GTLib.LOGGER.warn("Unknown sync type in text widget in: " + object);
        }
    }

    @Override
    protected void renderButtonBody(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        Component text = textToRender.apply(state);
        int textWidth = Minecraft.getInstance().font.width(text);
        int xScaled = textWidth / 2;
        int xCenter = (getW() / 2);
        int xPosition = xCenter - xScaled;
        int textHeight = Minecraft.getInstance().font.lineHeight;
        int yScaled = textHeight / 2;
        int yCenter = (getH() / 2);
        int yPosition = yCenter - yScaled;
        drawText(matrixStack, textToRender.apply(state), realX() + xPosition, realY() + yPosition, 4210752);
    }

    public static <T> WidgetSupplier build(Function<IGuiHandler, T> syncFunction, Function<T, Component> textToRender, T defaultValue, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground) {
        return builder(((a, b) -> new TextButtonWidget<>(a, b, textToRender, defaultValue, syncFunction, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.hasShiftDown() ? 1 : 0, id)))).setRenderBackground(renderBackground)));
    }
}
