/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;

public class BlockEntityTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static final Set<Entry> blockEntityEntries = new ObjectLinkedOpenHashSet();
    private static final Set<Entry> pendingEntries = new ObjectLinkedOpenHashSet();
    private static boolean tickingList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(Level level, BlockPos position) {
        if (LootrAPI.isDisabled()) {
            return;
        }
        if (LootrAPI.getServer() == null) {
            return;
        }
        ResourceKey dimension = level.dimension();
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)dimension)) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(position);
        ObjectLinkedOpenHashSet chunks = new ObjectLinkedOpenHashSet();
        chunks.add(chunkPos);
        int oX = chunkPos.x;
        int oZ = chunkPos.z;
        chunks.add(chunkPos);
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                ChunkPos newPos = new ChunkPos(oX + x, oZ + z);
                if (!LootrAPI.isWorldBorderSafe(level, newPos)) continue;
                chunks.add(newPos);
            }
        }
        Entry newEntry = new Entry((ResourceKey<Level>)dimension, position, (Set<ChunkPos>)chunks, LootrAPI.getCurrentTicks());
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                blockEntityEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerTick() {
        ObjectLinkedOpenHashSet copy;
        if (LootrAPI.isDisabled()) {
            return;
        }
        ObjectLinkedOpenHashSet toRemove = new ObjectLinkedOpenHashSet();
        Object object = listLock;
        synchronized (object) {
            tickingList = true;
            copy = new ObjectLinkedOpenHashSet(blockEntityEntries);
            tickingList = false;
        }
        object = worldLock;
        synchronized (object) {
            MinecraftServer server = LootrAPI.getServer();
            if (server == null) {
                LootrAPI.LOG.error("MinecraftServer was null during ServerTickEvent!");
                return;
            }
            for (Entry entry : copy) {
                RandomizableContainerBlockEntity be;
                ServerLevel level;
                block29: {
                    block28: {
                        BlockEntity blockEntity;
                        level = server.getLevel(entry.getDimension());
                        if (level == null || LootrAPI.hasExpired(entry.age(server)) || !LootrAPI.isWorldBorderSafe((Level)level, entry.getPosition())) {
                            toRemove.add(entry);
                            continue;
                        }
                        if (!level.getChunkSource().hasChunk(entry.getPosition().getX() >> 4, entry.getPosition().getZ() >> 4)) continue;
                        boolean skip = false;
                        for (ChunkPos chunkPos : entry.getChunkPositions()) {
                            if (level.getChunkSource().hasChunk(chunkPos.x, chunkPos.z)) continue;
                            skip = true;
                            break;
                        }
                        if (skip || LootrAPI.anyUnloadedChunks(entry.getDimension(), entry.getChunkPositions())) continue;
                        if (level.getServer().getWorldData().worldGenOptions().generateStructures()) {
                            Registry registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
                            ChunkPos thisPos = new ChunkPos(entry.getPosition());
                            HolderSet.Named structureBlacklist = registry.getOrThrow(LootrTags.Structure.STRUCTURE_BLACKLIST);
                            HolderSet.Named structureWhitelist = registry.getOrThrow(LootrTags.Structure.STRUCTURE_WHITELIST);
                            if (structureBlacklist.size() != 0) {
                                if (LootrAPI.isTaggedStructurePresent(level, thisPos, LootrTags.Structure.STRUCTURE_BLACKLIST, entry.getPosition())) {
                                    toRemove.add(entry);
                                    continue;
                                }
                            } else if (structureWhitelist.size() != 0 && !LootrAPI.isTaggedStructurePresent(level, thisPos, LootrTags.Structure.STRUCTURE_WHITELIST, entry.getPosition())) {
                                toRemove.add(entry);
                                continue;
                            }
                        }
                        if (!((blockEntity = level.getBlockEntity(entry.getPosition())) instanceof RandomizableContainerBlockEntity)) break block28;
                        be = (RandomizableContainerBlockEntity)blockEntity;
                        if (!(LootrAPI.resolveBlockEntity(blockEntity) instanceof ILootrBlockEntity)) break block29;
                    }
                    toRemove.add(entry);
                    continue;
                }
                if (LootrTags.BlockEntity.isTagged((BlockEntity)be, LootrTags.BlockEntity.CONVERT_BLACKLIST)) {
                    toRemove.add(entry);
                    continue;
                }
                if (be.getLootTable() == null || LootrAPI.isLootTableBlacklisted((ResourceKey<LootTable>)be.getLootTable())) {
                    toRemove.add(entry);
                    continue;
                }
                BlockState stateAt = level.getBlockState(entry.getPosition());
                BlockState replacement = LootrAPI.replacementBlockState(stateAt);
                if (replacement == null) {
                    toRemove.add(entry);
                    continue;
                }
                DataToCopy data = PlatformAPI.copySpecificData((BlockEntity)be);
                ResourceKey table = be.getLootTable();
                long seed = be.getLootTableSeed();
                be.setLootTable(null);
                level.destroyBlock(entry.getPosition(), false);
                level.setBlock(entry.getPosition(), replacement, 2);
                BlockEntity newBlockEntity = level.getBlockEntity(entry.getPosition());
                PlatformAPI.restoreSpecificData(data, newBlockEntity);
                if (LootrAPI.resolveBlockEntity(newBlockEntity) instanceof ILootrBlockEntity && newBlockEntity instanceof RandomizableContainerBlockEntity) {
                    RandomizableContainerBlockEntity rbe = (RandomizableContainerBlockEntity)newBlockEntity;
                    rbe.setLootTable(table, seed);
                } else {
                    LootrAPI.LOG.error("replacement " + String.valueOf(replacement) + " is not an ILootrBlockEntity " + String.valueOf(entry.getDimension()) + " at " + String.valueOf(entry.getPosition()));
                }
                toRemove.add(entry);
            }
        }
        object = listLock;
        synchronized (object) {
            tickingList = true;
            blockEntityEntries.removeAll((Collection<?>)toRemove);
            blockEntityEntries.addAll(pendingEntries);
            tickingList = false;
            pendingEntries.clear();
        }
    }

    public static class Entry {
        private final ResourceKey<Level> dimension;
        private final BlockPos position;
        private final Set<ChunkPos> chunks;
        private final long addedAt;

        public Entry(ResourceKey<Level> dimension, BlockPos position, Set<ChunkPos> chunks, long addedAt) {
            this.dimension = dimension;
            this.position = position;
            this.chunks = chunks;
            this.addedAt = addedAt;
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public Set<ChunkPos> getChunkPositions() {
            return this.chunks;
        }

        public long age(MinecraftServer server) {
            return (long)server.getTickCount() - this.addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.dimension.equals(entry.dimension)) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + this.position.hashCode();
            return result;
        }
    }
}

