/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.setup;

import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.Identifier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterBlockStateModels;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterSelectItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.client.model.standalone.SimpleUnbakedStandaloneModel;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.client.block.LootrBrushableBlockRenderer;
import noobanidus.mods.lootr.common.client.block.LootrChestBlockRenderer;
import noobanidus.mods.lootr.common.client.block.LootrDecoratedPotRenderer;
import noobanidus.mods.lootr.common.client.block.LootrShulkerBoxRenderer;
import noobanidus.mods.lootr.common.client.entity.LootrBlockStateDefinitions;
import noobanidus.mods.lootr.common.client.entity.LootrChestCartRenderer;
import noobanidus.mods.lootr.common.client.entity.LootrItemFrameRenderer;
import noobanidus.mods.lootr.common.client.particle.UnopenedParticle;
import noobanidus.mods.lootr.common.client.select.SelectConfigType;
import noobanidus.mods.lootr.common.client.special.LootrChestSpecialRenderer;
import noobanidus.mods.lootr.common.client.special.LootrDecoratedPotSpecialRenderer;
import noobanidus.mods.lootr.common.client.special.LootrShulkerSpecialRenderer;
import noobanidus.mods.lootr.neoforge.client.block.UnbakedBrushableModel;
import noobanidus.mods.lootr.neoforge.client.block.UnbakedCustomModel;
import noobanidus.mods.lootr.neoforge.init.ModParticles;

@EventBusSubscriber(modid="lootr", value={Dist.CLIENT})
public class ClientSetup {
    public static final StandaloneModelKey<BlockStateModel> ITEM_FRAME = new StandaloneModelKey(() -> ((Identifier)LootrBlockStateDefinitions.LOOTR_ITEM_FRAME_LOCATION).toString());
    public static final StandaloneModelKey<BlockStateModel> ITEM_FRAME_OPEN = new StandaloneModelKey(() -> ((Identifier)LootrBlockStateDefinitions.LOOTR_OPEN_ITEM_FRAME_LOCATION).toString());

    @SubscribeEvent
    public static void modelAdditional(ModelEvent.RegisterStandalone event) {
        event.register(ITEM_FRAME, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)LootrBlockStateDefinitions.LOOTR_ITEM_FRAME_LOCATION.withPrefix("block/")));
        event.register(ITEM_FRAME_OPEN, (UnbakedStandaloneModel)SimpleUnbakedStandaloneModel.blockStateModel((Identifier)LootrBlockStateDefinitions.LOOTR_OPEN_ITEM_FRAME_LOCATION.withPrefix("block/")));
    }

    @SubscribeEvent
    public static void registerSpecial(RegisterSpecialModelRendererEvent event) {
        event.register(LootrAPI.rl("chest"), LootrChestSpecialRenderer.Unbaked.MAP_CODEC);
        event.register(LootrAPI.rl("shulker_box"), LootrShulkerSpecialRenderer.Unbaked.MAP_CODEC);
        event.register(LootrAPI.rl("decorated_pot"), LootrDecoratedPotSpecialRenderer.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    public static void modelRegister(RegisterBlockStateModels event) {
        event.registerModel(LootrAPI.rl("custom"), UnbakedCustomModel.CODEC);
        event.registerModel(LootrAPI.rl("brushable"), UnbakedBrushableModel.CODEC);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(LootrRegistry.getChestBlockEntity(), LootrChestBlockRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getTrappedChestBlockEntity(), LootrChestBlockRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getChestBlockEntity(), LootrChestBlockRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getShulkerBlockEntity(), LootrShulkerBoxRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getInventoryBlockEntity(), LootrChestBlockRenderer::new);
        event.registerEntityRenderer(LootrRegistry.getMinecart(), e -> new LootrChestCartRenderer(e, ModelLayers.CHEST_MINECART));
        event.registerBlockEntityRenderer(LootrRegistry.getBrushableBlockEntity(), LootrBrushableBlockRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getDecoratedPotBlockEntity(), LootrDecoratedPotRenderer::new);
        event.registerEntityRenderer(LootrRegistry.getItemFrame(), LootrItemFrameRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayersEvent(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LootrDecoratedPotRenderer.OPEN_POT_LAYER, LootrDecoratedPotRenderer::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.UNOPENED_PARTICLE.get(), UnopenedParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerSelect(RegisterSelectItemModelPropertyEvent event) {
        event.register(LootrAPI.rl("config_type"), SelectConfigType.TYPE);
    }
}

