/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.client.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.client.block.UnbakedCustomModel;
import noobanidus.mods.lootr.neoforge.init.ModBlockProperties;
import org.jspecify.annotations.Nullable;

public class UnbakedCustomModel
extends noobanidus.mods.lootr.common.client.block.UnbakedCustomModel
implements CustomUnbakedBlockStateModel {
    public static final MapCodec<UnbakedCustomModel> CODEC = UnbakedCustomModel.getCodec(UnbakedCustomModel::new);

    public UnbakedCustomModel(Identifier opened, Identifier unopened, Identifier vanilla, Variant.SimpleModelState state, boolean open) {
        super(opened, unopened, vanilla, state, open);
    }

    public UnbakedCustomModel withState(Variant.SimpleModelState modelState) {
        return new UnbakedCustomModel(this.opened, this.unopened, this.vanilla, modelState, this.open);
    }

    @Override
    protected UnbakedCustomModel.Baker getBaker() {
        return Baked::new;
    }

    public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
        return CODEC;
    }

    public static class Baked
    extends UnbakedCustomModel.Baked
    implements DynamicBlockStateModel {
        public Baked(BlockStateModel unopened, BlockStateModel opened, BlockStateModel vanilla, boolean open) {
            super(unopened, opened, vanilla, open);
        }

        @Override
        protected boolean isOpenFromBATG(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
            return level.getModelData(pos).get(ModBlockProperties.OPENED) == Boolean.TRUE;
        }

        public void collectParts(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos, BlockState blockState, RandomSource randomSource, List<BlockModelPart> list) {
            if (LootrAPI.isVanillaTextures()) {
                this.vanilla.collectParts(blockAndTintGetter, blockPos, blockState, randomSource, list);
                return;
            }
            if (blockState.isAir()) {
                if (!LootrAPI.isVanillaTextures()) {
                    this.unopened.collectParts(blockAndTintGetter, blockPos, blockState, randomSource, list);
                }
                return;
            }
            boolean visuallyOpen = this.isOpenFromBATG(blockAndTintGetter, blockPos, blockState, randomSource);
            if (visuallyOpen) {
                this.opened.collectParts(blockAndTintGetter, blockPos, blockState, randomSource, list);
            } else {
                this.unopened.collectParts(blockAndTintGetter, blockPos, blockState, randomSource, list);
            }
        }

        public @Nullable Object createGeometryKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
            return this.internalCreateObjectKey(level, pos, state, random);
        }
    }
}

