/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.command.ILootrCommandExtension;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.block.LootrBarrelBlock;
import noobanidus.mods.lootr.common.block.LootrChestBlock;
import noobanidus.mods.lootr.common.block.LootrShulkerBlock;
import noobanidus.mods.lootr.common.block.entity.BlockEntityTicker;
import noobanidus.mods.lootr.common.block.entity.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.common.command.CustomConvertJob;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.data.LootrInventory;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.common.impl.IChunkMapGetChunks;
import noobanidus.mods.lootr.common.impl.LootrServiceRegistry;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBaseContainerBlockEntity;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinMinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CommandLootr {
    private static List<ResourceKey<LootTable>> tables = null;
    private static List<String> tableNames = null;
    private static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private static final FilenameFilter MCA_FILTER = (file, fileName) -> fileName.endsWith(".mca");

    private static List<ResourceKey<LootTable>> getTables(MinecraftServer server) {
        if (tables == null) {
            tables = server.reloadableRegistries().lookup().lookup(Registries.LOOT_TABLE).map(HolderLookup::listElementIds).orElse(Stream.of(new ResourceKey[0])).toList();
            tableNames = tables.stream().map(o -> o.identifier().toString()).toList();
        }
        return tables;
    }

    private static List<String> getTableNames(MinecraftServer server) {
        CommandLootr.getTables(server);
        return tableNames;
    }

    public static void createBlock(CommandSourceStack c, @Nullable Block block, @Nullable ResourceKey<LootTable> incomingTable) {
        ServerLevel world = c.getLevel();
        Vec3 incomingPos = c.getPosition();
        BlockPos pos = new BlockPos((int)incomingPos.x, (int)incomingPos.y, (int)incomingPos.z);
        ResourceKey<LootTable> table = incomingTable == null ? CommandLootr.getTables(c.getServer()).get(world.getRandom().nextInt(CommandLootr.getTables(c.getServer()).size())) : incomingTable;
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            Entity e = c.getEntity();
            if (e != null) {
                cart.setYRot(e.getYRot());
            }
            cart.setLootTable(table, world.getRandom().nextLong());
            world.addFreshEntity((Entity)cart);
            c.sendSuccess(() -> Component.translatable((String)"lootr.commands.summon", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN)).withBold(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            BlockState placementState = block.defaultBlockState();
            Entity e = c.getEntity();
            if (e != null) {
                EnumProperty prop = null;
                Direction dir = Direction.orderedByNearest((Entity)e)[0].getOpposite();
                if (placementState.hasProperty((Property)LootrBarrelBlock.FACING)) {
                    prop = LootrBarrelBlock.FACING;
                } else if (placementState.hasProperty((Property)LootrChestBlock.FACING)) {
                    prop = LootrChestBlock.FACING;
                    dir = e.getDirection().getOpposite();
                } else if (placementState.hasProperty((Property)LootrShulkerBlock.FACING)) {
                    prop = LootrShulkerBlock.FACING;
                }
                if (prop != null) {
                    placementState = (BlockState)placementState.setValue((Property)prop, (Comparable)dir);
                }
            }
            world.setBlock(pos, placementState, 2);
            ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(world.getBlockEntity(pos));
            if (iLootrBlockEntity instanceof ILootrBlockEntity) {
                ILootrBlockEntity randomizableBe = iLootrBlockEntity;
                randomizableBe.setLootTableInternal(table, world.getRandom().nextLong());
            }
            c.sendSuccess(() -> Component.translatable((String)"lootr.commands.create", (Object[])new Object[]{Component.translatable((String)block.getDescriptionId()), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN)).withBold(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.withSize((int)reference.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).copy());
        }
        return contents;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(CommandLootr.builder((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"lootr").requires(p -> p.permissions().hasPermission(Permissions.COMMANDS_GAMEMASTER)))));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Identifier> suggestTables() {
        return Commands.argument((String)"table", (ArgumentType)IdentifierArgument.id()).suggests((c, build) -> SharedSuggestionProvider.suggest(CommandLootr.getTableNames(((CommandSourceStack)c.getSource()).getServer()), (SuggestionsBuilder)build));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> builder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.translatable((String)"lootr.commands.usage", (Object[])new Object[]{Component.literal((String)LootrServiceRegistry.getCommandExtensionsString())}), false);
            return 1;
        });
        for (ILootrCommandExtension extension : LootrServiceRegistry.getCommandExtensions()) {
            builder.then(((LiteralArgumentBuilder)Commands.literal((String)extension.getId()).executes(c -> {
                CommandLootr.createBlock((CommandSourceStack)c.getSource(), extension.getBlock(), null);
                return 1;
            })).then(CommandLootr.suggestTables().executes(c -> {
                CommandLootr.createBlock((CommandSourceStack)c.getSource(), extension.getBlock(), (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)IdentifierArgument.getId((CommandContext)c, (String)"table")));
                return 1;
            })));
        }
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Must provide player name."), true);
            return 1;
        })).then(Commands.argument((String)"profile", (ArgumentType)StringArgumentType.string()).executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((CommandSourceStack)c.getSource()).getServer().services().profileRepository().findProfileByName(playerName);
            if (!opt_profile.isPresent()) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            NameAndId profile = (NameAndId)opt_profile.get();
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)(LootrAPI.clearPlayerLoot(profile.id()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear")), true);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"cart").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, null);
            return 1;
        })).then(CommandLootr.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)IdentifierArgument.getId((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(Commands.literal((String)"custom-chest").executes(c -> {
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockState state = level.getBlockState(pos);
            if (!state.is(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                pos = pos.below();
                state = level.getBlockState(pos);
            }
            if (!state.is(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on the container you wish to convert."), false);
            } else {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof BaseContainerBlockEntity)) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on the container you wish to convert."), false);
                    return 0;
                }
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
                NonNullList<ItemStack> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                BlockState newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().defaultBlockState());
                NonNullList<ItemStack> custom = CommandLootr.copyItemList(reference);
                level.removeBlockEntity(pos);
                level.setBlockAndUpdate(pos, newState);
                BlockEntity te = level.getBlockEntity(pos);
                if (!(te instanceof LootrInventoryBlockEntity)) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.setChanged();
                }
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"open_as").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Must provide player name."), true);
            return 1;
        })).executes(c -> {
            ILootrBlockEntity ibe;
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((CommandSourceStack)c.getSource()).getServer().services().profileRepository().findProfileByName(playerName);
            if (!opt_profile.isPresent()) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            NameAndId profile = (NameAndId)opt_profile.get();
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity te = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                te = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            if (data == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"No Lootr data found for this container."), false);
                return 0;
            }
            LootrInventory inventory = data.getInventory(profile.id());
            if (inventory == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("No stored inventory for " + playerName + " found.")), true);
                return 0;
            }
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayer();
            if (player == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.openMenu((MenuProvider)inventory);
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"open_as_uuid").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Must provide player UUID."), true);
            return 1;
        })).then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(c -> {
            ILootrBlockEntity ibe;
            UUID id;
            String uuid = StringArgumentType.getString((CommandContext)c, (String)"uuid");
            try {
                id = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException exception) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Invalid UUID: " + uuid)));
                return 0;
            }
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity te = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                te = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            if (data == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"No Lootr data found for this container."), true);
                return 0;
            }
            LootrInventory inventory = data.getInventory(id);
            if (inventory == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("No stored inventory for " + String.valueOf(id) + " found.")), true);
                return 0;
            }
            ServerPlayer player = ((CommandSourceStack)c.getSource()).getPlayer();
            if (player == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.openMenu((MenuProvider)inventory);
            return 1;
        })));
        builder.then(Commands.literal((String)"id").executes(c -> {
            ILootrBlockEntity ibe;
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel world = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity te = world.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                te = world.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"The ID of this inventory is: ").append((Component)ComponentUtils.copyOnClickText((String)ibe.getInfoUUID().toString())), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"refresh").executes(c -> {
            ILootrBlockEntity ibe;
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                be = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setRefreshing(ibe);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to refresh with a delay of " + LootrAPI.getRefreshValue())), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"decay").executes(c -> {
            ILootrBlockEntity ibe;
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition());
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.below();
                be = level.getBlockEntity(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setDecaying(ibe);
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to decay with a delay of " + LootrAPI.getDecayValue())), false);
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"openers").then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(c -> {
            BlockPos position = Vec3Argument.getCoordinates((CommandContext)c, (String)"location").getBlockPos((CommandSourceStack)c.getSource());
            ServerLevel world = ((CommandSourceStack)c.getSource()).getLevel();
            BlockEntity blockEntity = world.getBlockEntity(position);
            ILootrBlockEntity ibe = LootrAPI.resolveBlockEntity(blockEntity);
            if (ibe != null) {
                Set<UUID> openers = ibe.getActualOpeners();
                if (openers != null) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("BlockEntity at location " + String.valueOf(position) + " has " + openers.size() + " openers. UUIDs as follows:")), true);
                    for (UUID uuid : openers) {
                        Optional prof = ((CommandSourceStack)c.getSource()).getServer().services().profileResolver().fetchById(uuid);
                        ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("UUID: " + String.valueOf(uuid) + ", user profile: " + (prof.isPresent() ? ((GameProfile)prof.get()).name() : "null"))), true);
                    }
                }
            } else {
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("No Lootr block entity exists at location: " + String.valueOf(position))), false);
            }
            return 1;
        })));
        builder.then(Commands.literal((String)"custom-map").then(Commands.argument((String)"level", (ArgumentType)DimensionArgument.dimension()).executes(c -> {
            ServerLevel levelKey = DimensionArgument.getDimension((CommandContext)c, (String)"level");
            CustomConvertJob.start(((CommandSourceStack)c.getSource()).getServer(), levelKey, CommandLootr.getAllChunkPositions(levelKey), (CommandSourceStack)c.getSource());
            return 1;
        })));
        builder.then(Commands.literal((String)"custom-area").then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BoundingBox bounds = BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"to"));
            ChunkPos start = new ChunkPos(new BlockPos(bounds.minX(), bounds.minY(), bounds.minZ()));
            ChunkPos stop = new ChunkPos(new BlockPos(bounds.maxX(), bounds.maxY(), bounds.maxZ()));
            ArrayList<ChunkPos> positions = new ArrayList<ChunkPos>();
            for (int x = start.x; x <= stop.x; ++x) {
                for (int z = start.z; z <= stop.z; ++z) {
                    positions.add(new ChunkPos(x, z));
                }
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            for (ChunkPos chunkPos : positions) {
                LevelChunk chunk = level.getChunk(chunkPos.x, chunkPos.z);
                ArrayList<BlockPos> convertableBlocks = new ArrayList<BlockPos>();
                for (BlockPos pos : chunk.getBlockEntitiesPos()) {
                    if (!bounds.isInside((Vec3i)pos)) continue;
                    convertableBlocks.add(pos);
                }
                if (convertableBlocks.isEmpty()) continue;
                for (BlockPos pos : convertableBlocks) {
                    BlockState state;
                    RandomizableContainerBlockEntity lootContainer;
                    BlockEntity blockEntity = chunk.getBlockEntity(pos, LevelChunk.EntityCreationType.IMMEDIATE);
                    if (!(blockEntity instanceof BaseContainerBlockEntity) || blockEntity instanceof RandomizableContainerBlockEntity && (lootContainer = (RandomizableContainerBlockEntity)blockEntity).getLootTable() != null || (state = blockEntity.getBlockState()).is(LootrTags.Blocks.CUSTOM_ELIGIBLE) || blockEntity.getType().builtInRegistryHolder().is(LootrTags.BlockEntity.CUSTOM_INELIGIBLE)) continue;
                    NonNullList<ItemStack> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                    BlockState newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().defaultBlockState());
                    NonNullList<ItemStack> custom = CommandLootr.copyItemList(reference);
                    level.removeBlockEntity(pos);
                    level.setBlockAndUpdate(pos, newState);
                    BlockEntity te = level.getBlockEntity(pos);
                    if (!(te instanceof LootrInventoryBlockEntity)) {
                        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Unable to convert chest at '" + String.valueOf(pos) + "', BlockState is not a Lootr Inventory block.")));
                        continue;
                    }
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.setChanged();
                }
            }
            return 1;
        }))));
        builder.then(Commands.literal((String)"cclear").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).executes(c -> {
            Collection entities = EntityArgument.getEntities((CommandContext)c, (String)"entities");
            for (Entity e : entities) {
                if (!(e instanceof Player)) continue;
                Player player = (Player)e;
                String name = player.getScoreboardName();
                ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)(DataStorage.clearInventories(player.getUUID()) ? "Cleared stored inventories for " + name : "No stored inventories for " + name + " to clear")), true);
            }
            return 1;
        })));
        builder.then(Commands.literal((String)"cull").executes(c -> {
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Going to asynchronously cull " + DataStorage.cullInventories() + " inventories.")), true);
            return 1;
        }));
        builder.then(Commands.literal((String)"force_chunk").executes(c -> {
            ChunkPos pos = new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition()));
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            ChunkAccess source = level.getChunkSource().getChunk(pos.x, pos.z, ChunkStatus.FULL, false);
            if (source instanceof LevelChunk) {
                LevelChunk levelChunk = (LevelChunk)source;
                for (BlockEntity be : levelChunk.getBlockEntities().values()) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Forcing BlockEntity[" + String.valueOf(be) + "] at " + String.valueOf(be.getBlockPos()) + " to be added to the queue.")), false);
                    BlockEntityTicker.addEntity(be, (Level)level, pos);
                }
            } else {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Chunk at " + pos.x + ", " + pos.z + " is not loaded somehow!")));
                return 0;
            }
            return 1;
        }));
        builder.then(Commands.literal((String)"force_radius").then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> {
            int radius;
            try {
                radius = IntegerArgumentType.getInteger((CommandContext)c, (String)"radius");
            }
            catch (NumberFormatException e) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"Radius must be an integer."));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            ChunkPos center = new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition()));
            for (int x = center.x - radius; x <= center.x + radius; ++x) {
                for (int z = center.z - radius; z <= center.z + radius; ++z) {
                    ChunkPos pos = new ChunkPos(x, z);
                    ChunkAccess source = level.getChunkSource().getChunk(pos.x, pos.z, ChunkStatus.FULL, false);
                    if (!(source instanceof LevelChunk)) continue;
                    LevelChunk levelChunk = (LevelChunk)source;
                    for (BlockEntity be : levelChunk.getBlockEntities().values()) {
                        ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Forcing BlockEntity[" + String.valueOf(be) + "] at " + String.valueOf(be.getBlockPos()) + " to be added to the queue.")), false);
                        BlockEntityTicker.addEntity(be, (Level)level, pos);
                    }
                }
            }
            return 1;
        })));
        builder.then(Commands.literal((String)"force_all").executes(c -> {
            ServerLevel level = ((CommandSourceStack)c.getSource()).getLevel();
            for (ChunkHolder holder : ((IChunkMapGetChunks)level.getChunkSource().chunkMap).lootr$getChunks()) {
                if (!holder.wasAccessibleSinceLastSave()) continue;
                holder.refreshAccessibility();
                ChunkAccess chunk = holder.getLatestChunk();
                if (!(chunk instanceof LevelChunk)) continue;
                LevelChunk levelChunk = (LevelChunk)chunk;
                ChunkPos pos = levelChunk.getPos();
                for (BlockEntity be : levelChunk.getBlockEntities().values()) {
                    ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Forcing BlockEntity[" + String.valueOf(be) + "] at " + String.valueOf(be.getBlockPos()) + " to be added to the queue.")), false);
                    BlockEntityTicker.addEntity(be, (Level)level, pos);
                }
            }
            return 1;
        }));
        return builder;
    }

    private static List<ChunkPos> getAllChunkPositions(ServerLevel level) {
        LevelStorageSource.LevelStorageAccess storage = ((AccessorMixinMinecraftServer)level.getServer()).Lootr$getStorageSource();
        RegionStorageInfo regionstorageinfo = new RegionStorageInfo(storage.getLevelId(), level.dimension(), "lootr");
        Path path = storage.getDimensionPath(level.dimension()).resolve("region");
        File[] directoryListing = path.toFile().listFiles(MCA_FILTER);
        if (directoryListing == null) {
            return List.of();
        }
        ArrayList<ChunkPos> allGeneratedChunkPositions = new ArrayList<ChunkPos>();
        for (File potentialRegionFile : directoryListing) {
            Matcher matcher = REGEX.matcher(potentialRegionFile.getName());
            if (!matcher.matches()) continue;
            int i = Integer.parseInt(matcher.group(1)) << 5;
            int j = Integer.parseInt(matcher.group(2)) << 5;
            ArrayList regionChunks = Lists.newArrayList();
            try (RegionFile regionfile = new RegionFile(regionstorageinfo, potentialRegionFile.toPath(), path, true);){
                for (int k = 0; k < 32; ++k) {
                    for (int l = 0; l < 32; ++l) {
                        ChunkPos chunkpos = new ChunkPos(k + i, l + j);
                        if (!regionfile.doesChunkExist(chunkpos)) continue;
                        regionChunks.add(chunkpos);
                    }
                }
                if (regionChunks.isEmpty()) continue;
                allGeneratedChunkPositions.addAll(regionChunks);
            }
            catch (Throwable throwable) {
                LootrAPI.LOG.error("Failed to read chunks from region file {}", (Object)potentialRegionFile.toPath(), (Object)throwable);
            }
        }
        return allGeneratedChunkPositions;
    }

    static BlockState updateBlockState(BlockState oldState, BlockState newState) {
        if (oldState.hasProperty((Property)BlockStateProperties.FACING) && newState.hasProperty((Property)BlockStateProperties.FACING)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)oldState.getValue((Property)BlockStateProperties.FACING)));
        }
        if (oldState.hasProperty((Property)HorizontalDirectionalBlock.FACING) && newState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)oldState.getValue((Property)HorizontalDirectionalBlock.FACING)));
        }
        if (oldState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && newState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.WATERLOGGED)));
        }
        return newState;
    }
}

