/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.block.entity.LootrBrushableBlockEntity;
import noobanidus.mods.lootr.common.client.ClientHooks;
import noobanidus.mods.lootr.common.client.state.LootrBrushableBlockRenderState;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public class LootrBrushableBlockRenderer
implements BlockEntityRenderer<LootrBrushableBlockEntity, LootrBrushableBlockRenderState> {
    private final ItemModelResolver itemModelResolver;

    public LootrBrushableBlockRenderer(BlockEntityRendererProvider.Context arg) {
        this.itemModelResolver = arg.itemModelResolver();
    }

    public LootrBrushableBlockRenderState createRenderState() {
        return new LootrBrushableBlockRenderState();
    }

    public void extractRenderState(LootrBrushableBlockEntity blockEntity, LootrBrushableBlockRenderState renderState, float partialTick, Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.hitDirection = blockEntity.getHitDirection();
        renderState.dustProgress = (Integer)blockEntity.getBlockState().getValue((Property)BlockStateProperties.DUSTED);
        if (blockEntity.getLevel() != null && blockEntity.getHitDirection() != null) {
            renderState.lightCoords = LevelRenderer.getLightColor((LevelRenderer.BrightnessGetter)LevelRenderer.BrightnessGetter.DEFAULT, (BlockAndTintGetter)blockEntity.getLevel(), (BlockState)blockEntity.getBlockState(), (BlockPos)blockEntity.getBlockPos().relative(blockEntity.getHitDirection()));
        }
        this.itemModelResolver.updateForTopItem(renderState.itemState, blockEntity.getItem(), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        Player player = ClientHooks.getPlayer();
        renderState.thisPlayerBrushing = player != null && blockEntity.isBrushingPlayer(player);
        renderState.visuallyOpen = player != null && blockEntity.hasClientOpened(player);
    }

    public void submit(LootrBrushableBlockRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.dustProgress > 0 && renderState.hitDirection != null && !renderState.itemState.isEmpty() && renderState.thisPlayerBrushing) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.5f, 0.0f);
            float[] afloat = this.translations(renderState.hitDirection, renderState.dustProgress);
            poseStack.translate(afloat[0], afloat[1], afloat[2]);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(75.0f));
            boolean flag = renderState.hitDirection == Direction.EAST || renderState.hitDirection == Direction.WEST;
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)((flag ? 90 : 0) + 11)));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            renderState.itemState.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    private float[] translations(Direction arg, int i) {
        float[] afloat = new float[]{0.5f, 0.0f, 0.5f};
        float f = (float)i / 10.0f * 0.75f;
        switch (arg) {
            case EAST: {
                afloat[0] = 0.73f + f;
                break;
            }
            case WEST: {
                afloat[0] = 0.25f - f;
                break;
            }
            case UP: {
                afloat[1] = 0.25f + f;
                break;
            }
            case DOWN: {
                afloat[1] = -0.23f - f;
                break;
            }
            case NORTH: {
                afloat[2] = 0.25f - f;
                break;
            }
            case SOUTH: {
                afloat[2] = 0.73f + f;
            }
        }
        return afloat;
    }
}

