/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.client.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.client.FacingUtil;
import noobanidus.mods.lootr.neoforge.init.ModBlockProperties;
import org.jetbrains.annotations.Nullable;

public class UnbakedBarrelBlockStateModel
implements CustomUnbakedBlockStateModel {
    public static final UnbakedBarrelBlockStateModel INSTANCE = new UnbakedBarrelBlockStateModel();
    public static MapCodec<UnbakedBarrelBlockStateModel> CODEC = MapCodec.unit((Object)INSTANCE);
    private static final Identifier LOOTR_BARREL_UNOPENED = LootrAPI.rl("block/lootr_barrel_unopened");
    private static final Identifier LOOTR_BARREL_UNOPENED_OPEN = LootrAPI.rl("block/lootr_barrel_unopened_open");
    private static final Identifier LOOTR_OPENED_BARREL = LootrAPI.rl("block/lootr_opened_barrel");
    private static final Identifier LOOTR_OPENED_BARREL_OPEN = LootrAPI.rl("block/lootr_opened_barrel_open");
    private static final Identifier VANILLA = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"block/barrel");
    private static final Identifier VANILLA_OPEN = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"block/barrel_open");
    private static final Identifier OLD_LOOTR_BARREL_UNOPENED = LootrAPI.rl("block/old_lootr_barrel_unopened");
    private static final Identifier OLD_LOOTR_BARREL_UNOPENED_OPEN = LootrAPI.rl("block/old_lootr_barrel_unopened_open");
    private static final Identifier OLD_LOOTR_OPENED_BARREL = LootrAPI.rl("block/old_lootr_opened_barrel");
    private static final Identifier OLD_LOOTR_OPENED_BARREL_OPEN = LootrAPI.rl("block/old_lootr_opened_barrel_open");

    public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
        return CODEC;
    }

    public BlockStateModel bake(ModelBaker modelBaker) {
        BlockStateModel[] lootrBarrelUnopened = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, LOOTR_BARREL_UNOPENED);
        BlockStateModel[] lootrBarrelUnopenedOpen = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, LOOTR_BARREL_UNOPENED_OPEN);
        BlockStateModel[] lootrOpenedBarrel = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, LOOTR_OPENED_BARREL);
        BlockStateModel[] lootrOpenedBarrelOpen = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, LOOTR_OPENED_BARREL_OPEN);
        BlockStateModel[] vanilla = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, VANILLA);
        BlockStateModel[] vanillaOpen = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, VANILLA_OPEN);
        BlockStateModel[] oldLootrBarrelUnopened = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, OLD_LOOTR_BARREL_UNOPENED);
        BlockStateModel[] oldLootrBarrelUnopenedOpen = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, OLD_LOOTR_BARREL_UNOPENED_OPEN);
        BlockStateModel[] oldLootrOpenedBarrel = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, OLD_LOOTR_OPENED_BARREL);
        BlockStateModel[] oldLootrOpenedBarrelOpen = UnbakedBarrelBlockStateModel.bakeDirectionalVariants(modelBaker, OLD_LOOTR_OPENED_BARREL_OPEN);
        return new Baked(lootrBarrelUnopened, lootrBarrelUnopenedOpen, lootrOpenedBarrel, lootrOpenedBarrelOpen, vanilla, vanillaOpen, oldLootrBarrelUnopened, oldLootrBarrelUnopenedOpen, oldLootrOpenedBarrel, oldLootrOpenedBarrelOpen);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        resolver.markDependency(LOOTR_BARREL_UNOPENED);
        resolver.markDependency(LOOTR_BARREL_UNOPENED_OPEN);
        resolver.markDependency(LOOTR_OPENED_BARREL);
        resolver.markDependency(LOOTR_OPENED_BARREL_OPEN);
        resolver.markDependency(VANILLA);
        resolver.markDependency(VANILLA_OPEN);
        resolver.markDependency(OLD_LOOTR_BARREL_UNOPENED);
        resolver.markDependency(OLD_LOOTR_BARREL_UNOPENED_OPEN);
        resolver.markDependency(OLD_LOOTR_OPENED_BARREL);
        resolver.markDependency(OLD_LOOTR_OPENED_BARREL_OPEN);
    }

    public static BlockStateModel[] bakeDirectionalVariants(ModelBaker baker, Identifier model) {
        BlockStateModel[] result = new BlockStateModel[6];
        for (Direction dir : Direction.values()) {
            result[dir.ordinal()] = new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)model, (ModelState)FacingUtil.transformFor(dir)));
        }
        return result;
    }

    public record Baked(BlockStateModel[] lootrBarrelUnopened, BlockStateModel[] lootrBarrelUnopenedOpen, BlockStateModel[] lootrOpenedBarrel, BlockStateModel[] lootrOpenedBarrelOpen, BlockStateModel[] vanilla, BlockStateModel[] vanillaOpen, BlockStateModel[] oldLootrBarrelUnopened, BlockStateModel[] oldLootrBarrelUnopenedOpen, BlockStateModel[] oldLootrOpenedBarrel, BlockStateModel[] oldLootrOpenedBarrelOpen) implements DynamicBlockStateModel
    {
        public TextureAtlasSprite particleIcon() {
            if (LootrAPI.isVanillaTextures()) {
                return this.vanilla[Direction.DOWN.ordinal()].particleIcon();
            }
            if (LootrAPI.isOldTextures()) {
                return this.oldLootrBarrelUnopened[Direction.DOWN.ordinal()].particleIcon();
            }
            return this.lootrBarrelUnopened[Direction.DOWN.ordinal()].particleIcon();
        }

        public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
            if (state.isAir()) {
                if (LootrAPI.isVanillaTextures()) {
                    this.vanilla[Direction.NORTH.ordinal()].collectParts(level, pos, state, random, parts);
                } else if (LootrAPI.isOldTextures()) {
                    this.oldLootrBarrelUnopened[Direction.NORTH.ordinal()].collectParts(level, pos, state, random, parts);
                } else {
                    this.lootrBarrelUnopened[Direction.NORTH.ordinal()].collectParts(level, pos, state, random, parts);
                }
                return;
            }
            boolean visuallyOpen = level.getModelData(pos).get(ModBlockProperties.OPENED) == Boolean.TRUE;
            boolean open = (Boolean)state.getValue((Property)BarrelBlock.OPEN);
            int facing = ((Direction)state.getValue((Property)BarrelBlock.FACING)).ordinal();
            BlockStateModel[] modelCollection = LootrAPI.isVanillaTextures() ? (open ? this.vanillaOpen : this.vanilla) : (LootrAPI.isOldTextures() ? (visuallyOpen ? (open ? this.oldLootrOpenedBarrelOpen : this.oldLootrOpenedBarrel) : (open ? this.oldLootrBarrelUnopenedOpen : this.oldLootrBarrelUnopened)) : (visuallyOpen ? (open ? this.lootrOpenedBarrelOpen : this.lootrOpenedBarrel) : (open ? this.lootrBarrelUnopenedOpen : this.lootrBarrelUnopened)));
            modelCollection[facing].collectParts(level, pos, state, random, parts);
        }

        @Nullable
        public Object createGeometryKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
            boolean visuallyOpen = level.getModelData(pos).get(ModBlockProperties.OPENED) == Boolean.TRUE;
            boolean open = (Boolean)state.getValue((Property)BarrelBlock.OPEN);
            int facing = ((Direction)state.getValue((Property)BarrelBlock.FACING)).ordinal();
            boolean vanilla = LootrAPI.isVanillaTextures();
            boolean old = LootrAPI.isOldTextures();
            return new BarrelKey(vanilla, old, open, visuallyOpen, facing);
        }
    }

    public record BarrelKey(boolean vanilla, boolean old, boolean open, boolean visuallyOpen, int facing) {
    }
}

