/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.chest.ChestModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AbstractMinecartRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.MinecartRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.world.level.block.state.BlockState;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.client.block.LootrChestBlockRenderer;
import noobanidus.mods.lootr.common.client.entity.LootrCartRenderState;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;

public class LootrChestCartRenderer<T extends LootrChestMinecartEntity>
extends AbstractMinecartRenderer<T, LootrCartRenderState> {
    private final MaterialSet materials;
    private final ChestModel chestModel;

    public LootrChestCartRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, modelLayerLocation);
        this.chestModel = new ChestModel(context.bakeLayer(ModelLayers.CHEST));
        this.materials = context.getMaterials();
    }

    protected void submitMinecartContents(LootrCartRenderState renderState, BlockState blockState, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        float f = 0.0f;
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        Material material = LootrChestBlockRenderer.getMaterial(false, renderState.open);
        RenderType rendertype = material.renderType(arg_0 -> ((ChestModel)this.chestModel).renderType(arg_0));
        TextureAtlasSprite textureatlassprite = this.materials.get(material);
        nodeCollector.submitModel((Model)this.chestModel, (Object)Float.valueOf(f), poseStack, rendertype, renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureatlassprite, 0, null);
        poseStack.popPose();
    }

    public LootrCartRenderState createRenderState() {
        return new LootrCartRenderState();
    }

    public void extractRenderState(T abstractMinecart, LootrCartRenderState minecartRenderState, float f) {
        super.extractRenderState(abstractMinecart, (MinecartRenderState)minecartRenderState, f);
        minecartRenderState.open = ((LootrChestMinecartEntity)abstractMinecart).isClientOpened();
        minecartRenderState.classic = LootrAPI.isOldTextures();
        minecartRenderState.vanilla = LootrAPI.isVanillaTextures();
    }
}

