/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.gen;

import com.mojang.math.Quadrant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.SpecialModelWrapper;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.blockstate.CustomBlockStateModelBuilder;
import net.neoforged.neoforge.client.model.generators.blockstate.UnbakedMutator;
import noobanidus.mods.lootr.common.api.ConfigDisplayType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.block.LootrBarrelBlock;
import noobanidus.mods.lootr.common.client.select.SelectConfigType;
import noobanidus.mods.lootr.common.client.special.LootrChestSpecialRenderer;
import noobanidus.mods.lootr.common.client.special.LootrDecoratedPotSpecialRenderer;
import noobanidus.mods.lootr.common.client.special.LootrShulkerSpecialRenderer;
import noobanidus.mods.lootr.neoforge.client.block.UnbakedBrushableModel;
import noobanidus.mods.lootr.neoforge.client.block.UnbakedCustomModel;
import noobanidus.mods.lootr.neoforge.gen.builders.UnbakedBrushableModelBuilder;
import noobanidus.mods.lootr.neoforge.gen.builders.UnbakedCustomModelBuilder;
import noobanidus.mods.lootr.neoforge.init.ModBlocks;
import noobanidus.mods.lootr.neoforge.init.ModItems;

public class LootrModelProvider
extends ModelProvider {
    public LootrModelProvider(PackOutput output) {
        super(output, "lootr");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        UnbakedCustomModel opened = new UnbakedCustomModel(LootrAPI.rl("block/lootr_opened_barrel"), LootrAPI.rl("block/lootr_barrel_unopened"), Identifier.withDefaultNamespace((String)"block/barrel"), Variant.SimpleModelState.DEFAULT, false);
        UnbakedCustomModel unopened = new UnbakedCustomModel(LootrAPI.rl("block/lootr_opened_barrel_open"), LootrAPI.rl("block/lootr_barrel_unopened_open"), Identifier.withDefaultNamespace((String)"block/barrel_open"), Variant.SimpleModelState.DEFAULT, true);
        MultiVariant baseVariant = MultiVariant.of((CustomBlockStateModelBuilder)new UnbakedCustomModelBuilder(opened));
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ModBlocks.BARREL.get()), (MultiVariant)baseVariant).withUnbaked(PropertyDispatch.modifyUnbaked((Property)LootrBarrelBlock.FACING, (Property)LootrBarrelBlock.OPEN).generate((facing, open) -> {
            Quadrant rotX = facing == Direction.UP ? Quadrant.R180 : Quadrant.R90;
            Quadrant rotY = facing.getAxis() != Direction.Axis.Y ? Quadrant.values()[(int)facing.toYRot() / 90] : Quadrant.R0;
            return UnbakedMutator.builder().add(UnbakedCustomModel.class, unbaked -> open != false ? unopened.withState(unbaked.getState().withX(rotX).withY(rotY)) : opened.withState(unbaked.getState().withX(rotX).withY(rotY))).build();
        })));
        UnbakedBrushableModel sandBase = new UnbakedBrushableModel(LootrAPI.rl("block/suspicious_sand_open"), Identifier.withDefaultNamespace((String)"block/suspicious_sand_0"), Identifier.withDefaultNamespace((String)"block/suspicious_sand_1"), Identifier.withDefaultNamespace((String)"block/suspicious_sand_2"), Identifier.withDefaultNamespace((String)"block/suspicious_sand_3"), Variant.SimpleModelState.DEFAULT);
        MultiVariant sandVariants = MultiVariant.of((CustomBlockStateModelBuilder)new UnbakedBrushableModelBuilder(sandBase));
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ModBlocks.SUSPICIOUS_SAND.get()), (MultiVariant)sandVariants).withUnbaked(PropertyDispatch.modifyUnbaked((Property)BlockStateProperties.DUSTED).generate(stage -> UnbakedMutator.builder().add(UnbakedBrushableModel.class, unbaked -> unbaked).build())));
        UnbakedBrushableModel gravelBase = new UnbakedBrushableModel(LootrAPI.rl("block/suspicious_gravel_open"), Identifier.withDefaultNamespace((String)"block/suspicious_gravel_0"), Identifier.withDefaultNamespace((String)"block/suspicious_gravel_1"), Identifier.withDefaultNamespace((String)"block/suspicious_gravel_2"), Identifier.withDefaultNamespace((String)"block/suspicious_gravel_3"), Variant.SimpleModelState.DEFAULT);
        MultiVariant gravelVariants = MultiVariant.of((CustomBlockStateModelBuilder)new UnbakedBrushableModelBuilder(gravelBase));
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ModBlocks.SUSPICIOUS_GRAVEL.get()), (MultiVariant)gravelVariants).withUnbaked(PropertyDispatch.modifyUnbaked((Property)BlockStateProperties.DUSTED).generate(stage -> UnbakedMutator.builder().add(UnbakedBrushableModel.class, unbaked -> unbaked).build())));
        itemModels.itemModelOutput.accept((Item)ModItems.BARREL.get(), (ItemModel.Unbaked)new SelectItemModel.Unbaked(new SelectItemModel.UnbakedSwitch((SelectItemModelProperty)new SelectConfigType(), List.of(new SelectItemModel.SwitchCase(List.of(ConfigDisplayType.VANILLA), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"block/barrel"), Collections.emptyList())), new SelectItemModel.SwitchCase(List.of(ConfigDisplayType.OLD, ConfigDisplayType.DEFAULT), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(LootrAPI.rl("block/lootr_barrel_unopened"), Collections.emptyList())))), Optional.of(new BlockModelWrapper.Unbaked(LootrAPI.rl("block/lootr_barrel_unopened"), Collections.emptyList()))));
        itemModels.itemModelOutput.accept((Item)ModItems.SUSPICIOUS_GRAVEL.get(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"block/suspicious_gravel_0"), Collections.emptyList()));
        itemModels.itemModelOutput.accept((Item)ModItems.SUSPICIOUS_SAND.get(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"block/suspicious_sand_0"), Collections.emptyList()));
        itemModels.itemModelOutput.accept((Item)ModItems.CHEST.get(), (ItemModel.Unbaked)new SpecialModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"item/chest"), (SpecialModelRenderer.Unbaked)new LootrChestSpecialRenderer.Unbaked(LootrAPI.rl("chest"), Identifier.withDefaultNamespace((String)"entity/chest/normal"))));
        itemModels.itemModelOutput.accept((Item)ModItems.TRAPPED_CHEST.get(), (ItemModel.Unbaked)new SpecialModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"item/chest"), (SpecialModelRenderer.Unbaked)new LootrChestSpecialRenderer.Unbaked(LootrAPI.rl("chest_trapped"), Identifier.withDefaultNamespace((String)"entity/chest/trapped"))));
        itemModels.itemModelOutput.accept((Item)ModItems.INVENTORY.get(), (ItemModel.Unbaked)new SpecialModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"item/chest"), (SpecialModelRenderer.Unbaked)new LootrChestSpecialRenderer.Unbaked(LootrAPI.rl("chest"), Identifier.withDefaultNamespace((String)"entity/chest/normal"))));
        itemModels.itemModelOutput.accept((Item)ModItems.SHULKER.get(), (ItemModel.Unbaked)new SpecialModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"item/shulker_box"), (SpecialModelRenderer.Unbaked)new LootrShulkerSpecialRenderer.Unbaked(LootrAPI.rl("shulker"))));
        itemModels.itemModelOutput.accept((Item)ModItems.DECORATED_POT.get(), (ItemModel.Unbaked)new SpecialModelWrapper.Unbaked(Identifier.withDefaultNamespace((String)"item/decorated_pot"), (SpecialModelRenderer.Unbaked)LootrDecoratedPotSpecialRenderer.Unbaked.decoratedPot()));
        itemModels.itemModelOutput.accept((Item)ModItems.TROPHY.get(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(LootrAPI.rl("block/trophy"), Collections.emptyList()));
    }

    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        return Stream.of(ModBlocks.BARREL, ModBlocks.SUSPICIOUS_GRAVEL, ModBlocks.SUSPICIOUS_SAND);
    }
}

