/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.command;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.block.entity.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.common.command.CommandLootr;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBaseContainerBlockEntity;

public final class CustomConvertJob {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("lootr-convert-%d").build();
    private static Thread convertThread;
    private static final int TICKET_LEVEL = 2;
    private static final int batchSize = 2;

    public static void start(MinecraftServer server, ServerLevel level, List<ChunkPos> positions, CommandSourceStack src) {
        if (convertThread != null && convertThread.isAlive()) {
            src.sendFailure((Component)Component.literal((String)"A conversion job is already running."));
            return;
        }
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger processed = new AtomicInteger();
        AtomicInteger converted = new AtomicInteger();
        AtomicInteger skipped = new AtomicInteger();
        AtomicInteger convertedBlockEntities = new AtomicInteger();
        convertThread = THREAD_FACTORY.newThread(() -> {
            try {
                for (int i = 0; i < positions.size() && running.get(); i += 2) {
                    int from = i;
                    int to = Math.min(i + 2, positions.size());
                    CompletableFuture batchDone = new CompletableFuture();
                    server.execute(() -> {
                        try {
                            for (int j = from; j < to; ++j) {
                                ChunkPos cp = (ChunkPos)positions.get(j);
                                int convertedCount = CustomConvertJob.processOneChunkOnServerThread(level, cp, src);
                                processed.incrementAndGet();
                                if (convertedCount > 0) {
                                    converted.incrementAndGet();
                                    convertedBlockEntities.addAndGet(convertedCount);
                                    continue;
                                }
                                skipped.incrementAndGet();
                            }
                            if (processed.get() % 50 == 0) {
                                src.sendSuccess(() -> Component.literal((String)("Progress: " + processed.get() + "/" + positions.size() + " converted=" + converted.get() + " chunks, skipped=" + skipped.get() + " empty chunks, converted a total of " + convertedBlockEntities.get() + " block entities to custom inventories.")), true);
                            }
                            batchDone.complete(null);
                        }
                        catch (Throwable t) {
                            batchDone.completeExceptionally(t);
                        }
                    });
                    batchDone.join();
                }
                server.execute(() -> src.sendSuccess(() -> Component.literal((String)("Conversion complete. processed=" + processed.get() + " converted=" + converted.get() + " skipped=" + skipped.get())), true));
            }
            catch (Throwable t) {
                server.execute(() -> src.sendFailure((Component)Component.literal((String)("Conversion failed: " + String.valueOf(t)))));
            }
        });
        convertThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int processOneChunkOnServerThread(ServerLevel level, ChunkPos pos, CommandSourceStack src) {
        if (level == null) {
            src.sendFailure((Component)Component.literal((String)"Level not found."));
            return 0;
        }
        level.getChunkSource().addTicketWithRadius(TicketType.FORCED, pos, 0);
        try {
            LevelChunk chunk = level.getChunk(pos.x, pos.z);
            int changed = 0;
            for (BlockPos bePos : chunk.getBlockEntitiesPos()) {
                BaseContainerBlockEntity container;
                BlockEntity be = chunk.getBlockEntity(bePos, LevelChunk.EntityCreationType.IMMEDIATE);
                if (be == null || LootrTags.BlockEntity.isTagged(be, LootrTags.BlockEntity.CUSTOM_INELIGIBLE) || !be.getBlockState().is(LootrTags.Blocks.CUSTOM_ELIGIBLE) || !(be instanceof BaseContainerBlockEntity) || (container = (BaseContainerBlockEntity)be).isEmpty()) continue;
                changed += CustomConvertJob.convertAt(level, bePos, be, src);
            }
            int n = changed;
            return n;
        }
        finally {
            level.getChunkSource().removeTicketWithRadius(TicketType.FORCED, pos, 0);
        }
    }

    private static int convertAt(ServerLevel level, BlockPos pos, BlockEntity blockEntity, CommandSourceStack src) {
        BlockState state = blockEntity.getBlockState();
        NonNullList<ItemStack> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
        BlockState newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().defaultBlockState());
        NonNullList<ItemStack> custom = CommandLootr.copyItemList(reference);
        level.removeBlockEntity(pos);
        level.setBlockAndUpdate(pos, newState);
        BlockEntity te = level.getBlockEntity(pos);
        if (!(te instanceof LootrInventoryBlockEntity)) {
            src.sendFailure((Component)Component.literal((String)("Unable to convert chest at '" + String.valueOf(pos) + "', BlockState is not a Lootr Inventory block.")));
            return 0;
        }
        LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
        inventory.setCustomInventory(custom);
        inventory.setChanged();
        return 1;
    }
}

