/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.NonNull;

public abstract class UnbakedBrushableModel
implements BlockStateModel.Unbaked {
    protected final Identifier opened;
    protected final Identifier stage_0;
    protected final Identifier stage_1;
    protected final Identifier stage_2;
    protected final Identifier stage_3;
    protected final Variant.SimpleModelState state;

    public static <T extends UnbakedBrushableModel> MapCodec<T> getCodec(Provider<T> provider) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Identifier.CODEC.fieldOf("opened").forGetter(UnbakedBrushableModel::getOpened), (App)Identifier.CODEC.fieldOf("stage_0").forGetter(UnbakedBrushableModel::getStage0), (App)Identifier.CODEC.fieldOf("stage_1").forGetter(UnbakedBrushableModel::getStage1), (App)Identifier.CODEC.fieldOf("stage_2").forGetter(UnbakedBrushableModel::getStage2), (App)Identifier.CODEC.fieldOf("stage_3").forGetter(UnbakedBrushableModel::getStage3), (App)Variant.SimpleModelState.MAP_CODEC.fieldOf("state").forGetter(UnbakedBrushableModel::getState)).apply((Applicative)instance, provider::create));
    }

    public UnbakedBrushableModel(Identifier opened, Identifier stage_0, Identifier stage_1, Identifier stage_2, Identifier stage_3, Variant.SimpleModelState state) {
        this.opened = opened;
        this.stage_0 = stage_0;
        this.stage_1 = stage_1;
        this.stage_2 = stage_2;
        this.stage_3 = stage_3;
        this.state = state;
    }

    public Identifier getOpened() {
        return this.opened;
    }

    public Identifier getStage0() {
        return this.stage_0;
    }

    public Identifier getStage1() {
        return this.stage_1;
    }

    public Identifier getStage2() {
        return this.stage_2;
    }

    public Identifier getStage3() {
        return this.stage_3;
    }

    public Variant.SimpleModelState getState() {
        return this.state;
    }

    protected abstract Baker getBaker();

    public BlockStateModel bake(ModelBaker baker) {
        return this.getBaker().bake((BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.opened, (ModelState)this.state.asModelState())), (BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.stage_0, (ModelState)this.state.asModelState())), (BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.stage_1, (ModelState)this.state.asModelState())), (BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.stage_2, (ModelState)this.state.asModelState())), (BlockStateModel)new SingleVariant(SimpleModelWrapper.bake((ModelBaker)baker, (Identifier)this.stage_3, (ModelState)this.state.asModelState())));
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        resolver.markDependency(this.opened);
        resolver.markDependency(this.stage_0);
        resolver.markDependency(this.stage_1);
        resolver.markDependency(this.stage_2);
        resolver.markDependency(this.stage_3);
    }

    @FunctionalInterface
    public static interface Provider<T extends UnbakedBrushableModel> {
        public T create(Identifier var1, Identifier var2, Identifier var3, Identifier var4, Identifier var5, Variant.SimpleModelState var6);
    }

    @FunctionalInterface
    public static interface Baker {
        public BlockStateModel bake(BlockStateModel var1, BlockStateModel var2, BlockStateModel var3, BlockStateModel var4, BlockStateModel var5);
    }

    public static abstract class Baked
    implements BlockStateModel {
        protected final BlockStateModel opened;
        protected final BlockStateModel stage_0;
        protected final BlockStateModel stage_1;
        protected final BlockStateModel stage_2;
        protected final BlockStateModel stage_3;

        public Baked(BlockStateModel opened, BlockStateModel stage_0, BlockStateModel stage_1, BlockStateModel stage_2, BlockStateModel stage_3) {
            this.opened = opened;
            this.stage_0 = stage_0;
            this.stage_1 = stage_1;
            this.stage_2 = stage_2;
            this.stage_3 = stage_3;
        }

        public void collectParts(@NonNull RandomSource random, @NonNull List<BlockModelPart> output) {
            this.stage_0.collectParts(random, output);
        }

        public TextureAtlasSprite particleIcon() {
            return this.opened.particleIcon();
        }

        protected abstract boolean isOpenFromBATG(BlockAndTintGetter var1, BlockPos var2, BlockState var3, RandomSource var4);

        public Object internalCreateObjectKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
            if (this.isOpenFromBATG(level, pos, state, random)) {
                return 4;
            }
            return state.getValue((Property)BlockStateProperties.DUSTED);
        }
    }
}

