/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.BuiltInLootrTypes;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BaseLootrInfo(@Deprecated @Nullable LootrBlockType blockType, @Deprecated @Nullable ILootrInfo.LootrInfoType infoType, @Nullable ILootrType type, UUID uuid, String cachedKey, BlockPos pos, @Nullable Component name, ResourceKey<Level> dimension, int containerSize, NonNullList<ItemStack> customInventory, ResourceKey<LootTable> table, long seed) implements ILootrInfo
{
    public BaseLootrInfo(Optional<LootrBlockType> lootrBlockType, Optional<ILootrInfo.LootrInfoType> lootrInfoType, Optional<ILootrType> iLootrType, UUID uuid, String s, BlockPos pos, Optional<Component> component, ResourceKey<Level> levelResourceKey, Integer integer, Optional<NonNullList<ItemStack>> itemStacks, Optional<ResourceKey<LootTable>> lootTableResourceKey, Optional<Long> aLong) {
        this(lootrBlockType.orElse(null), lootrInfoType.orElse(null), iLootrType.orElse(null), uuid, s, pos, component.orElse(null), levelResourceKey, (int)integer, (NonNullList<ItemStack>)((NonNullList)itemStacks.orElse(null)), (ResourceKey<LootTable>)((ResourceKey)lootTableResourceKey.orElse(null)), aLong.orElse(-1L));
    }

    public BaseLootrInfo(@Deprecated @Nullable LootrBlockType blockType, @Deprecated @Nullable ILootrInfo.LootrInfoType infoType, @Nullable ILootrType type, UUID uuid, String cachedKey, BlockPos pos, @Nullable Component name, ResourceKey<Level> dimension, int containerSize, NonNullList<ItemStack> customInventory, ResourceKey<LootTable> table, long seed) {
        this.blockType = blockType;
        this.infoType = infoType;
        this.type = BaseLootrInfo.resolveType(blockType, infoType, type);
        this.uuid = uuid;
        this.cachedKey = cachedKey;
        this.pos = pos;
        this.name = name;
        this.dimension = dimension;
        this.containerSize = containerSize;
        this.customInventory = customInventory;
        this.table = table;
        this.seed = seed;
    }

    public static BaseLootrInfo copy(ILootrInfo info) {
        return new BaseLootrInfo(info.getInfoBlockType(), info.getInfoType(), info.getInfoNewType(), info.getInfoUUID(), info.getInfoKey(), info.getInfoPos(), info.getInfoDisplayName(), info.getInfoDimension(), info.getInfoContainerSize(), info.getInfoReferenceInventory(), info.getInfoLootTable(), info.getInfoLootSeed());
    }

    public static ILootrType resolveType(@Nullable LootrBlockType blockType, @Nullable ILootrInfo.LootrInfoType infoType, @Nullable ILootrType type) {
        if (type != null) {
            return type;
        }
        if (blockType != null) {
            return BuiltInLootrTypes.fromLegacy(blockType);
        }
        if (infoType != null) {
            if (infoType == ILootrInfo.LootrInfoType.CONTAINER_BLOCK_ENTITY) {
                return BuiltInLootrTypes.CHEST;
            }
            if (infoType == ILootrInfo.LootrInfoType.CONTAINER_ENTITY) {
                return BuiltInLootrTypes.MINECART;
            }
        }
        return BuiltInLootrTypes.CHEST;
    }

    @Override
    @Deprecated
    @Nullable
    public LootrBlockType getInfoBlockType() {
        return this.blockType();
    }

    @Override
    @Deprecated
    @Nullable
    public ILootrInfo.LootrInfoType getInfoType() {
        return this.infoType();
    }

    @Override
    @Nullable
    public ILootrType getInfoNewType() {
        return this.type();
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        return this.uuid();
    }

    @Override
    public String getInfoKey() {
        return this.cachedKey();
    }

    @Override
    public boolean hasBeenOpened() {
        return false;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return false;
    }

    @Override
    @NotNull
    public BlockPos getInfoPos() {
        return this.pos();
    }

    @Override
    public Component getInfoDisplayName() {
        if (this.name == null) {
            return Component.empty();
        }
        return this.name;
    }

    @Override
    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return this.containerSize();
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return this.customInventory();
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return this.customInventory() != null && !this.customInventory().isEmpty();
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getInfoLootTable() {
        return this.table();
    }

    @Override
    public long getInfoLootSeed() {
        return this.seed();
    }

    @Override
    public Level getInfoLevel() {
        return this.getDefaultLevel();
    }
}

