/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecartContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import noobanidus.mods.lootr.common.api.adapter.ILootrItemFrameAdapter;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.data.entity.ILootrEntity;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface IPlatformAPI {
    public void performEntityOpen(ILootrEntity var1, ServerPlayer var2);

    @Deprecated
    default public void performCartOpen(ILootrCart cart, ServerPlayer player) {
        this.performEntityOpen(cart, player);
    }

    @Deprecated
    default public void performCartOpen(ILootrCart cart) {
        this.performEntityOpen(cart);
    }

    public void performEntityOpen(ILootrEntity var1);

    @Deprecated
    default public void performCartClose(ILootrCart cart, ServerPlayer player) {
        this.performEntityClose(cart, player);
    }

    public void performEntityClose(ILootrEntity var1, ServerPlayer var2);

    @Deprecated
    default public void performCartClose(ILootrCart cart) {
        this.performEntityClose(cart);
    }

    public void performEntityClose(ILootrEntity var1);

    public void performBlockOpen(ILootrBlockEntity var1, ServerPlayer var2);

    public void performBlockOpen(ILootrBlockEntity var1);

    public void performBlockClose(ILootrBlockEntity var1, ServerPlayer var2);

    public void performBlockClose(ILootrBlockEntity var1);

    public DataToCopy copySpecificData(BlockEntity var1);

    public void restoreSpecificData(DataToCopy var1, BlockEntity var2);

    @Deprecated
    default public void copyEntityData(AbstractMinecartContainer entity1, AbstractMinecartContainer entity2) {
        entity2.setXRot(entity1.getXRot());
        entity2.setYRot(entity1.getYRot());
        entity2.setYHeadRot(entity1.getYHeadRot());
        if (entity1.getLootTable() != null) {
            entity2.setLootTable(entity1.getContainerLootTable(), entity1.getContainerLootTableSeed());
        }
    }

    default public void copyEntityData(ILootrDataAdapter<Entity> adapter, Entity entity1, ILootrEntity entity3) {
        Entity entity2 = entity3.asEntity();
        entity2.setXRot(entity1.getXRot());
        entity2.setYRot(entity1.getYRot());
        entity2.setYHeadRot(entity1.getYHeadRot());
        ResourceKey<LootTable> lootTable = adapter.getLootTable(entity1);
        long seed = adapter.getLootSeed(entity1);
        if (lootTable != null && entity2 instanceof AbstractMinecartContainer) {
            AbstractMinecartContainer entity4 = (AbstractMinecartContainer)entity2;
            entity4.setLootTable(lootTable, seed);
        }
    }

    default public void copyEntityData(ILootrItemFrameAdapter<Entity> adapter, Entity entity1, ILootrEntity entity3) {
        Entity entity2 = entity3.asEntity();
        entity2.setXRot(entity1.getXRot());
        entity2.setYRot(entity1.getYRot());
        entity2.setYHeadRot(entity1.getYHeadRot());
    }

    public void refreshPlayerSection(ServerPlayer var1);

    public void performPotBreak(ILootrBlockEntity var1, ServerPlayer var2);

    public boolean shouldDoInitialSave();
}

