/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import com.google.auto.service.AutoService;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import noobanidus.mods.lootr.common.api.BuiltInLootrTypes;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.PotDecorationsAdapter;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.SimpleLootrInstance;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrDecoratedPotBlockEntity
extends BlockEntity
implements RandomizableContainer,
ContainerSingleItem.BlockContainerSingleItem,
ILootrBlockEntity {
    public long wobbleStartedAtTick;
    @Nullable
    public DecoratedPotBlockEntity.WobbleStyle lastWobbleStyle;
    @Nullable
    private PotDecorationsAdapter decorations;
    @Nullable
    protected ResourceKey<LootTable> lootTable;
    protected long lootTableSeed;
    private final SimpleLootrInstance lootrInstance = new SimpleLootrInstance(this::getVisualOpeners, 1);

    public LootrDecoratedPotBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(LootrRegistry.getDecoratedPotBlockEntity(), blockPos, blockState);
        this.decorations = PotDecorationsAdapter.EMPTY;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.trySaveLootTable(compoundTag);
        this.getDecorations().save(compoundTag);
        this.lootrInstance.saveAdditional(compoundTag, provider, this.level == null || this.level.isClientSide());
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.decorations = this.getDecorations().load(compoundTag);
        this.tryLoadLootTable(compoundTag);
        this.lootrInstance.loadAdditional(compoundTag, provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compoundTag = super.getUpdateTag(provider);
        this.saveAdditional(compoundTag, provider);
        this.lootrInstance.fillUpdateTag(compoundTag, provider, this.level != null && this.level.isClientSide());
        return compoundTag;
    }

    @Nullable
    public ItemStack popItem(ServerPlayer player) {
        ILootrInventory inventory = LootrAPI.getInventory(this, player);
        if (inventory == null) {
            return null;
        }
        ItemStack result = inventory.getItem(0);
        if (result.isEmpty()) {
            return null;
        }
        inventory.setItem(0, ItemStack.EMPTY);
        inventory.setChanged();
        this.performTrigger(player);
        boolean shouldUpdate = false;
        if (!this.hasServerOpened((Player)player)) {
            player.awardStat(LootrRegistry.getLootedStat());
            LootrRegistry.getStatTrigger().trigger(player);
        }
        if (this.addOpener((Player)player)) {
            this.performOpen(player);
            shouldUpdate = true;
        }
        this.lootrInstance.setHasBeenOpened();
        if (shouldUpdate) {
            this.performUpdate(player);
        }
        return result;
    }

    @Override
    public void performOpen(ServerPlayer player) {
        ILootrBlockEntity.super.performOpen(player);
        PlatformAPI.performPotBreak(this, player);
    }

    public boolean dropContent(ServerPlayer player) {
        ItemStack theItem;
        if (this.level != null && this.level.getServer() != null && (theItem = this.popItem(player)) != null) {
            double d = EntityType.ITEM.getWidth();
            double e = 1.0 - d;
            double f = d / 2.0;
            Direction direction = Direction.UP;
            BlockPos blockPos = this.worldPosition.relative(direction, 1);
            double g = (double)blockPos.getX() + 0.5 * e + f;
            double h = (double)blockPos.getY() + 0.5 + (double)(EntityType.ITEM.getHeight() / 2.0f);
            double i = (double)blockPos.getZ() + 0.5 * e + f;
            ItemEntity itemEntity = new ItemEntity(this.level, g, h, i, theItem.split(this.level.random.nextInt(21) + 10));
            itemEntity.setDeltaMovement(Vec3.ZERO);
            this.level.addFreshEntity((Entity)itemEntity);
            for (ItemStack item : this.getDecorations().ordered()) {
                ItemStack sherdStack = item.copy();
                ItemEntity sherdEntity = new ItemEntity(this.level, g, h, i, sherdStack);
                sherdEntity.setDeltaMovement(Vec3.ZERO);
                this.level.addFreshEntity((Entity)sherdEntity);
            }
            PlatformAPI.performPotBreak(this, player);
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public PotDecorationsAdapter getDecorations() {
        if (this.decorations == null) {
            this.decorations = PotDecorationsAdapter.EMPTY;
        }
        return this.decorations;
    }

    public void setFromItem(ItemStack itemStack) {
        this.applyComponentsFromItemStack(itemStack);
    }

    public ItemStack getPotAsItem() {
        ItemStack itemStack = LootrRegistry.getDecoratedPotItem().getDefaultInstance();
        itemStack.applyComponents(this.collectComponents());
        return itemStack;
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> resourceKey) {
        this.lootTable = resourceKey;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long l) {
        this.lootTableSeed = l;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.lootTable != null) {
            builder.set(DataComponents.CONTAINER_LOOT, (Object)new SeededContainerLoot(this.lootTable, this.lootTableSeed));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        super.applyImplicitComponents(dataComponentInput);
        this.decorations = LootrAPI.getDecorationsAdapter(dataComponentInput);
        SeededContainerLoot loot = (SeededContainerLoot)dataComponentInput.get(DataComponents.CONTAINER_LOOT);
        if (loot != null && loot.lootTable() != null) {
            this.lootTable = loot.lootTable();
            this.lootTableSeed = loot.seed();
        }
    }

    public void removeComponentsFromTag(CompoundTag compoundTag) {
        super.removeComponentsFromTag(compoundTag);
        compoundTag.remove("LootTable");
        compoundTag.remove("LootTableSeed");
    }

    public ItemStack getTheItem() {
        return ItemStack.EMPTY;
    }

    public ItemStack splitTheItem(int i) {
        return ItemStack.EMPTY;
    }

    public void setTheItem(ItemStack itemStack) {
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public void wobble(DecoratedPotBlockEntity.WobbleStyle wobbleStyle) {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, wobbleStyle.ordinal());
        }
    }

    public boolean triggerEvent(int i, int j) {
        if (this.level != null && i == 1 && j >= 0 && j < DecoratedPotBlockEntity.WobbleStyle.values().length) {
            this.wobbleStartedAtTick = this.level.getGameTime();
            this.lastWobbleStyle = DecoratedPotBlockEntity.WobbleStyle.values()[j];
            return true;
        }
        return super.triggerEvent(i, j);
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.lootrInstance.getClientOpeners();
    }

    @Override
    public boolean isClientOpened() {
        return this.lootrInstance.isClientOpened();
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.lootrInstance.setClientOpened(opened);
    }

    @Override
    public void markChanged() {
        this.setChanged();
        this.markDataChanged();
    }

    @Override
    @Deprecated
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.CHEST;
    }

    @Override
    public ILootrType getInfoNewType() {
        return BuiltInLootrTypes.POT;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        return this.lootrInstance.getInfoUUID();
    }

    @Override
    public String getInfoKey() {
        return this.lootrInstance.getInfoKey();
    }

    @Override
    public boolean hasBeenOpened() {
        return this.lootrInstance.hasBeenOpened();
    }

    @Override
    public boolean isPhysicallyOpen() {
        return false;
    }

    @Override
    @NotNull
    public BlockPos getInfoPos() {
        return this.getBlockPos();
    }

    @Override
    @Nullable
    public Component getInfoDisplayName() {
        return null;
    }

    @Override
    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.level.dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return 1;
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return null;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getInfoLootTable() {
        return this.lootTable;
    }

    @Override
    public long getInfoLootSeed() {
        return this.lootTableSeed;
    }

    @Override
    public Level getInfoLevel() {
        return this.level;
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        return LootrRegistry.getPotTrigger();
    }

    @Override
    public double getParticleYOffset() {
        return 1.3;
    }

    @Override
    public double[] getParticleXBounds() {
        return new double[]{0.4, 0.6};
    }

    @Override
    public double[] getParticleZBounds() {
        return new double[]{0.4, 0.6};
    }

    @AutoService(value={ILootrBlockEntityConverter.class})
    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrDecoratedPotBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrDecoratedPotBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public BlockEntityType<?> getBlockEntityType() {
            return LootrRegistry.getDecoratedPotBlockEntity();
        }
    }
}

