/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.BuiltInLootrTypes;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ILootrInfo {
    @Deprecated
    @Nullable
    public LootrBlockType getInfoBlockType();

    @Deprecated
    @Nullable
    public LootrInfoType getInfoType();

    @Nullable
    public ILootrType getInfoNewType();

    default public LootFiller getDefaultFiller() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return DefaultLootFiller.getInstance();
        }
        return type.getDefaultFiller();
    }

    default public boolean canRefresh() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canRefresh();
    }

    default public boolean canDecay() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canDecay();
    }

    default public boolean canBeMarkedUnopened() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canBeMarkedUnopened();
    }

    default public boolean canDropContentsWhenBroken() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return true;
        }
        return type.canDropContentsWhenBroken();
    }

    @Deprecated
    @Nullable
    default public Block getReplacementBlock() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return null;
        }
        return type.getReplacementBlock();
    }

    @Deprecated
    @Nullable
    default public EntityType<?> getReplacementEntity() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return null;
        }
        return type.getReplacementEntity();
    }

    @Deprecated
    default public boolean isEntity() {
        ILootrType type = this.getInfoNewType();
        if (type == null) {
            return false;
        }
        return type.isEntity();
    }

    @NotNull
    default public Vec3 getInfoVec() {
        return Vec3.atCenterOf((Vec3i)this.getInfoPos());
    }

    @NotNull
    public UUID getInfoUUID();

    public String getInfoKey();

    public static String generateInfoKey(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public boolean hasBeenOpened();

    public boolean isPhysicallyOpen();

    @NotNull
    public BlockPos getInfoPos();

    @Nullable
    public Component getInfoDisplayName();

    @NotNull
    public ResourceKey<Level> getInfoDimension();

    public int getInfoContainerSize();

    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory();

    default public boolean canPlayerOpen(ServerPlayer player) {
        return true;
    }

    default public void informPlayerCannotOpen(ServerPlayer player) {
    }

    public boolean isInfoReferenceInventory();

    @Nullable
    public ResourceKey<LootTable> getInfoLootTable();

    public long getInfoLootSeed();

    public Level getInfoLevel();

    @Nullable
    default public Level getDefaultLevel() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            return null;
        }
        return server.getLevel(this.getInfoDimension());
    }

    @Nullable
    default public Container getInfoContainer() {
        ServerLevel level;
        Level level2 = this.getInfoLevel();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return null;
        }
        if (this.getInfoNewType() == null) {
            BlockEntity be = level.getBlockEntity(this.getInfoPos());
            if (be instanceof Container) {
                Container container = (Container)be;
                return container;
            }
            Entity entity = level.getEntity(this.getInfoUUID());
            if (entity instanceof Container) {
                Container container = (Container)entity;
                return container;
            }
            LootrAPI.LOG.warn("Unable to guess container type for LootrInfo with key '{}'", (Object)this.getInfoKey());
            return null;
        }
        return this.getInfoNewType().getContainer(this, level);
    }

    default public NonNullList<ItemStack> buildInitialInventory() {
        return NonNullList.withSize((int)this.getInfoContainerSize(), (Object)ItemStack.EMPTY);
    }

    default public void saveInfoToTag(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.getInfoType() != null) {
            tag.putInt("type", this.getInfoType().ordinal());
        }
        if (this.getInfoNewType() != null) {
            tag.putString("newType", this.getInfoNewType().getName());
        }
        if (this.getInfoBlockType() != null) {
            tag.putInt("blockType", this.getInfoBlockType().ordinal());
        }
        tag.put("position", NbtUtils.writeBlockPos((BlockPos)this.getInfoPos()));
        tag.putString("key", this.getInfoKey());
        tag.putString("dimension", this.getInfoDimension().location().toString());
        tag.putUUID("uuid", this.getInfoUUID());
        tag.putInt("size", this.getInfoContainerSize());
        if (this.getInfoLootTable() != null) {
            tag.putString("table", this.getInfoLootTable().location().toString());
            tag.putLong("seed", this.getInfoLootSeed());
        }
        if (this.getInfoDisplayName() != null) {
            tag.putString("name", Component.Serializer.toJson((Component)this.getInfoDisplayName(), (HolderLookup.Provider)provider));
        }
        if (this.isInfoReferenceInventory()) {
            tag.putInt("referenceSize", this.getInfoReferenceInventory().size());
            tag.put("reference", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.getInfoReferenceInventory(), (boolean)true, (HolderLookup.Provider)provider));
        }
    }

    public static ILootrInfo loadInfoFromTag(CompoundTag tag, HolderLookup.Provider provider) {
        ILootrType type = null;
        if (tag.contains("newType", 8) && (type = LootrAPI.getType(tag.getString("newType"))) == null) {
            LootrAPI.LOG.error("Couldn't find LootrType '{}' when loading LootrInfo from tag: {}", (Object)tag.getString("newType"), (Object)tag);
            throw new IllegalStateException("Couldn't find LootrType '" + tag.getString("newType") + "' when loading LootrInfo from tag: " + String.valueOf(tag));
        }
        if (type == null) {
            if (tag.contains("blockType", 3)) {
                LootrBlockType oldType = LootrBlockType.values()[tag.getInt("blockType")];
                type = BuiltInLootrTypes.fromLegacy(oldType);
            } else if (tag.contains("type", 3)) {
                type = BuiltInLootrTypes.CHEST;
            } else if (tag.contains("entity") && tag.getBoolean("entity")) {
                type = BuiltInLootrTypes.MINECART;
            }
        }
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"position").orElse(BlockPos.ZERO);
        UUID uuid = tag.getUUID("uuid");
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("dimension")));
        int size = tag.getInt("size");
        MutableComponent name = null;
        if (tag.contains("name")) {
            name = Component.Serializer.fromJson((String)tag.getString("name"), (HolderLookup.Provider)provider);
        }
        NonNullList reference = null;
        if (tag.contains("reference") && tag.contains("referenceSize")) {
            reference = NonNullList.withSize((int)tag.getInt("referenceSize"), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)tag.getCompound("reference"), (NonNullList)reference, (HolderLookup.Provider)provider);
            type = BuiltInLootrTypes.INVENTORY;
        }
        ResourceKey table = null;
        long seed = -1L;
        if (tag.contains("table")) {
            table = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("table")));
            seed = tag.getLong("seed");
        }
        if (type == null) {
            LootrAPI.LOG.error("Couldn't determine LootrType when loading LootrInfo from tag, guessing chest: {}", (Object)tag);
            type = BuiltInLootrTypes.CHEST;
        }
        return new BaseLootrInfo(null, null, type, uuid, ILootrInfo.generateInfoKey(uuid), pos, (Component)name, (ResourceKey<Level>)dimension, size, (NonNullList<ItemStack>)reference, (ResourceKey<LootTable>)table, seed);
    }

    @Deprecated
    public static enum LootrInfoType {
        CONTAINER_BLOCK_ENTITY,
        CONTAINER_ENTITY;

    }
}

