/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.replacement.BlockReplacementMap;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.ApiStatus;

public interface ILootrBlockEntity
extends ILootrInfoProvider {
    public static <T extends BlockEntity> void ticker(Level level, BlockPos pos, BlockState state, T blockEntity) {
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity) {
            ILootrBlockEntity t = iLootrBlockEntity;
            if (level.isClientSide() || t.hasLootTable()) {
                t.defaultTick(level, pos, state);
            }
        }
    }

    default public boolean hasLootTable() {
        return this.getInfoLootTable() != null;
    }

    default public void defaultTick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            LootrAPI.handleProviderTick(this);
        }
    }

    default public BlockEntity asBlockEntity() {
        ILootrBlockEntity iLootrBlockEntity = this;
        if (iLootrBlockEntity instanceof BlockEntity) {
            BlockEntity entity = (BlockEntity)iLootrBlockEntity;
            return entity;
        }
        throw new NullPointerException("ILootrBlockEntity implementation is not a BlockEntity and doesn't provide asBlockEntity()!");
    }

    @Override
    @Deprecated
    default public ILootrInfo.LootrInfoType getInfoType() {
        return ILootrInfo.LootrInfoType.CONTAINER_BLOCK_ENTITY;
    }

    default public void updatePacketViaForce() {
        this.updatePacketViaForce(this.asBlockEntity());
    }

    default public void updatePacketViaForce(BlockEntity entity) {
        Level level = entity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Packet packet = entity.getUpdatePacket();
            if (packet != null) {
                level2.getChunkSource().chunkMap.getPlayers(new ChunkPos(entity.getBlockPos()), false).forEach(player -> player.connection.send(packet));
            }
        }
    }

    @Override
    default public void performOpen(ServerPlayer player) {
        PlatformAPI.performBlockOpen(this, player);
    }

    @Override
    default public void performOpen() {
        PlatformAPI.performBlockOpen(this);
    }

    @Override
    default public void performClose(ServerPlayer player) {
        PlatformAPI.performBlockClose(this, player);
    }

    @Override
    default public void performClose() {
        PlatformAPI.performBlockClose(this);
    }

    @Override
    default public void performDecay() {
        Block replacementBlock;
        Level level = this.getInfoLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        BlockState stateAt = level.getBlockState(this.getInfoPos());
        boolean replaceWhenDecayed = LootrAPI.shouldReplaceWhenDecayed();
        level.destroyBlock(this.getInfoPos(), !replaceWhenDecayed);
        if (replaceWhenDecayed && (replacementBlock = this.getInfoNewType().getReplacementBlock()) != null) {
            BlockState replacementState = replacementBlock.defaultBlockState();
            for (Property prop : replacementState.getProperties()) {
                if (!stateAt.hasProperty(prop)) continue;
                replacementState = BlockReplacementMap.safeReplace(replacementState, stateAt, prop);
            }
            level.setBlock(this.getInfoPos(), replacementState, 2);
        }
    }

    @Override
    default public void performUpdate(ServerPlayer player) {
        this.performUpdate();
    }

    @Override
    default public void performUpdate() {
        this.markChanged();
        this.updatePacketViaForce();
    }

    @ApiStatus.Internal
    default public void setLootTableInternal(ResourceKey<LootTable> lootTable, long seed) {
        ILootrBlockEntity iLootrBlockEntity = this;
        if (!(iLootrBlockEntity instanceof RandomizableContainer)) {
            throw new NotImplementedException("setLootTableInternal called on ILootrBlockEntity that is not a RandomizableContainer without overriding!");
        }
        RandomizableContainer container = (RandomizableContainer)iLootrBlockEntity;
        container.setLootTable(lootTable, seed);
    }
}

